/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.calcite;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.avro.calcite.AbstractAvroTable;
import org.spf4j.avro.calcite.FilteringProjectingAvroEnumerable;
import org.spf4j.avro.calcite.InterpreterUtils;
import org.spf4j.base.CloseableIterator;

public final class AvroIteratorAsProjectableFilterableTable
extends AbstractAvroTable
implements ProjectableFilterableTable {
    private static final Logger LOG = LoggerFactory.getLogger(AvroIteratorAsProjectableFilterableTable.class);
    private final Supplier<CloseableIterator<? extends IndexedRecord>> dataSupplier;

    public AvroIteratorAsProjectableFilterableTable(Schema componentType, Supplier<CloseableIterator<? extends IndexedRecord>> dataSupplier) {
        super(componentType);
        this.dataSupplier = dataSupplier;
    }

    public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters, @Nullable int[] projection) {
        Schema componentType = this.getComponentType();
        LOG.debug("Filtered+Projected Table scan of {} with filter {} and projection {}", new Object[]{componentType.getName(), filters, projection});
        Scalar filter = InterpreterUtils.toScalar(filters, root.getTypeFactory(), this.getRowType((RelDataTypeFactory)root.getTypeFactory()));
        FilteringProjectingAvroEnumerable result = new FilteringProjectingAvroEnumerable(componentType, root, filter, projection, this.dataSupplier);
        if (filter != null) {
            filters.clear();
        }
        return result;
    }

    public String toString() {
        return "AvroProjectableFilterableTable{dataSupplier=" + this.dataSupplier + '}';
    }
}

