/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.calcite;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.spf4j.avro.AvroCompatUtils;
import org.spf4j.avro.schema.Schemas;

@SuppressFBWarnings(value={"CC_CYCLOMATIC_COMPLEXITY"})
public final class Types {
    private Types() {
    }

    public static Schema from(RelDataType dataType) {
        Schema result;
        SqlTypeName sqlTypeName = dataType.getSqlTypeName();
        switch (sqlTypeName) {
            case ROW: {
                List fieldList = dataType.getFieldList();
                ArrayList<Schema.Field> aFields = new ArrayList<Schema.Field>(fieldList.size());
                for (RelDataTypeField field : fieldList) {
                    aFields.add(AvroCompatUtils.createField((String)field.getName(), (Schema)Types.from(field.getType()), null, null, (boolean)false, (boolean)false, (Schema.Field.Order)Schema.Field.Order.IGNORE));
                }
                return Schema.createRecord(aFields);
            }
            case INTEGER: {
                result = Schema.create((Schema.Type)Schema.Type.INT);
                break;
            }
            case BIGINT: {
                result = Schema.create((Schema.Type)Schema.Type.LONG);
                break;
            }
            case VARCHAR: {
                result = Schema.create((Schema.Type)Schema.Type.STRING);
                break;
            }
            case DATE: {
                result = Schemas.dateString();
                break;
            }
            case TIMESTAMP: {
                result = Schemas.instantString();
                break;
            }
            case BINARY: {
                int precision = dataType.getPrecision();
                if (precision > 0) {
                    result = Schema.createFixed(null, null, null, (int)precision);
                    break;
                }
                result = Schema.create((Schema.Type)Schema.Type.BYTES);
                break;
            }
            case DOUBLE: 
            case REAL: 
            case DECIMAL: {
                result = Schema.create((Schema.Type)Schema.Type.DOUBLE);
                break;
            }
            case FLOAT: {
                result = Schema.create((Schema.Type)Schema.Type.FLOAT);
                break;
            }
            case BOOLEAN: {
                result = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
                break;
            }
            case ARRAY: 
            case MULTISET: {
                result = Schema.createArray((Schema)Types.from(dataType.getComponentType()));
                break;
            }
            case MAP: {
                result = Schema.createMap((Schema)Types.from(dataType.getValueType()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data Type " + dataType);
            }
        }
        if (dataType.isNullable()) {
            result = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), result});
        }
        return result;
    }

    public static RelDataType from(JavaTypeFactory fact, Schema schema, Map<Schema, RelDataType> defined) {
        RelDataType result;
        RelDataType ex = defined.get(schema);
        if (ex != null) {
            return ex;
        }
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType != null) {
            switch (logicalType.getName()) {
                case "date": {
                    return fact.createSqlType(SqlTypeName.DATE);
                }
                case "instant": {
                    return fact.createSqlType(SqlTypeName.TIMESTAMP);
                }
                case "decimal": {
                    return fact.createSqlType(SqlTypeName.DOUBLE);
                }
            }
        }
        switch (schema.getType()) {
            case STRING: {
                result = fact.createSqlType(SqlTypeName.VARCHAR);
                break;
            }
            case BOOLEAN: {
                result = fact.createSqlType(SqlTypeName.BOOLEAN);
                break;
            }
            case FIXED: {
                result = fact.createSqlType(SqlTypeName.BINARY, schema.getFixedSize());
                break;
            }
            case BYTES: {
                result = fact.createSqlType(SqlTypeName.BINARY);
                break;
            }
            case INT: {
                result = fact.createSqlType(SqlTypeName.INTEGER);
                break;
            }
            case ENUM: {
                result = fact.createSqlType(SqlTypeName.SYMBOL);
                break;
            }
            case DOUBLE: {
                result = fact.createSqlType(SqlTypeName.DOUBLE);
                break;
            }
            case FLOAT: {
                result = fact.createSqlType(SqlTypeName.FLOAT);
                break;
            }
            case LONG: {
                result = fact.createSqlType(SqlTypeName.BIGINT);
                break;
            }
            case RECORD: {
                result = fact.createStructType(Types.fromRecordSchema(fact, schema));
                break;
            }
            case MAP: {
                result = fact.createMapType(fact.createSqlType(SqlTypeName.VARCHAR), Types.from(fact, schema.getValueType(), defined));
                break;
            }
            case ARRAY: {
                result = fact.createArrayType(Types.from(fact, schema.getElementType(), defined), -1L);
                break;
            }
            case UNION: {
                Schema nullableUnionSchema = Schemas.nullableUnionSchema(schema);
                if (nullableUnionSchema != null) {
                    result = fact.createTypeWithNullability(Types.from(fact, nullableUnionSchema, defined), true);
                    break;
                }
                throw new UnsupportedOperationException("Unsupported: " + schema);
            }
            default: {
                throw new UnsupportedOperationException("Unsupported: " + schema);
            }
        }
        defined.put(schema, result);
        return result;
    }

    public static List<RelDataTypeField> fromRecordSchema(JavaTypeFactory fact, Schema schema) {
        List fields = schema.getFields();
        ArrayList<RelDataTypeField> result = new ArrayList<RelDataTypeField>(fields.size());
        IdentityHashMap<Schema, RelDataType> map = new IdentityHashMap<Schema, RelDataType>();
        for (Schema.Field field : fields) {
            result.add((RelDataTypeField)new RelDataTypeFieldImpl(field.name(), field.pos(), Types.from(fact, field.schema(), map)));
        }
        return result;
    }
}

