/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;

public final class ArrayIterator<T>
implements Iterator<T> {
    private final Decoder decoder;
    private final DatumReader<T> reader;
    private long l;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ArrayIterator(Decoder decoder, DatumReader<T> elementReader) {
        this.decoder = decoder;
        this.reader = elementReader;
        try {
            this.l = decoder.readArrayStart();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public boolean hasNext() {
        return this.l > 0L;
    }

    @Override
    public T next() {
        try {
            if (this.l <= 0L) {
                throw new NoSuchElementException();
            }
            Object read = this.reader.read(null, this.decoder);
            --this.l;
            if (this.l <= 0L) {
                this.l = this.decoder.arrayNext();
            }
            return (T)read;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String toString() {
        return "ArrayIterator{decoder=" + this.decoder + ", reader=" + this.reader + ", l=" + this.l + '}';
    }
}

