/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.specific.SpecificRecordBase;
import org.codehaus.commons.compiler.AbstractJavaSourceClassLoader;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.spf4j.avro.schema.SchemaUtils;
import org.spf4j.base.Strings;
import org.spf4j.io.DeletingVisitor;
import org.spf4j.io.SetFilesReadOnlyVisitor;

@Beta
public final class GenericRecordBuilder
implements Closeable {
    private final File tmpDir;
    private final GenericData.StringType stringType;
    private final AbstractJavaSourceClassLoader source;

    public GenericRecordBuilder(Schema ... schemas) {
        this(GenericData.StringType.String, schemas);
    }

    public GenericRecordBuilder(GenericData.StringType stringType, Schema ... schemas) {
        try {
            this.tmpDir = Files.createTempDirectory("avro-dynamic", new FileAttribute[0]).toFile();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.stringType = stringType;
        this.generateClasses(stringType, schemas);
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            AbstractJavaSourceClassLoader src = CompilerFactoryFactory.getDefaultCompilerFactory((ClassLoader)cl).newJavaSourceClassLoader(cl);
            src.setSourcePath(new File[]{this.tmpDir});
            this.source = src;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void generateClasses(GenericData.StringType st, Schema ... schemas) {
        CharSequence[] namespaces = new String[schemas.length];
        for (int i = 0; i < schemas.length; ++i) {
            String namespace = schemas[i].getNamespace();
            if (namespace == null) {
                namespace = "";
            }
            namespaces[i] = namespace;
        }
        String commonPrefix = Strings.commonPrefix((CharSequence[])namespaces);
        if (commonPrefix.endsWith(".")) {
            commonPrefix = commonPrefix.substring(0, commonPrefix.length() - 1);
        }
        Protocol proto = new Protocol("generated", commonPrefix);
        proto.setTypes(Arrays.asList(schemas));
        SpecificCompiler sc = new SpecificCompiler(proto);
        sc.setStringType(st);
        sc.setTemplateDir("org/spf4j/avro/");
        sc.setFieldVisibility(SpecificCompiler.FieldVisibility.PRIVATE);
        try {
            sc.compileToDestination(null, this.tmpDir);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        try {
            Files.walkFileTree(this.tmpDir.toPath(), (FileVisitor<? super Path>)new SetFilesReadOnlyVisitor());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public Class<? extends SpecificRecordBase> getRecordClass(Schema schema) {
        Preconditions.checkArgument((boolean)SchemaUtils.isNamedType(schema), (String)"schema %s has no java class", (Object)schema);
        try {
            return this.source.loadClass(SchemaUtils.getJavaClassName(schema));
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Class<? extends GenericEnumSymbol> getEnumClass(Schema schema) {
        Preconditions.checkArgument((boolean)SchemaUtils.isNamedType(schema), (String)"schema %s has no java class", (Object)schema);
        try {
            return this.source.loadClass(SchemaUtils.getJavaClassName(schema));
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Class<? extends GenericFixed> getFixedClass(Schema schema) {
        Preconditions.checkArgument((boolean)SchemaUtils.isNamedType(schema), (String)"schema %s has no java class", (Object)schema);
        try {
            return this.source.loadClass(SchemaUtils.getJavaClassName(schema));
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void close() {
        try {
            Files.walkFileTree(this.tmpDir.toPath(), (FileVisitor<? super Path>)new DeletingVisitor());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String toString() {
        return "GenericRecordBuilder{tmpDir=" + this.tmpDir + ", stringType=" + this.stringType + ", source=" + this.source + '}';
    }
}

