/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.calcite;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.spf4j.avro.calcite.Types;

abstract class AbstractAvroTable
implements Table {
    private final Schema componentType;

    AbstractAvroTable(Schema componentType) {
        if (componentType.getType() != Schema.Type.RECORD) {
            throw new IllegalArgumentException("Invalid table compoent " + componentType);
        }
        this.componentType = componentType;
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public final RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return Types.from((JavaTypeFactory)typeFactory, this.componentType, new HashMap<Schema, RelDataType>());
    }

    @Nonnull
    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }

    public final Schema.TableType getJdbcTableType() {
        return Schema.TableType.TABLE;
    }

    public final boolean isRolledUp(String column) {
        return false;
    }

    public final boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
        return true;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public final Schema getComponentType() {
        return this.componentType;
    }
}

