/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.calcite;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.avro.AvroDataSet;
import org.spf4j.avro.calcite.AbstractAvroTable;
import org.spf4j.avro.calcite.AvroEnumerable;
import org.spf4j.avro.calcite.EmbededDataContext;
import org.spf4j.avro.calcite.SqlConverters;
import org.spf4j.avro.calcite.SqlRowPredicate;
import org.spf4j.avro.calcite.TableAccessDeniedException;
import org.spf4j.avro.schema.Schemas;
import org.spf4j.base.CloseableIterable;
import org.spf4j.base.CloseableIterator;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.security.AbacSecurityContext;

@ParametersAreNonnullByDefault
public final class AvroDataSetAsProjectableFilterableTable
extends AbstractAvroTable
implements ProjectableFilterableTable {
    private static final Logger LOG = LoggerFactory.getLogger(AvroDataSetAsProjectableFilterableTable.class);
    private final AvroDataSet<? extends IndexedRecord> dataSet;

    public AvroDataSetAsProjectableFilterableTable(AvroDataSet<? extends IndexedRecord> dataSet) {
        super(dataSet.getElementSchema());
        this.dataSet = dataSet;
    }

    public AvroDataSet<? extends IndexedRecord> getDataSet() {
        return this.dataSet;
    }

    @Override
    public Statistic getStatistic() {
        long rowCountStatistic = this.dataSet.getRowCountStatistic();
        if (rowCountStatistic >= 0L) {
            return Statistics.of((double)rowCountStatistic, (List)Collections.EMPTY_LIST);
        }
        return Statistics.of((List)Collections.EMPTY_LIST);
    }

    private CloseableIterable<IndexedRecord> project(CloseableIterable<IndexedRecord> iterable, @Nullable int[] projection) {
        if (projection == null) {
            return iterable;
        }
        Schema schema = this.getComponentType();
        Schema nschema = Schemas.projectRecord(schema, projection);
        Iterable transformed = Iterables.transform(iterable, x -> Schemas.project(nschema, schema, x));
        return CloseableIterable.from((Iterable)transformed, iterable);
    }

    private void deprecations(@Nullable int[] projection, DataContext ctx) {
        Schema schema = this.getComponentType();
        if (projection == null) {
            EmbededDataContext.addDeprecations(schema, ctx);
        } else {
            Schema nschema = Schemas.projectRecord(schema, projection);
            EmbededDataContext.addDeprecations(nschema, ctx);
        }
    }

    public Enumerable<@Nullable Object[]> scan(DataContext root, List<RexNode> filters, @Nullable int[] projection) {
        CloseableIterable<IndexedRecord> it;
        AbacSecurityContext sc;
        LOG.debug("Filtered+Projected Table scan of {} with filter {} and projection {}", new Object[]{this.dataSet.getName(), filters, projection});
        this.deprecations(projection, root);
        RelDataType rowType = this.getRowType((RelDataTypeFactory)root.getTypeFactory());
        Long timeoutMillis = (Long)DataContext.Variable.TIMEOUT.get(root);
        if (timeoutMillis == null) {
            timeoutMillis = ExecutionContexts.getTimeToDeadlineUnchecked((TimeUnit)TimeUnit.MILLISECONDS);
        }
        if ((sc = (AbacSecurityContext)root.get("security-context")) == null) {
            sc = AbacSecurityContext.NOAUTH;
        }
        String objectName = this.getComponentType().getFullName();
        List<String> colNames = SqlConverters.projectionToString(projection, rowType);
        Properties env = new Properties();
        Properties readAction = AbacSecurityContext.action((String)"read");
        if (!sc.canAccess(AbacSecurityContext.resource((String)"table", (String)objectName), readAction, env)) {
            throw new TableAccessDeniedException("No read permission for " + objectName);
        }
        for (String colName : colNames) {
            String colObject = objectName + '.' + colName;
            if (sc.canAccess(AbacSecurityContext.resource((String)"column", (String)colObject), readAction, env)) continue;
            throw new TableAccessDeniedException("No read permission for " + colObject);
        }
        Set<AvroDataSet.Feature> features = this.dataSet.getFeatures();
        if (features.contains((Object)AvroDataSet.Feature.FILTERABLE)) {
            SqlRowPredicate predicate = null;
            try {
                if (!filters.isEmpty()) {
                    predicate = new SqlRowPredicate(filters, rowType);
                }
            }
            catch (RuntimeException ex) {
                LOG.debug("Unable to resolve filter {}", filters, (Object)ex);
            }
            if (predicate != null) {
                it = features.contains((Object)AvroDataSet.Feature.PROJECTABLE) ? this.dataSet.getData(predicate, colNames, sc, timeoutMillis, TimeUnit.MINUTES) : this.project(this.dataSet.getData(predicate, null, sc, timeoutMillis, TimeUnit.MINUTES), projection);
                filters.clear();
            } else {
                it = features.contains((Object)AvroDataSet.Feature.PROJECTABLE) ? this.dataSet.getData(null, colNames, sc, timeoutMillis, TimeUnit.MINUTES) : this.project(this.dataSet.getData(null, null, sc, timeoutMillis, TimeUnit.MINUTES), projection);
            }
        } else {
            it = features.contains((Object)AvroDataSet.Feature.PROJECTABLE) ? this.dataSet.getData(null, colNames, sc, timeoutMillis, TimeUnit.MINUTES) : this.project(this.dataSet.getData(null, null, sc, timeoutMillis, TimeUnit.MINUTES), projection);
        }
        return new AvroEnumerable(projection == null ? rowType.getFieldCount() : projection.length, root, () -> CloseableIterator.from((Iterator)it.iterator(), (AutoCloseable)it));
    }

    public String toString() {
        return "AvroDataSetAsProjectableFilterableTable{dataSet=" + this.dataSet + '}';
    }
}

