/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.calcite;

import java.util.List;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.FilterableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.avro.calcite.AbstractAvroTable;
import org.spf4j.avro.calcite.FilteringProjectingAvroEnumerable;
import org.spf4j.avro.calcite.InterpreterUtils;
import org.spf4j.base.CloseableIterator;

public final class AvroFilterableTable
extends AbstractAvroTable
implements FilterableTable {
    private static final Logger LOG = LoggerFactory.getLogger(AvroFilterableTable.class);
    private final Supplier<CloseableIterator<? extends IndexedRecord>> dataSupplier;

    public AvroFilterableTable(Schema componentType, Supplier<CloseableIterator<? extends IndexedRecord>> dataSupplier) {
        super(componentType);
        this.dataSupplier = dataSupplier;
    }

    public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters) {
        Schema componentType = this.getComponentType();
        LOG.debug("Filtered Table scan of {} with filter {} and projection {}", (Object)componentType.getName(), filters);
        Scalar filter = InterpreterUtils.toScalar(filters, this.getRowType((RelDataTypeFactory)root.getTypeFactory()), root);
        FilteringProjectingAvroEnumerable result = new FilteringProjectingAvroEnumerable(componentType, root, filter, null, this.dataSupplier);
        if (filter != null) {
            filters.clear();
        }
        return result;
    }

    public String toString() {
        return "AvroFilterableTable{dataSupplier=" + this.dataSupplier + '}';
    }
}

