/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.calcite;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.Lex;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.interpreter.Spf4jDataContext;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.spf4j.avro.calcite.AvroIteratorAsProjectableFilterableTable;
import org.spf4j.avro.calcite.EmbededDataContext;
import org.spf4j.avro.calcite.IndexedRecords;
import org.spf4j.avro.calcite.InterpreterUtils;
import org.spf4j.avro.calcite.Types;
import org.spf4j.base.CloseableIterator;

@ParametersAreNonnullByDefault
public final class FilterUtils {
    private static final SqlParser.Config PARSER_CFG = SqlParser.configBuilder().setCaseSensitive(true).setIdentifierMaxLength(255).setLex(Lex.JAVA).build();
    private static final JavaTypeFactoryImpl JAVA_TYPE_FACTORY = new JavaTypeFactoryImpl();

    private FilterUtils() {
    }

    public static SqlNode parse(String expr) throws SqlParseException {
        SqlParser parser = SqlParser.create((String)expr, (SqlParser.Config)PARSER_CFG);
        return parser.parseExpression();
    }

    public static Predicate<IndexedRecord> toPredicate(String sqlExpr, Schema recSchema) throws SqlParseException, ValidationException, RelConversionException {
        return FilterUtils.toPredicate(sqlExpr, JAVA_TYPE_FACTORY, recSchema);
    }

    public static Predicate<IndexedRecord> toPredicate(String sqlExpr, JavaTypeFactoryImpl javaTypeFactoryImpl, Schema recSchema) throws SqlParseException, ValidationException, RelConversionException {
        SchemaPlus schema = Frameworks.createRootSchema((boolean)true);
        schema.add("r", (Table)new AvroIteratorAsProjectableFilterableTable(recSchema, () -> CloseableIterator.from(Collections.EMPTY_LIST.iterator())));
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(PARSER_CFG).defaultSchema(schema).build();
        Planner planner = Frameworks.getPlanner((FrameworkConfig)config);
        SqlNode parse = planner.parse("select * from r where " + sqlExpr);
        parse = planner.validate(parse);
        RelNode project = planner.rel(parse).project();
        RexNode childExps = ((LogicalFilter)project.getInput(0)).getCondition();
        RelDataType from = Types.from((JavaTypeFactory)javaTypeFactoryImpl, recSchema, new HashMap<Schema, RelDataType>());
        return FilterUtils.toPredicate(Collections.singletonList(childExps), javaTypeFactoryImpl, from);
    }

    public static Predicate<IndexedRecord> toPredicate(List<RexNode> filter, RelDataType rowType) {
        return FilterUtils.toPredicate(filter, JAVA_TYPE_FACTORY, rowType);
    }

    public static Predicate<IndexedRecord> toPredicate(final List<RexNode> filter, JavaTypeFactoryImpl javaTypeFactoryImpl, RelDataType rowType) {
        final Spf4jDataContext context = new Spf4jDataContext(new EmbededDataContext((JavaTypeFactory)javaTypeFactoryImpl, null));
        context.values = new Object[rowType.getFieldCount()];
        final Scalar scalar = InterpreterUtils.toScalar(filter, rowType, context.root);
        return new Predicate<IndexedRecord>(){

            @Override
            public synchronized boolean test(IndexedRecord x) {
                IndexedRecords.copyRecord(x, context.values);
                Boolean result = (Boolean)scalar.execute((Context)context);
                if (result == null) {
                    throw new IllegalStateException("Filter predicate: " + filter + " cannot eval to null");
                }
                return result;
            }
        };
    }

    public static Predicate<IndexedRecord> toPredicate(@Nullable Iterable<String> expr, Schema recSchema) throws SqlParseException, ValidationException, RelConversionException {
        if (expr == null) {
            return x -> true;
        }
        Iterator<String> it = expr.iterator();
        if (!it.hasNext()) {
            return x -> true;
        }
        Predicate<IndexedRecord> result = FilterUtils.toPredicate(it.next(), recSchema);
        while (it.hasNext()) {
            result = result.and(FilterUtils.toPredicate(it.next(), recSchema));
        }
        return result;
    }
}

