/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.calcite;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.JaninoRexCompiler;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InterpreterUtils {
    private static final Logger LOG = LoggerFactory.getLogger(InterpreterUtils.class);

    private InterpreterUtils() {
    }

    @Nullable
    public static Scalar toScalar(List<RexNode> filters, RelDataType rowType, DataContext dataContext) {
        if (filters.isEmpty()) {
            return null;
        }
        RexBuilder rb = new RexBuilder((RelDataTypeFactory)dataContext.getTypeFactory());
        JaninoRexCompiler compiler = new JaninoRexCompiler(rb);
        try {
            return (Scalar)compiler.compile(filters, rowType).apply((Object)dataContext);
        }
        catch (UnsupportedOperationException ex) {
            LOG.warn("Unable to compile filter: {}", filters, (Object)ex);
            return null;
        }
    }
}

