/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.schema;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.Beta;
import com.google.common.collect.Sets;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.spf4j.base.Json;
import org.spf4j.ds.Graphs;
import org.spf4j.io.AppendableWriter;

public final class SchemaUtils {
    private static final boolean HAS_IDL_CYCLE_DEF_SUPPORT;
    public static final BiConsumer<Schema, Schema> SCHEMA_ESENTIALS;
    public static final BiConsumer<Schema.Field, Schema.Field> FIELD_ESENTIALS;
    public static final BiConsumer<Schema, Schema> SCHEMA_EVERYTHING;
    public static final BiConsumer<Schema.Field, Schema.Field> FIELD_EVERYTHING;

    private SchemaUtils() {
    }

    public static boolean isIdlCycleSupport() {
        return HAS_IDL_CYCLE_DEF_SUPPORT;
    }

    public static void copyAliases(Schema from, Schema to) {
        switch (from.getType()) {
            case RECORD: 
            case ENUM: 
            case FIXED: {
                Set aliases = from.getAliases();
                for (String alias : aliases) {
                    to.addAlias(alias);
                }
                break;
            }
        }
    }

    public static void copyAliases(Schema.Field from, Schema.Field to) {
        Set aliases = from.aliases();
        for (String alias : aliases) {
            to.addAlias(alias);
        }
    }

    public static void copyLogicalTypes(Schema from, Schema to) {
        LogicalType logicalType = from.getLogicalType();
        if (logicalType != null) {
            logicalType.addToSchema(to);
        }
    }

    public static void copyProperties(JsonProperties from, JsonProperties to) {
        Map objectProps = from.getObjectProps();
        for (Map.Entry entry : objectProps.entrySet()) {
            to.addProp((String)entry.getKey(), entry.getValue());
        }
    }

    public static boolean isNamedType(Schema schema) {
        Schema.Type type = schema.getType();
        switch (type) {
            case RECORD: 
            case ENUM: 
            case FIXED: {
                return true;
            }
        }
        return false;
    }

    public static String getJavaClassName(Schema schema) {
        String namespace = schema.getNamespace();
        if (namespace == null || namespace.isEmpty()) {
            return SpecificCompiler.mangle((String)schema.getName());
        }
        return namespace + '.' + SpecificCompiler.mangle((String)schema.getName());
    }

    @Beta
    public static void writeIdlProtocol(String protocolName, String protocolNameSpace, Appendable appendable, Schema ... schemas) throws IOException {
        if (protocolNameSpace != null) {
            appendable.append("@namespace(\"").append(protocolNameSpace).append("\")\n");
        }
        appendable.append("protocol ").append(protocolName).append(" {\n\n");
        if (SchemaUtils.isIdlCycleSupport()) {
            SchemaUtils.writeIdl(appendable, new HashSet<String>(4), protocolNameSpace, schemas);
        } else {
            SchemaUtils.writeIdlLegacy(appendable, new HashSet<String>(4), protocolNameSpace, schemas);
        }
        appendable.append("}\n");
    }

    @Beta
    public static void writeIdl(Appendable appendable, Set<String> alreadyDeclared, String protocolNameSpace, Schema ... pschemas) throws IOException {
        try (JsonGenerator jsonGen = SchemaUtils.createJsonGenerator(appendable);){
            HashSet<Schema> toDeclare = new HashSet<Schema>(4);
            toDeclare.addAll(Arrays.asList(pschemas));
            while (!toDeclare.isEmpty()) {
                Iterator iterator = toDeclare.iterator();
                Schema schema = (Schema)iterator.next();
                iterator.remove();
                SchemaUtils.writeSchema(schema, appendable, jsonGen, protocolNameSpace, alreadyDeclared, toDeclare);
                appendable.append('\n');
            }
        }
    }

    public static JsonGenerator createJsonGenerator(Appendable appendable) throws IOException {
        JsonGenerator jsonGen = appendable instanceof Writer ? Json.FACTORY.createGenerator((Writer)appendable) : Json.FACTORY.createGenerator((Writer)new AppendableWriter(appendable));
        return jsonGen;
    }

    @Beta
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public static void writeIdlLegacy(Appendable appendable, Set<String> alreadyDeclared, String protocolNameSpace, Schema ... pschemas) throws IOException {
        MutableGraph schemaDeps = GraphBuilder.directed().allowsSelfLoops(false).expectedNodeCount(4).build();
        HashMap<Schema, String> idlRepresentation = new HashMap<Schema, String>(4);
        HashSet<Schema> toDeclare = new HashSet<Schema>(4);
        toDeclare.addAll(Arrays.asList(pschemas));
        while (!toDeclare.isEmpty()) {
            Iterator iterator = toDeclare.iterator();
            Schema schema = (Schema)iterator.next();
            iterator.remove();
            StringWriter schemaIdrStr = new StringWriter();
            JsonGenerator jsonGen = Schema.FACTORY.createGenerator((Writer)schemaIdrStr);
            HashSet orig = new HashSet(toDeclare);
            SchemaUtils.writeSchema(schema, schemaIdrStr, jsonGen, protocolNameSpace, alreadyDeclared, toDeclare);
            idlRepresentation.put(schema, schemaIdrStr.toString());
            schemaDeps.addNode((Object)schema);
            Sets.SetView dependencies = Sets.difference(toDeclare, orig);
            for (Schema dep : dependencies) {
                schemaDeps.putEdge((Object)schema, (Object)dep);
            }
        }
        MutableGraph traverseGraph = Graphs.clone((MutableGraph)schemaDeps);
        Set nodes = traverseGraph.nodes();
        ArrayList<Schema> nodesToRemove = new ArrayList<Schema>();
        do {
            for (Schema token : nodes) {
                if (traverseGraph.outDegree((Object)token) != 0) continue;
                nodesToRemove.add(token);
                appendable.append((CharSequence)idlRepresentation.get(token));
                appendable.append('\n');
            }
            if (nodesToRemove.isEmpty() && !nodes.isEmpty()) {
                throw new IllegalArgumentException("Schema definition cycle for" + nodes);
            }
            for (Schema token : nodesToRemove) {
                traverseGraph.removeNode((Object)token);
            }
            nodesToRemove.clear();
        } while (!(nodes = traverseGraph.nodes()).isEmpty());
    }

    private static void writeSchema(Schema schema, Appendable appendable, JsonGenerator jsonGen, String protocolNameSpace, Set<String> alreadyDeclared, Set<Schema> toDeclare) throws IOException {
        Set saliases;
        Schema.Type type = schema.getType();
        SchemaUtils.writeSchemaAttributes(schema, appendable, jsonGen, true);
        String namespace = schema.getNamespace();
        if (!Objects.equals(namespace, protocolNameSpace)) {
            appendable.append("@namespace(\"").append(namespace).append("\")\n");
        }
        if (!(saliases = schema.getAliases()).isEmpty()) {
            appendable.append("@aliases(");
            SchemaUtils.toJson(saliases, jsonGen);
            jsonGen.flush();
            appendable.append(")\n");
        }
        switch (type) {
            case RECORD: {
                appendable.append("record ").append(schema.getName()).append(" {\n\n");
                alreadyDeclared.add(schema.getFullName());
                for (Schema.Field field : schema.getFields()) {
                    Schema.Field.Order order;
                    String fDoc = field.doc();
                    if (fDoc != null) {
                        appendable.append("  /** ").append(fDoc).append(" */\n");
                    }
                    appendable.append("  ");
                    SchemaUtils.writeFieldSchema(field.schema(), appendable, jsonGen, alreadyDeclared, toDeclare, schema.getNamespace());
                    appendable.append(' ');
                    Set faliases = field.aliases();
                    if (!faliases.isEmpty()) {
                        appendable.append("@aliases(");
                        SchemaUtils.toJson(faliases, jsonGen);
                        jsonGen.flush();
                        appendable.append(") ");
                    }
                    if ((order = field.order()) != null) {
                        appendable.append(" @order(\"").append(order.name()).append("\") ");
                    }
                    SchemaUtils.writeJsonProperties((JsonProperties)field, appendable, jsonGen, false);
                    appendable.append(' ');
                    appendable.append(field.name());
                    JsonNode defaultValue = field.defaultValue();
                    if (defaultValue != null) {
                        appendable.append(" = ");
                        SchemaUtils.toJson(field.defaultVal(), jsonGen);
                        jsonGen.flush();
                    }
                    appendable.append(";\n\n");
                }
                appendable.append("}\n");
                break;
            }
            case ARRAY: 
            case MAP: 
            case UNION: 
            case BOOLEAN: 
            case BYTES: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NULL: 
            case STRING: {
                throw new UnsupportedOperationException("No IDL entity, nust be part of a record: " + schema);
            }
            case ENUM: {
                appendable.append("enum ").append(schema.getName()).append(" {");
                alreadyDeclared.add(schema.getFullName());
                Iterator i = schema.getEnumSymbols().iterator();
                if (i.hasNext()) {
                    appendable.append((CharSequence)i.next());
                    while (i.hasNext()) {
                        appendable.append(',');
                        appendable.append((CharSequence)i.next());
                    }
                } else {
                    throw new IllegalStateException("Enum schema must have at least a symbol " + schema);
                }
                appendable.append("}\n");
                break;
            }
            case FIXED: {
                appendable.append("fixed ").append(schema.getName()).append('(').append(Integer.toString(schema.getFixedSize())).append(");\n");
                alreadyDeclared.add(schema.getFullName());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported schema " + schema);
            }
        }
    }

    private static void writeFieldSchema(Schema schema, Appendable appendable, JsonGenerator jsonGen, Set<String> alreadyDeclared, Set<Schema> toDeclare, String recordNameSpace) throws IOException {
        Schema.Type type = schema.getType();
        switch (type) {
            case RECORD: 
            case ENUM: 
            case FIXED: {
                if (Objects.equals(recordNameSpace, schema.getNamespace())) {
                    appendable.append(schema.getName());
                } else {
                    appendable.append(schema.getFullName());
                }
                if (alreadyDeclared.contains(schema.getFullName())) break;
                toDeclare.add(schema);
                break;
            }
            case ARRAY: {
                SchemaUtils.writeSchemaAttributes(schema, appendable, jsonGen, false);
                appendable.append("array<");
                SchemaUtils.writeFieldSchema(schema.getElementType(), appendable, jsonGen, alreadyDeclared, toDeclare, recordNameSpace);
                appendable.append('>');
                break;
            }
            case MAP: {
                SchemaUtils.writeSchemaAttributes(schema, appendable, jsonGen, false);
                appendable.append("map<");
                SchemaUtils.writeFieldSchema(schema.getValueType(), appendable, jsonGen, alreadyDeclared, toDeclare, recordNameSpace);
                appendable.append('>');
                break;
            }
            case UNION: {
                SchemaUtils.writeSchemaAttributes(schema, appendable, jsonGen, false);
                appendable.append("union {");
                List types = schema.getTypes();
                Iterator iterator = types.iterator();
                if (iterator.hasNext()) {
                    SchemaUtils.writeFieldSchema((Schema)iterator.next(), appendable, jsonGen, alreadyDeclared, toDeclare, recordNameSpace);
                    while (iterator.hasNext()) {
                        appendable.append(',');
                        SchemaUtils.writeFieldSchema((Schema)iterator.next(), appendable, jsonGen, alreadyDeclared, toDeclare, recordNameSpace);
                    }
                } else {
                    throw new IllegalStateException("Union schmemas must have member types " + schema);
                }
                appendable.append('}');
                break;
            }
            case BOOLEAN: 
            case BYTES: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NULL: 
            case STRING: {
                SchemaUtils.writeSchemaAttributes(schema, appendable, jsonGen, false);
                appendable.append(schema.getName());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported schema " + schema);
            }
        }
    }

    public static void writeSchemaAttributes(Schema schema, Appendable appendable, JsonGenerator jsonGen, boolean crBetween) throws IOException {
        String doc = schema.getDoc();
        if (doc != null) {
            appendable.append("/** ").append(doc).append(" */");
            if (crBetween) {
                appendable.append('\n');
            } else {
                appendable.append(' ');
            }
        }
        SchemaUtils.writeJsonProperties((JsonProperties)schema, appendable, jsonGen, crBetween);
    }

    public static void writeJsonProperties(JsonProperties props, Appendable appendable, JsonGenerator jsonGen, boolean crBetween) throws IOException {
        Map objectProps = props.getObjectProps();
        for (Map.Entry entry : objectProps.entrySet()) {
            appendable.append('@').append((CharSequence)entry.getKey()).append('(');
            SchemaUtils.toJson(entry.getValue(), jsonGen);
            jsonGen.flush();
            appendable.append(')');
            if (crBetween) {
                appendable.append('\n');
                continue;
            }
            appendable.append(' ');
        }
    }

    @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
    static void toJson(Object datum, JsonGenerator generator) throws IOException {
        if (datum == JsonProperties.NULL_VALUE) {
            generator.writeNull();
        } else if (datum instanceof Map) {
            generator.writeStartObject();
            for (Map.Entry entry : ((Map)datum).entrySet()) {
                generator.writeFieldName(entry.getKey().toString());
                SchemaUtils.toJson(entry.getValue(), generator);
            }
            generator.writeEndObject();
        } else if (datum instanceof Collection) {
            generator.writeStartArray();
            for (Object element : (Collection)datum) {
                SchemaUtils.toJson(element, generator);
            }
            generator.writeEndArray();
        } else if (datum instanceof byte[]) {
            generator.writeString(new String((byte[])datum, StandardCharsets.ISO_8859_1));
        } else if (datum instanceof CharSequence || datum instanceof Enum) {
            generator.writeString(datum.toString());
        } else if (datum instanceof Double) {
            generator.writeNumber(((Double)datum).doubleValue());
        } else if (datum instanceof Float) {
            generator.writeNumber(((Float)datum).floatValue());
        } else if (datum instanceof Long) {
            generator.writeNumber(((Long)datum).longValue());
        } else if (datum instanceof Integer) {
            generator.writeNumber(((Integer)datum).intValue());
        } else if (datum instanceof Boolean) {
            generator.writeBoolean(((Boolean)datum).booleanValue());
        } else {
            throw new AvroRuntimeException("Unknown datum class: " + datum.getClass());
        }
    }

    static {
        boolean hasIDLCycleSupp = true;
        try {
            Class.forName("org.apache.avro.compiler.idl.ResolvingVisitor");
        }
        catch (ClassNotFoundException ex) {
            hasIDLCycleSupp = false;
        }
        HAS_IDL_CYCLE_DEF_SUPPORT = hasIDLCycleSupp;
        SCHEMA_ESENTIALS = (a, b) -> {
            SchemaUtils.copyAliases(a, b);
            SchemaUtils.copyLogicalTypes(a, b);
        };
        FIELD_ESENTIALS = (a, b) -> SchemaUtils.copyAliases(a, b);
        SCHEMA_EVERYTHING = (a, b) -> {
            SchemaUtils.copyAliases(a, b);
            SchemaUtils.copyLogicalTypes(a, b);
            SchemaUtils.copyProperties((JsonProperties)a, (JsonProperties)b);
        };
        FIELD_EVERYTHING = (a, b) -> {
            SchemaUtils.copyAliases(a, b);
            SchemaUtils.copyProperties((JsonProperties)a, (JsonProperties)b);
        };
    }
}

