/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.schema;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.avro.ImmutableSchema;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.reflect.ExtendedReflectData;
import org.spf4j.avro.AvroCompatUtils;
import org.spf4j.avro.logical_types.InstantLogicalType;
import org.spf4j.avro.logical_types.Temporal;
import org.spf4j.avro.schema.ImmutableCloningVisitor;
import org.spf4j.avro.schema.SchemaDiff;
import org.spf4j.avro.schema.SchemaVisitor;
import org.spf4j.avro.schema.SchemaVisitorAction;
import org.spf4j.base.CharSequences;
import org.spf4j.ds.IdentityHashSet;
import org.spf4j.io.csv.CharSeparatedValues;
import org.spf4j.io.csv.CsvParseException;

@ParametersAreNonnullByDefault
@Beta
@SuppressFBWarnings(value={"AI_ANNOTATION_ISSUES_NEEDS_NULLABLE"})
public final class Schemas {
    private static final CharSeparatedValues SCHEMA_PATH_CSV = new CharSeparatedValues('.');

    private Schemas() {
    }

    public static void diff(Schema s1, Schema s2, Consumer<SchemaDiff> diffs) {
        Schemas.diff("", s1, s2, diffs, (Set<Schema>)new IdentityHashSet());
    }

    private static void diff(String path, Schema s1, Schema s2, Consumer<SchemaDiff> diffs, Set<Schema> visited) {
        if (visited.contains(s1)) {
            return;
        }
        Schema.Type type1 = s1.getType();
        if (s2.getType() != type1) {
            diffs.accept(SchemaDiff.of(path, s1, s2, SchemaDiff.Type.DIFFERENT_TYPES));
            return;
        }
        switch (type1) {
            case BOOLEAN: 
            case BYTES: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NULL: 
            case STRING: {
                break;
            }
            case FIXED: {
                if (s1.getFixedSize() != s2.getFixedSize()) {
                    diffs.accept(SchemaDiff.of(path, s1, s2, SchemaDiff.Type.DIFFERENT_FIXED_SIZE));
                }
                if (s1.getFullName().equals(s2.getFullName())) break;
                diffs.accept(SchemaDiff.of(path, s1, s2, SchemaDiff.Type.DIFFERENT_NAMES));
                break;
            }
            case ARRAY: {
                visited.add(s1);
                Schemas.diff(Schemas.pathAdd(path, "[]"), s1.getElementType(), s2.getElementType(), diffs, visited);
                break;
            }
            case MAP: {
                visited.add(s1);
                Schemas.diff(Schemas.pathAdd(path, "{}"), s1.getValueType(), s2.getValueType(), diffs, visited);
                break;
            }
            case ENUM: {
                List s2s;
                List s1s;
                if (!s1.getFullName().equals(s2.getFullName())) {
                    diffs.accept(SchemaDiff.of(path, s1, s2, SchemaDiff.Type.DIFFERENT_NAMES));
                }
                if ((s1s = s1.getEnumStringSymbols()).containsAll(s2s = s2.getEnumStringSymbols()) && s2s.containsAll(s1s)) break;
                diffs.accept(SchemaDiff.of(path, s1, s2, SchemaDiff.Type.DIFFERENT_ENUM_VALUES));
                break;
            }
            case UNION: {
                Schema os;
                visited.add(s1);
                for (Schema s : s1.getTypes()) {
                    os = Schemas.getFromUnion(s, s2);
                    if (os == null) {
                        diffs.accept(SchemaDiff.of(path, s, null, SchemaDiff.Type.SCHEMA_MISSING_RIGHT));
                        continue;
                    }
                    Schemas.diff(path, s, os, diffs, visited);
                }
                for (Schema s : s2.getTypes()) {
                    os = Schemas.getFromUnion(s, s2);
                    if (os != null) continue;
                    diffs.accept(SchemaDiff.of(path, null, s, SchemaDiff.Type.SCHEMA_MISSING_LEFT));
                }
                break;
            }
            case RECORD: {
                visited.add(s1);
                if (!s1.getFullName().equals(s2.getFullName())) {
                    diffs.accept(SchemaDiff.of(path, s1, s2, SchemaDiff.Type.DIFFERENT_NAMES));
                }
                for (Schema.Field field1 : s1.getFields()) {
                    Schema.Field field2 = s2.getField(field1.name());
                    if (field2 == null) {
                        diffs.accept(SchemaDiff.of(path, field1, null, SchemaDiff.Type.FIELD_MISSING_RIGHT));
                        continue;
                    }
                    Schemas.diff(Schemas.pathAdd(path, field1.name()), field1.schema(), field2.schema(), diffs, visited);
                    if (!Objects.equals(field1.defaultVal(), field2.defaultVal())) {
                        diffs.accept(SchemaDiff.of(path, field1, field2, SchemaDiff.Type.DIFFERENT_FIELD_DEFAULTS));
                    }
                    if (!field1.getObjectProps().equals(field2.getObjectProps())) {
                        diffs.accept(SchemaDiff.of(path, field1, field2, SchemaDiff.Type.DIFFERENT_FIELD_PROPERTIES));
                    }
                    if (Objects.equals(field1.doc(), field2.doc())) continue;
                    diffs.accept(SchemaDiff.of(path, field1, field2, SchemaDiff.Type.DIFFERRENT_FIELD_DOC));
                }
                for (Schema.Field field2 : s2.getFields()) {
                    Schema.Field field1 = s1.getField(field2.name());
                    if (field1 != null) continue;
                    diffs.accept(SchemaDiff.of(path, null, field2, SchemaDiff.Type.FIELD_MISSING_LEFT));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Invalid Schema " + s1);
            }
        }
        if (!Objects.equals(s1.getLogicalType(), s2.getLogicalType())) {
            diffs.accept(SchemaDiff.of(path, s1, s2, SchemaDiff.Type.DIFFERENT_LOGICAL_TYPES));
        }
        if (!s1.getObjectProps().equals(s2.getObjectProps())) {
            diffs.accept(SchemaDiff.of(path, s1, s2, SchemaDiff.Type.DIFFERENT_SCHEMA_PROPERTIES));
        }
        if (!Objects.equals(s1.getDoc(), s2.getDoc())) {
            diffs.accept(SchemaDiff.of(path, s1, s2, SchemaDiff.Type.DIFFERRENT_SCHEMA_DOC));
        }
    }

    private static String pathAdd(String p, String ref) {
        if (p.isEmpty()) {
            return SCHEMA_PATH_CSV.toCsvElement(ref);
        }
        return p + '.' + SCHEMA_PATH_CSV.toCsvElement(ref);
    }

    @Nullable
    public static Schema getFromUnion(Schema what, Schema unionSchema) {
        String fullName = what.getFullName();
        for (Schema s : unionSchema.getTypes()) {
            if (!fullName.equals(s.getFullName())) continue;
            return s;
        }
        return null;
    }

    public static void deprecations(Schema schema, BiConsumer<String, String> toPut) {
        Schemas.visit(schema, new DeprecationVisitor(toPut));
    }

    @Nonnull
    public static ImmutableSchema immutable(Schema schema) {
        if (schema instanceof ImmutableSchema) {
            return (ImmutableSchema)schema;
        }
        return Schemas.visit(schema, new ImmutableCloningVisitor(schema, false));
    }

    @Nonnull
    public static ImmutableSchema immutable(Schema schema, boolean withSerializationSignificatAttrsonly) {
        return Schemas.visit(schema, new ImmutableCloningVisitor(schema, withSerializationSignificatAttrsonly));
    }

    public static <T> T visit(Schema start, SchemaVisitor<T> visitor) {
        Object current;
        IdentityHashSet visited = new IdentityHashSet();
        ArrayDeque<Object> dq = new ArrayDeque<Object>();
        dq.addLast(start);
        block13: while ((current = dq.pollLast()) != null) {
            boolean terminate;
            if (current instanceof Supplier) {
                SchemaVisitorAction action = (SchemaVisitorAction)((Object)((Supplier)current).get());
                switch (action) {
                    case CONTINUE: {
                        continue block13;
                    }
                    case SKIP_SUBTREE: {
                        throw new UnsupportedOperationException();
                    }
                    case SKIP_SIBLINGS: {
                        while (dq.getLast() instanceof Schema) {
                            dq.removeLast();
                        }
                        continue block13;
                    }
                    case TERMINATE: {
                        return visitor.get();
                    }
                }
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action));
            }
            Schema schema = (Schema)current;
            if (!visited.contains((Object)schema)) {
                Schema.Type type = schema.getType();
                switch (type) {
                    case ARRAY: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, Collections.singletonList(schema.getElementType()));
                        visited.add((Object)schema);
                        break;
                    }
                    case RECORD: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, Lists.transform((List)Lists.reverse((List)schema.getFields()), Schema.Field::schema));
                        visited.add((Object)schema);
                        break;
                    }
                    case UNION: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, schema.getTypes());
                        visited.add((Object)schema);
                        break;
                    }
                    case MAP: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, Collections.singletonList(schema.getValueType()));
                        visited.add((Object)schema);
                        break;
                    }
                    case BOOLEAN: 
                    case BYTES: 
                    case DOUBLE: 
                    case FLOAT: 
                    case INT: 
                    case LONG: 
                    case NULL: 
                    case STRING: 
                    case FIXED: 
                    case ENUM: {
                        terminate = Schemas.visitTerminal(visitor, schema, dq);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Invalid type " + type);
                    }
                }
            } else {
                terminate = Schemas.visitTerminal(visitor, schema, dq);
            }
            if (!terminate) continue;
            return visitor.get();
        }
        return visitor.get();
    }

    private static boolean visitNonTerminal(SchemaVisitor visitor, Schema schema, Deque<Object> dq, Iterable<Schema> itSupp) {
        SchemaVisitorAction action = visitor.visitNonTerminal(schema);
        switch (action) {
            case CONTINUE: {
                dq.addLast(() -> visitor.afterVisitNonTerminal(schema));
                for (Schema child : itSupp) {
                    dq.addLast(child);
                }
                break;
            }
            case SKIP_SUBTREE: {
                dq.addLast(() -> visitor.afterVisitNonTerminal(schema));
                break;
            }
            case SKIP_SIBLINGS: {
                while (!dq.isEmpty() && dq.getLast() instanceof Schema) {
                    dq.removeLast();
                }
                break;
            }
            case TERMINATE: {
                return true;
            }
            default: {
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action) + " for " + schema);
            }
        }
        return false;
    }

    private static boolean visitTerminal(SchemaVisitor visitor, Schema schema, Deque<Object> dq) {
        SchemaVisitorAction action = visitor.visitTerminal(schema);
        switch (action) {
            case CONTINUE: {
                break;
            }
            case SKIP_SUBTREE: {
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action) + " for " + schema);
            }
            case SKIP_SIBLINGS: {
                Object current;
                while ((current = dq.getLast()) instanceof Schema) {
                }
                dq.addLast(current);
                break;
            }
            case TERMINATE: {
                return true;
            }
            default: {
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action) + " for " + schema);
            }
        }
        return false;
    }

    public static boolean isNullableUnion(Schema schema) {
        if (schema.getType() != Schema.Type.UNION) {
            return false;
        }
        for (Schema ss : schema.getTypes()) {
            if (ss.getType() != Schema.Type.NULL) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Schema nullableUnionSchema(Schema schema) {
        if (schema.getType() != Schema.Type.UNION) {
            return null;
        }
        List types = schema.getTypes();
        if (types.size() != 2) {
            return null;
        }
        if (((Schema)types.get(0)).getType() == Schema.Type.NULL) {
            return (Schema)types.get(1);
        }
        if (((Schema)types.get(1)).getType() == Schema.Type.NULL) {
            return (Schema)types.get(0);
        }
        return null;
    }

    @Nullable
    public static Schema getSchemaFromUnionByName(Schema unionSchema, String name) {
        if (unionSchema.getType() != Schema.Type.UNION) {
            return name.equals(unionSchema.getFullName()) ? unionSchema : null;
        }
        List types = unionSchema.getTypes();
        for (Schema schema : types) {
            if (!name.equals(schema.getFullName())) continue;
            return schema;
        }
        return null;
    }

    @Nullable
    public static Schema getSubSchema(Schema schema, CharSequence path) {
        List parsedPath;
        if (path.length() == 0) {
            return schema;
        }
        try {
            parsedPath = SCHEMA_PATH_CSV.readRow(CharSequences.reader((CharSequence)path));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (CsvParseException ex) {
            throw new IllegalArgumentException("Invalid path " + path, ex);
        }
        Schema result = schema;
        for (String part : parsedPath) {
            if ((result = Schemas.getSegment(result, part)) != null) continue;
            return null;
        }
        return result;
    }

    @Nullable
    private static Schema getSegment(Schema result, String part) {
        switch (result.getType()) {
            case ARRAY: {
                if (!"[]".equals(part)) break;
                return result.getElementType();
            }
            case MAP: {
                if (!"{}".equals(part)) break;
                return result.getValueType();
            }
            case UNION: {
                for (Schema us : result.getTypes()) {
                    Schema ur = Schemas.getSegment(us, part);
                    if (ur == null) continue;
                    return ur;
                }
                break;
            }
            case RECORD: {
                Schema.Field field = result.getField(part);
                if (field == null) {
                    for (Schema.Field f : result.getFields()) {
                        if (!f.aliases().contains(part)) continue;
                        field = f;
                    }
                }
                if (field == null) break;
                return field.schema();
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public static Schema projectRecord(Schema schema, int[] projection) {
        List fields = schema.getFields();
        ArrayList<Schema.Field> nFields = new ArrayList<Schema.Field>(projection.length);
        for (int i = 0; i < projection.length; ++i) {
            Schema.Field of = (Schema.Field)fields.get(projection[i]);
            Schema.Field nfield = new Schema.Field(of, of.schema());
            nFields.add(nfield);
        }
        if (Schemas.isSameFields(fields, nFields)) {
            return schema;
        }
        Schema rec = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)("_p." + schema.getNamespace()), (boolean)schema.isError());
        rec.setFields(nFields);
        String dep = schema.getProp("deprecated");
        if (dep != null) {
            rec.addProp("deprecated", dep);
        }
        return rec;
    }

    @Nullable
    public static Schema project(Schema schema, CharSequence ... paths) {
        return Schemas.project(schema, Arrays.asList(paths));
    }

    @Nullable
    public static Schema project(Schema schema, List<? extends CharSequence> paths) {
        ArrayList<List<String>> p = new ArrayList<List<String>>(paths.size());
        for (CharSequence charSequence : paths) {
            try {
                p.add(SCHEMA_PATH_CSV.readRow(CharSequences.reader((CharSequence)charSequence)));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            catch (CsvParseException ex) {
                throw new IllegalArgumentException("Invalid projection path " + charSequence, ex);
            }
        }
        return Schemas.projectInternal(schema, p);
    }

    @Nullable
    private static Schema projectInternal(Schema schema, List<List<String>> paths) {
        List<String> first;
        int length = paths.size();
        if (length == 0) {
            return schema;
        }
        if (length == 1 && ((first = paths.get(0)).isEmpty() || first.size() == 1 && first.get(0).isEmpty())) {
            return schema;
        }
        switch (schema.getType()) {
            case ARRAY: {
                ArrayList<List<String>> seqs = new ArrayList<List<String>>(length);
                for (List<String> path : paths) {
                    String part = path.get(0);
                    if ("[]".equals(part)) {
                        int pSize = path.size();
                        if (pSize == 1) {
                            return schema;
                        }
                        seqs.add(path.subList(1, pSize));
                        continue;
                    }
                    return null;
                }
                if (seqs.isEmpty()) {
                    return null;
                }
                return Schema.createArray((Schema)Schemas.projectInternal(schema.getElementType(), seqs));
            }
            case MAP: {
                ArrayList<List<String>> seqs = new ArrayList(length);
                for (List<String> path : paths) {
                    String part = path.get(0);
                    if (!"{}".equals(part)) continue;
                    int pSize = path.size();
                    if (1 == pSize) {
                        return schema;
                    }
                    seqs.add(path.subList(1, pSize));
                }
                if (seqs.isEmpty()) {
                    return null;
                }
                return Schema.createMap((Schema)Schemas.projectInternal(schema.getElementType(), seqs));
            }
            case RECORD: {
                List fields = schema.getFields();
                ArrayList<Schema.Field> nFields = new ArrayList<Schema.Field>(fields.size());
                LinkedList<List<String>> tPaths = new LinkedList<List<String>>(paths);
                do {
                    Schema.Field extract;
                    if ((extract = Schemas.extract(fields, tPaths)) == null) {
                        return null;
                    }
                    nFields.add(extract);
                } while (!tPaths.isEmpty());
                if (Schemas.isSameFields(fields, nFields)) {
                    return schema;
                }
                Schema rec = AvroCompatUtils.createRecordSchema((String)schema.getName(), (String)schema.getDoc(), (String)("_p." + schema.getNamespace()), (boolean)schema.isError(), (boolean)false);
                rec.setFields(nFields);
                String dep = schema.getProp("deprecated");
                if (dep != null) {
                    rec.addProp("deprecated", dep);
                }
                return rec;
            }
            case UNION: {
                List types = schema.getTypes();
                ArrayList<Schema> nTypes = new ArrayList<Schema>(types.size());
                for (Schema us : types) {
                    if (us.getType() == Schema.Type.NULL) {
                        nTypes.add(us);
                        continue;
                    }
                    Schema project = Schemas.projectInternal(us, paths);
                    if (project == null) continue;
                    nTypes.add(project);
                }
                return Schema.createUnion(nTypes);
            }
        }
        if (paths.contains(Collections.emptyList())) {
            return schema;
        }
        return null;
    }

    public static boolean isSameFields(List<Schema.Field> f1s, List<Schema.Field> f2s) {
        int l2;
        int l1 = f1s.size();
        if (l1 != (l2 = f2s.size())) {
            return false;
        }
        for (int i = 0; i < l1; ++i) {
            Schema.Field f1 = f1s.get(i);
            Schema.Field f2 = f2s.get(i);
            if (f1.name().equals(f2.name()) && f1.schema().equals((Object)f2.schema())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static IndexedRecord project(Schema toSchema, Schema fromSchema, @Nullable IndexedRecord object) {
        return (IndexedRecord)Schemas.project(toSchema, fromSchema, (Object)object);
    }

    @Nullable
    @SuppressFBWarnings(value={"URV_UNRELATED_RETURN_VALUES"})
    public static Object project(Schema toSchema, Schema fromSchema, @Nullable Object object) {
        if (toSchema == fromSchema) {
            return object;
        }
        Schema.Type type = toSchema.getType();
        if (fromSchema.getType() != type) {
            throw new IllegalArgumentException("Unable to project " + object + " from " + fromSchema + " to " + toSchema);
        }
        switch (type) {
            case BOOLEAN: 
            case BYTES: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case STRING: 
            case FIXED: 
            case ENUM: {
                return object;
            }
            case NULL: {
                return null;
            }
            case ARRAY: {
                List from = (List)object;
                ArrayList<Object> to = new ArrayList<Object>(from.size());
                Schema toElementType = toSchema.getElementType();
                Schema fromElementType = fromSchema.getElementType();
                for (Object o : from) {
                    to.add(Schemas.project(toElementType, fromElementType, o));
                }
                return to;
            }
            case MAP: {
                Map fromMap = (Map)object;
                LinkedHashMap toMap = Maps.newLinkedHashMapWithExpectedSize((int)fromMap.size());
                Schema toValueType = toSchema.getValueType();
                Schema fromValueType = fromSchema.getValueType();
                for (Map.Entry entry : fromMap.entrySet()) {
                    toMap.put(entry.getKey(), Schemas.project(toValueType, fromValueType, entry.getValue()));
                }
                return toMap;
            }
            case UNION: {
                ExtendedReflectData rftor = ExtendedReflectData.get();
                int unionIdx = rftor.resolveUnion(fromSchema, object);
                Schema objSchema = (Schema)fromSchema.getTypes().get(unionIdx);
                String name = rftor.getSchemaName(objSchema);
                Set aliases = objSchema.getAliases();
                if (aliases.isEmpty()) {
                    for (Schema toMatch : toSchema.getTypes()) {
                        if (!name.equals(rftor.getSchemaName(toMatch)) && !toMatch.getAliases().contains(name)) continue;
                        return Schemas.project(toMatch, objSchema, object);
                    }
                } else {
                    for (Schema toMatch : toSchema.getTypes()) {
                        String toMatchName = rftor.getSchemaName(toMatch);
                        if (!name.equals(toMatchName) && !aliases.contains(toMatchName) && Sets.intersection((Set)aliases, (Set)toMatch.getAliases()).isEmpty()) continue;
                        return Schemas.project(toMatch, objSchema, object);
                    }
                }
                throw new IllegalArgumentException("Unable to project " + object + " to " + toSchema);
            }
            case RECORD: {
                GenericData.Record record = new GenericData.Record(toSchema);
                GenericRecord fromRec = (GenericRecord)object;
                Schema frSchema = fromRec.getSchema();
                for (Schema.Field field : toSchema.getFields()) {
                    Schema.Field frField = Schemas.getPos(field, frSchema);
                    int toPos = field.pos();
                    if (frField == null) {
                        record.put(toPos, field.defaultVal());
                        continue;
                    }
                    record.put(toPos, Schemas.project(field.schema(), frField.schema(), fromRec.get(frField.pos())));
                }
                return record;
            }
        }
        throw new IllegalStateException("Unsupported type " + type);
    }

    @Nullable
    public static Schema.Field getPos(Schema.Field field, Schema recordSchema) {
        Schema.Field rf = recordSchema.getField(field.name());
        if (rf == null) {
            for (String alias : field.aliases()) {
                rf = recordSchema.getField(alias);
                if (rf == null) continue;
                return rf;
            }
            return null;
        }
        return rf;
    }

    @Nullable
    private static Schema.Field extract(Iterable<Schema.Field> fields, Iterable<List<String>> paths) {
        Iterator<List<String>> iterator = paths.iterator();
        if (iterator.hasNext()) {
            ArrayList<List<String>> proj = new ArrayList<List<String>>(2);
            List<String> path = iterator.next();
            String part = path.get(0);
            Schema.Field field = Schemas.getField(part, fields);
            if (field == null) {
                return null;
            }
            iterator.remove();
            if (1 == path.size()) {
                proj.add(Collections.EMPTY_LIST);
            } else {
                proj.add(path.subList(1, path.size()));
            }
            while (iterator.hasNext()) {
                path = iterator.next();
                part = path.get(0);
                if (!Schemas.isNamed(part, field)) continue;
                if (1 == path.size()) {
                    proj.add(Collections.EMPTY_LIST);
                } else {
                    proj.add(path.subList(1, path.size()));
                }
                iterator.remove();
            }
            return new Schema.Field(field, Schemas.projectInternal(field.schema(), proj));
        }
        return null;
    }

    @Nullable
    public static Schema.Field getField(String nameOrAlias, Iterable<Schema.Field> fields) {
        for (Schema.Field field : fields) {
            if (!Schemas.isNamed(nameOrAlias, field)) continue;
            return field;
        }
        return null;
    }

    public static boolean isNamed(String nameOrAlias, Schema.Field field) {
        return nameOrAlias.equals(field.name()) || field.aliases().contains(nameOrAlias);
    }

    public static Schema dateString() {
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        LogicalTypes.date().addToSchema(schema);
        return schema;
    }

    public static Schema instantString() {
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        InstantLogicalType.instance().addToSchema(schema);
        return schema;
    }

    public static Schema temporalString() {
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        Temporal.instance().addToSchema(schema);
        return schema;
    }

    private static class DeprecationVisitor
    implements SchemaVisitor<Void> {
        private final BiConsumer<String, String> toPut;

        DeprecationVisitor(BiConsumer<String, String> toPut) {
            this.toPut = toPut;
        }

        @Override
        public SchemaVisitorAction visitTerminal(Schema terminal) {
            if (terminal.getType() == Schema.Type.FIXED) {
                this.checkDeprecation(terminal);
            }
            return SchemaVisitorAction.CONTINUE;
        }

        public void checkDeprecation(Schema terminal) {
            String dMsg = terminal.getProp("deprecated");
            if (dMsg != null) {
                this.toPut.accept(terminal.getFullName(), dMsg);
            }
        }

        @Override
        public SchemaVisitorAction visitNonTerminal(Schema nonTerminal) {
            this.checkDeprecation(nonTerminal);
            if (nonTerminal.getType() == Schema.Type.RECORD) {
                for (Schema.Field field : nonTerminal.getFields()) {
                    String msg = field.getProp("deprecated");
                    if (msg == null) continue;
                    this.toPut.accept(nonTerminal.getFullName() + '.' + field.name(), msg);
                }
            }
            return SchemaVisitorAction.CONTINUE;
        }

        @Override
        public SchemaVisitorAction afterVisitNonTerminal(Schema nonTerminal) {
            return SchemaVisitorAction.CONTINUE;
        }
    }
}

