/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.tsdb;

import gnu.trove.list.array.TIntArrayList;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.spf4j.io.ByteArrayBuilder;

@Deprecated
final class DataFragment {
    private long location;
    private long nextDataFragment;
    private final long startTimeMillis;
    private List<long[]> data;
    private TIntArrayList timestamps;

    DataFragment(long startTimeMillis) {
        this.location = 0L;
        this.nextDataFragment = 0L;
        this.startTimeMillis = startTimeMillis;
        this.data = new ArrayList<long[]>();
        this.timestamps = new TIntArrayList();
    }

    DataFragment(RandomAccessFile raf) throws IOException {
        this.location = raf.getFilePointer();
        this.nextDataFragment = raf.readLong();
        this.startTimeMillis = raf.readLong();
        int nrSamples = raf.readInt();
        int samplesLength = raf.readInt();
        int bufferSize = nrSamples * (samplesLength * 8 + 4);
        byte[] buffer = new byte[bufferSize];
        raf.readFully(buffer);
        this.loadData(nrSamples, samplesLength, new DataInputStream(new ByteArrayInputStream(buffer)));
    }

    public void writeTo(DataOutput dos) throws IOException {
        dos.writeLong(this.nextDataFragment);
        dos.writeLong(this.startTimeMillis);
        dos.writeInt(this.data.size());
        dos.writeInt(this.data.get(0).length);
        for (int i = 0; i < this.timestamps.size(); ++i) {
            dos.writeInt(this.timestamps.get(i));
            for (long value : this.data.get(i)) {
                dos.writeLong(value);
            }
        }
    }

    public void writeTo(RandomAccessFile raf) throws IOException {
        try (ByteArrayBuilder bos = new ByteArrayBuilder();){
            DataOutputStream dos = new DataOutputStream((OutputStream)bos);
            this.writeTo(dos);
            raf.seek(this.location);
            raf.write(bos.getBuffer(), 0, bos.size());
        }
    }

    public void addData(long timestamp, long[] dataRow) {
        this.data.add(dataRow);
        this.timestamps.add((int)(timestamp - this.startTimeMillis));
    }

    public void setNextDataFragment(long pnextDataFragment, RandomAccessFile raf) throws IOException {
        this.nextDataFragment = pnextDataFragment;
        DataFragment.setNextDataFragment(this.location, this.nextDataFragment, raf);
    }

    public static void setNextDataFragment(long dataFragmentPosition, long nextDataFragment, RandomAccessFile raf) throws IOException {
        raf.seek(dataFragmentPosition);
        raf.writeLong(nextDataFragment);
    }

    public long getNextDataFragment() {
        return this.nextDataFragment;
    }

    public long getLocation() {
        return this.location;
    }

    private void loadData(int nrSamples, int samplesLength, DataInput raf) throws IOException {
        this.data = new ArrayList<long[]>(nrSamples);
        this.timestamps = new TIntArrayList(nrSamples);
        for (int i = 0; i < nrSamples; ++i) {
            this.timestamps.add(raf.readInt());
            long[] row = new long[samplesLength];
            for (int j = 0; j < samplesLength; ++j) {
                row[j] = raf.readLong();
            }
            this.data.add(row);
        }
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public int getNrRows() {
        return this.data.size();
    }

    public List<long[]> getData() {
        return this.data;
    }

    public TIntArrayList getTimestamps() {
        return this.timestamps;
    }

    public void setLocation(long location) {
        this.location = location;
    }

    public String toString() {
        return "DataFragment{location=" + this.location + ", nextDataFragment=" + this.nextDataFragment + ", startTimeMillis=" + this.startTimeMillis + ", data=" + this.data + ", timestamps=" + this.timestamps + '}';
    }
}

