/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.MapBuilder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import spire.algebra.Eq;
import spire.algebra.Field;
import spire.algebra.Order;
import spire.algebra.Order$;
import spire.algebra.Rig;
import spire.algebra.Ring;
import spire.algebra.Rng;
import spire.algebra.Semiring;
import spire.algebra.Sign;
import spire.algebra.Sign$Zero$;
import spire.algebra.Signed;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.QuickSort$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.poly.PolyDense;
import spire.math.poly.PolySparse;
import spire.math.poly.RootFinder;
import spire.math.poly.Roots;
import spire.math.poly.Term;
import spire.math.poly.Term$;

public abstract class Polynomial$class {
    public static void foreachNonZero(Polynomial $this, Function2 f, Semiring ring, Eq eq2) {
        $this.foreach(new Serializable($this, f, ring, eq2){
            public static final long serialVersionUID = 0L;
            private final Function2 f$1;
            private final Semiring ring$1;
            private final Eq eq$1;

            public final Object apply(int e, C c) {
                return this.eq$1.neqv(c, this.ring$1.zero()) ? this.f$1.apply((Object)BoxesRunTime.boxToInteger((int)e), c) : BoxedUnit.UNIT;
            }
            {
                void var4_4;
                void var3_3;
                this.f$1 = f$1;
                this.ring$1 = var3_3;
                this.eq$1 = var4_4;
            }
        });
    }

    public static List terms(Polynomial $this, Semiring ring, Eq eq2) {
        ListBuffer lb = new ListBuffer();
        $this.foreachNonZero(new Serializable($this, lb){
            public static final long serialVersionUID = 0L;
            private final ListBuffer lb$1;

            public final ListBuffer<Term<C>> apply(int e, C c) {
                return this.lb$1.$plus$eq(new Term<C>(c, e));
            }
            {
                this.lb$1 = lb$1;
            }
        }, ring, eq2);
        return lb.result();
    }

    public static Map data(Polynomial $this, Semiring ring, Eq eq2) {
        MapBuilder bldr = new MapBuilder((GenMap)Predef$.MODULE$.Map().empty());
        $this.foreachNonZero(new Serializable($this, bldr){
            public static final long serialVersionUID = 0L;
            private final MapBuilder bldr$1;

            public final MapBuilder<Object, C, Map<Object, C>> apply(int e, C c) {
                return this.bldr$1.$plus$eq(new Tuple2((Object)BoxesRunTime.boxToInteger((int)e), c));
            }
            {
                this.bldr$1 = bldr$1;
            }
        }, ring, eq2);
        return (Map)bldr.result();
    }

    public static Roots roots(Polynomial $this, RootFinder finder) {
        return finder.findRoots($this);
    }

    public static Term maxTerm(Polynomial $this, Semiring ring) {
        return new Term($this.maxOrderTermCoeff(ring), $this.degree());
    }

    public static Term minTerm(Polynomial $this, Semiring ring, Eq eq2) {
        NonLocalReturnControl nonLocalReturnControl;
        block2: {
            Term term;
            Object object = new Object();
            try {
                $this.foreachNonZero(new Serializable($this, object){
                    public static final long serialVersionUID = 0L;
                    private final Object nonLocalReturnKey1$1;

                    public final Nothing$ apply(int n, C c) {
                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, new Term<C>(c, n));
                    }
                    {
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                }, ring, eq2);
                term = new Term(ring.zero(), 0);
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                nonLocalReturnControl = nonLocalReturnControl2;
                if (nonLocalReturnControl2.key() != object) break block2;
                term = (Term)nonLocalReturnControl.value();
            }
            return term;
        }
        throw nonLocalReturnControl;
    }

    public static boolean isConstant(Polynomial $this) {
        return $this.degree() == 0;
    }

    public static Object evalWith(Polynomial $this, Object x, Function1 f, Semiring evidence$56, Eq evidence$57, ClassTag evidence$58, Semiring ring, Eq eq2) {
        return $this.map(f, evidence$56, evidence$57, evidence$58, ring, eq2).apply(x, evidence$56);
    }

    public static Polynomial compose(Polynomial $this, Polynomial y, Rig ring, Eq eq2) {
        ObjectRef polynomial = new ObjectRef(Polynomial$.MODULE$.zero(eq2, ring, $this.ct()));
        $this.foreachNonZero(new Serializable($this, polynomial, y, ring, eq2){
            public static final long serialVersionUID = 0L;
            private final ObjectRef polynomial$1;
            private final Polynomial y$1;
            private final Rig ring$2;
            private final Eq eq$2;

            public final void apply(int e, C c) {
                Polynomial<C> z = this.y$1.pow(e, this.ring$2, this.eq$2).$colon$times(c, this.ring$2, this.eq$2);
                this.polynomial$1.elem = ((Polynomial)this.polynomial$1.elem).$plus(z, this.ring$2, this.eq$2);
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                this.polynomial$1 = polynomial$1;
                this.y$1 = var3_3;
                this.ring$2 = var4_4;
                this.eq$2 = var5_5;
            }
        }, ring, eq2);
        return (Polynomial)polynomial.elem;
    }

    public static Polynomial shift(Polynomial $this, Object h, Ring ring, Eq eq2) {
        Object coeffs = ScalaRunTime$.MODULE$.array_clone($this.coeffsArray(ring));
        $this.foreachNonZero(new Serializable($this, coeffs, h, ring){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Polynomial $outer;
            private final Object coeffs$1;
            private final Object h$1;
            private final Ring ring$3;

            public final void apply(int deg, C c) {
                int i = 1;
                int d = deg - 1;
                SafeLong m = SafeLong$.MODULE$.apply(1L);
                Object k = c;
                while (d >= 0) {
                    m = m.$times(d + 1).$div$tilde(SafeLong$.MODULE$.apply(i));
                    k = this.ring$3.times(k, this.h$1);
                    ScalaRunTime$.MODULE$.array_update(this.coeffs$1, d, this.ring$3.plus(ScalaRunTime$.MODULE$.array_apply(this.coeffs$1, d), this.ring$3.times(Polynomial$class.fromSafeLong$1(this.$outer, m, this.ring$3), k)));
                    --d;
                    ++i;
                }
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.coeffs$1 = coeffs$1;
                this.h$1 = var3_3;
                this.ring$3 = var4_4;
            }
        }, ring, eq2);
        return Polynomial$.MODULE$.dense(coeffs, ring, eq2, $this.ct());
    }

    public static Polynomial monic(Polynomial $this, Field f, Eq eq2) {
        return $this.$colon$div($this.maxOrderTermCoeff(f), f, eq2);
    }

    public static int signVariations(Polynomial $this, Semiring ring, Eq eq2, Signed signed) {
        ObjectRef prevSign = new ObjectRef((Object)Sign$Zero$.MODULE$);
        IntRef variations = new IntRef(0);
        $this.foreachNonZero(new Serializable($this, prevSign, variations, signed){
            public static final long serialVersionUID = 0L;
            private final ObjectRef prevSign$1;
            private final IntRef variations$1;
            private final Signed signed$1;

            public final void apply(int x$8, C c) {
                Sign sign = this.signed$1.sign(c);
                Sign$Zero$ sign$Zero$ = Sign$Zero$.MODULE$;
                Sign sign2 = (Sign)this.prevSign$1.elem;
                if (sign$Zero$ == null ? sign2 != null : !sign$Zero$.equals(sign2)) {
                    Sign sign3 = sign;
                    Sign sign4 = (Sign)this.prevSign$1.elem;
                    if (sign3 == null ? sign4 != null : !sign3.equals(sign4)) {
                        ++this.variations$1.elem;
                    }
                }
                this.prevSign$1.elem = sign;
            }
            {
                void var4_4;
                void var3_3;
                this.prevSign$1 = prevSign$1;
                this.variations$1 = var3_3;
                this.signed$1 = var4_4;
            }
        }, ring, eq2);
        return variations.elem;
    }

    public static Polynomial removeZeroRoots(Polynomial $this, Semiring ring, Eq eq2) {
        Term term = $this.minTerm(ring, eq2);
        if (term != null) {
            int n = term.exp();
            return $this.mapTerms(new Serializable($this, n){
                public static final long serialVersionUID = 0L;
                private final int k$1;

                public final Term<C> apply(Term<C> x0$1) {
                    if (x0$1 != null) {
                        return new Term<C>(x0$1.coeff(), x0$1.exp() - this.k$1);
                    }
                    throw new MatchError(x0$1);
                }
                {
                    this.k$1 = k$1;
                }
            }, ring, eq2, $this.ct(), ring, eq2);
        }
        throw new MatchError(term);
    }

    public static Polynomial map(Polynomial $this, Function1 f, Semiring evidence$59, Eq evidence$60, ClassTag evidence$61, Semiring ring, Eq eq2) {
        return $this.mapTerms(new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$2;

            public final Term<Object> apply(Term<C> x0$2) {
                if (x0$2 != null) {
                    return new Term<Object>(this.f$2.apply(x0$2.coeff()), x0$2.exp());
                }
                throw new MatchError(x0$2);
            }
            {
                this.f$2 = f$2;
            }
        }, evidence$59, evidence$60, evidence$61, ring, eq2);
    }

    public static Polynomial mapTerms(Polynomial $this, Function1 f, Semiring evidence$62, Eq evidence$63, ClassTag evidence$64, Semiring ring, Eq eq2) {
        return Polynomial$.MODULE$.apply($this.termsIterator().map(f), evidence$62, evidence$63, evidence$64);
    }

    public static Polynomial flip(Polynomial $this, Rng ring, Eq eq2) {
        return $this.mapTerms(new Serializable($this, ring){
            public static final long serialVersionUID = 0L;
            private final Rng ring$4;

            public final Term<C> apply(Term<C> x0$3) {
                if (x0$3 != null) {
                    return x0$3.exp() % 2 == 0 ? x0$3 : new Term<C>(this.ring$4.negate(x0$3.coeff()), x0$3.exp());
                }
                throw new MatchError(x0$3);
            }
            {
                this.ring$4 = ring$4;
            }
        }, ring, eq2, $this.ct(), ring, eq2);
    }

    public static Polynomial reciprocal(Polynomial $this, Semiring ring, Eq eq2) {
        int d = $this.degree();
        return $this.mapTerms(new Serializable($this, d){
            public static final long serialVersionUID = 0L;
            private final int d$2;

            public final Term<C> apply(Term<C> x0$4) {
                if (x0$4 != null) {
                    return new Term<C>(x0$4.coeff(), this.d$2 - x0$4.exp());
                }
                throw new MatchError(x0$4);
            }
            {
                this.d$2 = d$2;
            }
        }, ring, eq2, $this.ct(), ring, eq2);
    }

    public static Polynomial $minus(Polynomial $this, Polynomial rhs, Rng ring, Eq eq2) {
        return $this.$plus(rhs.unary_$minus(ring), ring, eq2);
    }

    public static Polynomial $div$tilde(Polynomial $this, Polynomial rhs, Field field, Eq eq2) {
        return (Polynomial)$this.$div$percent(rhs, field, eq2)._1();
    }

    public static Polynomial $percent(Polynomial $this, Polynomial rhs, Field field, Eq eq2) {
        return (Polynomial)$this.$div$percent(rhs, field, eq2)._2();
    }

    public static Polynomial $times$times(Polynomial $this, int k, Rig ring, Eq eq2) {
        return $this.pow(k, ring, eq2);
    }

    public static Polynomial pow(Polynomial $this, int k, Rig ring, Eq eq2) {
        if (k < 0) {
            throw new IllegalArgumentException("negative exponent");
        }
        return k == 0 ? Polynomial$.MODULE$.one(eq2, ring, $this.ct()) : (k == 1 ? $this : Polynomial$class.loop$3($this, $this, k - 1, $this, ring, eq2));
    }

    public static Polynomial $colon$times(Polynomial $this, Object k, Semiring ring, Eq eq2) {
        return $this.$times$colon(k, ring, eq2);
    }

    public static Polynomial $colon$div(Polynomial $this, Object k, Field field, Eq eq2) {
        return $this.$colon$times(field.reciprocal(k), field, eq2);
    }

    public static int hashCode(Polynomial $this) {
        Iterator it = $this.termsIterator();
        return Polynomial$class.loop$4($this, 0, it);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equals(Polynomial $this, Object that) {
        boolean bl = false;
        if (that instanceof Polynomial) {
            bl = true;
            Polynomial polynomial = (Polynomial)that;
            if ($this.degree() == polynomial.degree()) {
                Iterator it1 = $this.termsIterator();
                Iterator it2 = polynomial.termsIterator();
                return Polynomial$class.loop$5($this, it1, it2);
            }
        }
        if (bl) {
            return false;
        }
        if ($this.isZero()) {
            Integer n = BoxesRunTime.boxToInteger((int)0);
            if (that == n) return true;
            if (that == null) return false;
            boolean bl2 = !(that instanceof Number) ? (!(that instanceof Character) ? that.equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)that), (Object)n)) : BoxesRunTime.equalsNumObject((Number)((Number)that), (Object)n);
            if (!bl2) return false;
            return true;
        }
        if ($this.degree() != 0) return false;
        Tuple2<int[], Object> tuple22 = Polynomial$.MODULE$.spire$math$Polynomial$$split($this, $this.ct());
        if (tuple22 == null) throw new MatchError(tuple22);
        Object object = tuple22._2();
        Object object2 = ScalaRunTime$.MODULE$.array_apply(object, 0);
        if (object2 == that) return true;
        if (object2 == null) return false;
        boolean bl3 = !(object2 instanceof Number) ? (!(object2 instanceof Character) ? object2.equals(that) : BoxesRunTime.equalsCharObject((Character)((Character)object2), (Object)that)) : BoxesRunTime.equalsNumObject((Number)((Number)object2), (Object)that);
        if (!bl3) return false;
        return true;
    }

    public static String toString(Polynomial $this) {
        String string2;
        if ($this.isZero()) {
            string2 = "(0)";
        } else {
            Object object;
            ArrayBuilder bldr = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Term.class));
            $this.foreach(new Serializable($this, bldr){
                public static final long serialVersionUID = 0L;
                private final ArrayBuilder bldr$2;

                public final ArrayBuilder<Term<C>> apply(int e, C c) {
                    return (ArrayBuilder)this.bldr$2.$plus$eq(new Term<C>(c, e));
                }
                {
                    this.bldr$2 = bldr$2;
                }
            });
            Term[] ts = (Term[])bldr.result();
            Order order = Term$.MODULE$.ordering();
            Order$ order$ = Order$.MODULE$;
            ClassTag classTag = ClassTag$.MODULE$.apply(Term.class);
            Predef$ predef$ = Predef$.MODULE$;
            QuickSort$.MODULE$.sort(ts, order.reverse(), classTag);
            String s = Predef$.MODULE$.refArrayOps((Object[])ts).mkString();
            StringBuilder stringBuilder = new StringBuilder().append((Object)"(");
            Predef$ predef$2 = Predef$.MODULE$;
            Object object2 = new StringOps(s).take(3);
            if (!(object2 != null ? !object2.equals(" - ") : " - " != null)) {
                Predef$ predef$3 = Predef$.MODULE$;
                object = new StringBuilder().append((Object)"-").append(new StringOps(s).drop(3)).toString();
            } else {
                Predef$ predef$4 = Predef$.MODULE$;
                object = new StringOps(s).drop(3);
            }
            string2 = stringBuilder.append(object).append((Object)")").toString();
        }
        return string2;
    }

    public static PolyDense toDense$mcD$sp(Polynomial $this, Semiring ring, Eq eq2) {
        return $this.toDense(ring, eq2);
    }

    public static PolySparse toSparse$mcD$sp(Polynomial $this, Semiring ring, Eq eq2) {
        return $this.toSparse(ring, eq2);
    }

    public static void foreach$mcD$sp(Polynomial $this, Function2 f) {
        $this.foreach(f);
    }

    public static void foreachNonZero$mcD$sp(Polynomial $this, Function2 f, Semiring ring, Eq eq2) {
        $this.foreachNonZero(f, ring, eq2);
    }

    public static double[] coeffsArray$mcD$sp(Polynomial $this, Semiring ring) {
        return (double[])$this.coeffsArray(ring);
    }

    public static List terms$mcD$sp(Polynomial $this, Semiring ring, Eq eq2) {
        return $this.terms(ring, eq2);
    }

    public static Map data$mcD$sp(Polynomial $this, Semiring ring, Eq eq2) {
        return $this.data(ring, eq2);
    }

    public static double nth$mcD$sp(Polynomial $this, int n, Semiring ring) {
        return BoxesRunTime.unboxToDouble($this.nth(n, ring));
    }

    public static Term maxTerm$mcD$sp(Polynomial $this, Semiring ring) {
        return $this.maxTerm(ring);
    }

    public static Term minTerm$mcD$sp(Polynomial $this, Semiring ring, Eq eq2) {
        return $this.minTerm(ring, eq2);
    }

    public static double maxOrderTermCoeff$mcD$sp(Polynomial $this, Semiring ring) {
        return BoxesRunTime.unboxToDouble($this.maxOrderTermCoeff(ring));
    }

    public static Polynomial reductum$mcD$sp(Polynomial $this, Eq e, Semiring ring, ClassTag ct) {
        return $this.reductum(e, ring, ct);
    }

    public static double apply$mcD$sp(Polynomial $this, double x, Semiring r) {
        return BoxesRunTime.unboxToDouble((Object)$this.apply(BoxesRunTime.boxToDouble((double)x), r));
    }

    public static Object evalWith$mcD$sp(Polynomial $this, Object x, Function1 f, Semiring evidence$56, Eq evidence$57, ClassTag evidence$58, Semiring ring, Eq eq2) {
        return $this.evalWith(x, f, evidence$56, evidence$57, evidence$58, ring, eq2);
    }

    public static Polynomial compose$mcD$sp(Polynomial $this, Polynomial y, Rig ring, Eq eq2) {
        return $this.compose(y, ring, eq2);
    }

    public static Polynomial shift$mcD$sp(Polynomial $this, double h, Ring ring, Eq eq2) {
        return $this.shift(BoxesRunTime.boxToDouble((double)h), ring, eq2);
    }

    public static Polynomial monic$mcD$sp(Polynomial $this, Field f, Eq eq2) {
        return $this.monic(f, eq2);
    }

    public static Polynomial derivative$mcD$sp(Polynomial $this, Ring ring, Eq eq2) {
        return $this.derivative(ring, eq2);
    }

    public static Polynomial integral$mcD$sp(Polynomial $this, Field field, Eq eq2) {
        return $this.integral(field, eq2);
    }

    public static int signVariations$mcD$sp(Polynomial $this, Semiring ring, Eq eq2, Signed signed) {
        return $this.signVariations(ring, eq2, signed);
    }

    public static Polynomial removeZeroRoots$mcD$sp(Polynomial $this, Semiring ring, Eq eq2) {
        return $this.removeZeroRoots(ring, eq2);
    }

    public static Polynomial map$mcD$sp(Polynomial $this, Function1 f, Semiring evidence$59, Eq evidence$60, ClassTag evidence$61, Semiring ring, Eq eq2) {
        return $this.map(f, evidence$59, evidence$60, evidence$61, ring, eq2);
    }

    public static Polynomial mapTerms$mcD$sp(Polynomial $this, Function1 f, Semiring evidence$62, Eq evidence$63, ClassTag evidence$64, Semiring ring, Eq eq2) {
        return $this.mapTerms(f, evidence$62, evidence$63, evidence$64, ring, eq2);
    }

    public static Polynomial flip$mcD$sp(Polynomial $this, Rng ring, Eq eq2) {
        return $this.flip(ring, eq2);
    }

    public static Polynomial reciprocal$mcD$sp(Polynomial $this, Semiring ring, Eq eq2) {
        return $this.reciprocal(ring, eq2);
    }

    public static Polynomial unary_$minus$mcD$sp(Polynomial $this, Rng ring) {
        return $this.unary_$minus(ring);
    }

    public static Polynomial $plus$mcD$sp(Polynomial $this, Polynomial rhs, Semiring ring, Eq eq2) {
        return $this.$plus(rhs, ring, eq2);
    }

    public static Polynomial $minus$mcD$sp(Polynomial $this, Polynomial rhs, Rng ring, Eq eq2) {
        return $this.$minus(rhs, ring, eq2);
    }

    public static Polynomial $times$mcD$sp(Polynomial $this, Polynomial rhs, Semiring ring, Eq eq2) {
        return $this.$times(rhs, ring, eq2);
    }

    public static Polynomial $div$tilde$mcD$sp(Polynomial $this, Polynomial rhs, Field field, Eq eq2) {
        return $this.$div$tilde(rhs, field, eq2);
    }

    public static Tuple2 $div$percent$mcD$sp(Polynomial $this, Polynomial rhs, Field field, Eq eq2) {
        return $this.$div$percent(rhs, field, eq2);
    }

    public static Polynomial $percent$mcD$sp(Polynomial $this, Polynomial rhs, Field field, Eq eq2) {
        return $this.$percent(rhs, field, eq2);
    }

    public static Polynomial $times$times$mcD$sp(Polynomial $this, int k, Rig ring, Eq eq2) {
        return $this.$times$times(k, ring, eq2);
    }

    public static Polynomial pow$mcD$sp(Polynomial $this, int k, Rig ring, Eq eq2) {
        return $this.pow(k, ring, eq2);
    }

    public static Polynomial $times$colon$mcD$sp(Polynomial $this, double k, Semiring ring, Eq eq2) {
        return $this.$times$colon(BoxesRunTime.boxToDouble((double)k), ring, eq2);
    }

    public static Polynomial $colon$times$mcD$sp(Polynomial $this, double k, Semiring ring, Eq eq2) {
        return $this.$colon$times(BoxesRunTime.boxToDouble((double)k), ring, eq2);
    }

    public static Polynomial $colon$div$mcD$sp(Polynomial $this, double k, Field field, Eq eq2) {
        return $this.$colon$div(BoxesRunTime.boxToDouble((double)k), field, eq2);
    }

    private static final Object loop$2(Polynomial $this, Object k, SafeLong y, Object acc, Object d$1, long mask$1, Ring ring$3) {
        while (!y.isValidInt()) {
            SafeLong z = y.$greater$greater(30);
            Object r = ring$3.fromInt(y.$amp(mask$1).toInt());
            acc = ring$3.plus(ring$3.times(k, r), acc);
            y = z;
            k = ring$3.times(d$1, k);
        }
        return ring$3.plus(ring$3.times(k, ring$3.fromInt(y.toInt())), acc);
    }

    public static final Object fromSafeLong$1(Polynomial $this, SafeLong x, Ring ring$3) {
        Object object;
        if (x.isValidInt()) {
            object = ring$3.fromInt(x.toInt());
        } else {
            Object d = ring$3.fromInt(0x40000000);
            object = Polynomial$class.loop$2($this, ring$3.one(), x, ring$3.zero(), d, 0x3FFFFFFFL, ring$3);
        }
        return object;
    }

    private static final Polynomial loop$3(Polynomial $this, Polynomial b, int k, Polynomial extra, Rig ring$5, Eq eq$3) {
        while (k != 1) {
            extra = (k & 1) == 1 ? b.$times(extra, ring$5, eq$3) : extra;
            k >>>= 1;
            b = b.$times(b, ring$5, eq$3);
        }
        return b.$times(extra, ring$5, eq$3);
    }

    private static final int loop$4(Polynomial $this, int n, Iterator it$1) {
        while (it$1.hasNext()) {
            Term term = (Term)it$1.next();
            n ^= -18017705 * term.exp() ^ ScalaRunTime$.MODULE$.hash(term.coeff());
        }
        return n;
    }

    private static final boolean loop$5(Polynomial $this, Iterator it1$1, Iterator it2$1) {
        boolean bl;
        block6: {
            boolean has2;
            boolean has1;
            block5: {
                boolean bl2;
                do {
                    has1 = it1$1.hasNext();
                    has2 = it2$1.hasNext();
                    if (!has1 || !has2) break block5;
                    Object object = it2$1.next();
                    Object object2 = it1$1.next();
                    if (object2 != object) {
                        if (object2 != null) {
                            if (!(object2 instanceof Number)) {
                                if (!(object2 instanceof Character)) {
                                    bl2 = object2.equals(object);
                                    continue;
                                }
                                bl2 = BoxesRunTime.equalsCharObject((Character)((Character)object2), (Object)object);
                                continue;
                            }
                            bl2 = BoxesRunTime.equalsNumObject((Number)((Number)object2), (Object)object);
                            continue;
                        }
                        bl2 = false;
                        continue;
                    }
                    bl2 = true;
                } while (bl2);
                bl = false;
                break block6;
            }
            bl = has1 == has2;
        }
        return bl;
    }

    public static void $init$(Polynomial $this) {
    }
}

