/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import spire.math.Natural;
import spire.math.Natural$;
import spire.math.UInt;
import spire.math.UInt$;

public abstract class Natural$class {
    public static Object foldDigitsLeft(Natural $this, Object a, Function2 f) {
        return Natural$class.recur$1($this, $this, a, a, f);
    }

    public static Object foldDigitsRight(Natural $this, Object a, Function2 f) {
        return $this.reversed().foldDigitsLeft(a, f);
    }

    public static int getNumBits(Natural $this) {
        return Natural$class.recur$2($this, $this, 0);
    }

    public static int getDigitLength(Natural $this) {
        return Natural$class.recur$3($this, $this, 0);
    }

    public static List toList(Natural $this) {
        return Natural$class.recur$4($this, $this, (List)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] toArray(Natural $this) {
        void var2_2;
        int n = $this.getDigitLength();
        int[] arr = new int[n];
        Natural$class.recur$5($this, $this, n - 1, arr);
        return var2_2;
    }

    public static Natural reversed(Natural $this) {
        Natural natural;
        if ($this instanceof Natural.Digit) {
            Natural.Digit digit = (Natural.Digit)$this;
            natural = Natural$class.recur$6($this, digit.tl(), new Natural.End(digit.d()));
        } else {
            natural = $this;
        }
        return natural;
    }

    public static Natural trim(Natural $this) {
        return Natural$class.recur$7($this, $this.reversed()).reversed();
    }

    public static int toInt(Natural $this) {
        return UInt$.MODULE$.toInt$extension($this.digit()) & Integer.MAX_VALUE;
    }

    public static long toLong(Natural $this) {
        block4: {
            long l;
            block3: {
                block2: {
                    if (!($this instanceof Natural.End)) break block2;
                    Natural.End end = (Natural.End)$this;
                    l = UInt$.MODULE$.toLong$extension(end.d());
                    break block3;
                }
                if (!($this instanceof Natural.Digit)) break block4;
                Natural.Digit digit = (Natural.Digit)$this;
                l = (digit.tl().toLong() << (int)32L) + UInt$.MODULE$.toLong$extension(digit.d());
            }
            return l;
        }
        throw new MatchError((Object)$this);
    }

    public static BigInt toBigInt(Natural $this) {
        block4: {
            BigInt bigInt;
            block3: {
                block2: {
                    if (!($this instanceof Natural.End)) break block2;
                    Natural.End end = (Natural.End)$this;
                    bigInt = package$.MODULE$.BigInt().apply(UInt$.MODULE$.toLong$extension(end.d()));
                    break block3;
                }
                if (!($this instanceof Natural.Digit)) break block4;
                Natural.Digit digit = (Natural.Digit)$this;
                bigInt = digit.tl().toBigInt().$less$less(32).$plus(package$.MODULE$.BigInt().apply(UInt$.MODULE$.toLong$extension(digit.d())));
            }
            return bigInt;
        }
        throw new MatchError((Object)$this);
    }

    public static String toString(Natural $this) {
        return Natural$class.recur$8($this, $this, "");
    }

    public static String toRepr(Natural $this) {
        return $this.toList().mkString("Natural(", ", ", ")");
    }

    public static boolean isZero(Natural $this) {
        return Natural$class.recur$9($this, $this);
    }

    public static boolean isOne(Natural $this) {
        block4: {
            boolean bl;
            block3: {
                block2: {
                    if (!($this instanceof Natural.End)) break block2;
                    Natural.End end = (Natural.End)$this;
                    UInt$ uInt$ = UInt$.MODULE$;
                    bl = UInt$.MODULE$.$eq$eq$extension1(end.d(), 1);
                    break block3;
                }
                if (!($this instanceof Natural.Digit)) break block4;
                Natural.Digit digit = (Natural.Digit)$this;
                UInt$ uInt$ = UInt$.MODULE$;
                bl = UInt$.MODULE$.$eq$eq$extension1(digit.d(), 1) && digit.tl().isZero();
            }
            return bl;
        }
        throw new MatchError((Object)$this);
    }

    public static boolean isOdd(Natural $this) {
        UInt$ uInt$ = UInt$.MODULE$;
        UInt$ uInt$2 = UInt$.MODULE$;
        return UInt$.MODULE$.$eq$eq$extension1(UInt$.MODULE$.$amp$extension($this.digit(), 1), 1);
    }

    public static boolean isEven(Natural $this) {
        UInt$ uInt$ = UInt$.MODULE$;
        UInt$ uInt$2 = UInt$.MODULE$;
        return UInt$.MODULE$.$eq$eq$extension1(UInt$.MODULE$.$amp$extension($this.digit(), 1), 0);
    }

    public static int powerOfTwo(Natural $this) {
        return Natural$class.recur$10($this, $this, 0, -1);
    }

    public static int compare(Natural $this, int rhs) {
        block5: {
            int n;
            block4: {
                block3: {
                    if (!($this instanceof Natural.End)) break block3;
                    Natural.End end = (Natural.End)$this;
                    n = UInt$.MODULE$.$less$extension(end.d(), rhs) ? -1 : (UInt$.MODULE$.$greater$extension(end.d(), rhs) ? 1 : 0);
                    break block4;
                }
                if (!($this instanceof Natural.Digit)) break block5;
                Natural.Digit digit = (Natural.Digit)$this;
                n = digit.tl().isZero() ? (UInt$.MODULE$.$greater$extension(digit.d(), rhs) ? 1 : (UInt$.MODULE$.$less$extension(digit.d(), rhs) ? -1 : 0)) : 1;
            }
            return n;
        }
        throw new MatchError((Object)$this);
    }

    public static int compare(Natural $this, Natural rhs) {
        return Natural$class.recur$11($this, $this, rhs, 0);
    }

    public static final boolean equals(Natural $this, Object rhs) {
        int n;
        Natural natural;
        boolean bl = rhs instanceof Natural ? $this.compare(natural = (Natural)rhs) == 0 : (rhs instanceof UInt ? $this.compare(n = ((UInt)rhs).signed()) == 0 : false);
        return bl;
    }

    public static boolean $less(Natural $this, Natural rhs) {
        return $this.compare(rhs) < 0;
    }

    public static boolean $less$eq(Natural $this, Natural rhs) {
        return $this.compare(rhs) <= 0;
    }

    public static boolean $greater(Natural $this, Natural rhs) {
        return $this.compare(rhs) > 0;
    }

    public static boolean $greater$eq(Natural $this, Natural rhs) {
        return $this.compare(rhs) >= 0;
    }

    public static boolean $less(Natural $this, int r) {
        return $this.compare(r) < 0;
    }

    public static boolean $less$eq(Natural $this, int r) {
        return $this.compare(r) <= 0;
    }

    public static boolean $greater(Natural $this, int r) {
        return $this.compare(r) > 0;
    }

    public static boolean $greater$eq(Natural $this, int r) {
        return $this.compare(r) >= 0;
    }

    public static boolean $less(Natural $this, BigInt r) {
        return $this.toBigInt().compare(r) < 0;
    }

    public static boolean $less$eq(Natural $this, BigInt r) {
        return $this.toBigInt().compare(r) <= 0;
    }

    public static boolean $greater(Natural $this, BigInt r) {
        return $this.toBigInt().compare(r) > 0;
    }

    public static boolean $greater$eq(Natural $this, BigInt r) {
        return $this.toBigInt().compare(r) >= 0;
    }

    public static Natural $div$tilde(Natural $this, int rd) {
        return $this.$div(rd);
    }

    public static BigInt $plus(Natural $this, BigInt rhs) {
        return $this.toBigInt().$plus(rhs);
    }

    public static BigInt $minus(Natural $this, BigInt rhs) {
        return $this.toBigInt().$minus(rhs);
    }

    public static BigInt $times(Natural $this, BigInt rhs) {
        return $this.toBigInt().$times(rhs);
    }

    public static BigInt $div$tilde(Natural $this, BigInt rhs) {
        return $this.toBigInt().$div(rhs);
    }

    public static BigInt $div(Natural $this, BigInt rhs) {
        return $this.toBigInt().$div(rhs);
    }

    public static BigInt $percent(Natural $this, BigInt rhs) {
        return $this.toBigInt().$percent(rhs);
    }

    public static Tuple2 $div$percent(Natural $this, BigInt rhs) {
        return $this.toBigInt().$div$percent(rhs);
    }

    public static Natural $plus(Natural $this, Natural rhs) {
        return Natural$class.recur$12($this, $this, rhs, 0L);
    }

    public static Natural $minus(Natural $this, Natural rhs) {
        if ($this.$less(rhs)) {
            Predef$ predef$ = Predef$.MODULE$;
            throw new ArithmeticException(new StringOps("negative subtraction: %s - %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this, rhs})));
        }
        return Natural$class.recur$13($this, $this, rhs, 0L);
    }

    public static Natural $times(Natural $this, Natural rhs) {
        block4: {
            block7: {
                Natural natural;
                block3: {
                    Natural natural2;
                    block6: {
                        Natural.Digit digit;
                        block5: {
                            block2: {
                                if (!($this instanceof Natural.End)) break block2;
                                Natural.End end = (Natural.End)$this;
                                natural = rhs.$times(end.d());
                                break block3;
                            }
                            if (!($this instanceof Natural.Digit)) break block4;
                            digit = (Natural.Digit)$this;
                            if (!(rhs instanceof Natural.End)) break block5;
                            Natural.End end = (Natural.End)rhs;
                            natural2 = $this.$times(end.d());
                            break block6;
                        }
                        if (!(rhs instanceof Natural.Digit)) break block7;
                        Natural.Digit digit2 = (Natural.Digit)rhs;
                        UInt$ uInt$ = UInt$.MODULE$;
                        UInt$ uInt$2 = UInt$.MODULE$;
                        UInt$ uInt$3 = UInt$.MODULE$;
                        UInt$ uInt$4 = UInt$.MODULE$;
                        natural2 = new Natural.Digit(0, new Natural.Digit(0, digit.tl().$times(digit2.tl()))).$plus(new Natural.Digit(0, digit.tl().$times(digit2.d()))).$plus(new Natural.Digit(0, digit2.tl().$times(digit.d()))).$plus(Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(digit.d()) * UInt$.MODULE$.toLong$extension(digit2.d())));
                    }
                    natural = natural2;
                }
                return natural;
            }
            throw new MatchError((Object)rhs);
        }
        throw new MatchError((Object)$this);
    }

    public static Natural pow(Natural $this, Natural rhs) {
        return Natural$class._pow$1($this, Natural$.MODULE$.apply(1L), $this, rhs);
    }

    public static Natural pow(Natural $this, int rhs) {
        return Natural$class._pow$2($this, Natural$.MODULE$.apply(1L), $this, rhs);
    }

    public static Natural $div$tilde(Natural $this, Natural rhs) {
        return $this.$div(rhs);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Natural $div(Natural $this, Natural rhs) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!(rhs instanceof Natural.End)) break block5;
                        var2_2 = (Natural.End)rhs;
                        var8_3 = $this.$div(var2_2.d());
                        ** GOTO lbl26
                    }
                    if (!(rhs instanceof Natural.Digit)) break block6;
                    if (!($this instanceof Natural.End)) break block7;
                    var3_4 = UInt$.MODULE$;
                    var7_5 /* !! */  = new Natural.End(0);
                    ** GOTO lbl25
                }
                if (!($this instanceof Natural.Digit)) break block8;
                var4_6 = UInt$.MODULE$;
                var5_7 = rhs.compare(1);
                switch (var5_7) {
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)var5_7));
                    }
                    case 1: {
                        p = rhs.powerOfTwo();
                        v0 = p >= 0 ? $this.$greater$greater(p) : (Natural)Natural$class.longdiv($this, $this, rhs)._1();
                        ** GOTO lbl24
                    }
                    case 0: {
                        v0 = $this;
lbl24:
                        // 2 sources

                        var7_5 /* !! */  = v0;
lbl25:
                        // 2 sources

                        var8_3 = var7_5 /* !! */ ;
lbl26:
                        // 2 sources

                        return var8_3;
                    }
                    case -1: 
                }
                throw new IllegalArgumentException("/ by zero");
            }
            throw new MatchError((Object)$this);
        }
        throw new MatchError((Object)rhs);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Natural $percent(Natural $this, Natural rhs) {
        block8: {
            block10: {
                block9: {
                    block7: {
                        if (!(rhs instanceof Natural.End)) break block7;
                        var2_2 = (Natural.End)rhs;
                        var10_3 = $this.$percent(var2_2.d());
                        ** GOTO lbl31
                    }
                    if (!(rhs instanceof Natural.Digit)) break block8;
                    if (!($this instanceof Natural.End)) break block9;
                    var3_4 = (Natural.End)$this;
                    var9_5 = new Natural.End(var3_4.d());
                    ** GOTO lbl30
                }
                if (!($this instanceof Natural.Digit)) break block10;
                var4_6 = UInt$.MODULE$;
                var5_7 = rhs.compare(1);
                switch (var5_7) {
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)var5_7));
                    }
                    case 1: {
                        p = rhs.powerOfTwo();
                        if (p >= 0) {
                            var7_9 = UInt$.MODULE$;
                            v0 /* !! */  = $this.$amp(Natural$.MODULE$.apply(1L).$less$less(p).$minus(1));
                        } else {
                            v0 /* !! */  = (Natural)Natural$class.longdiv($this, $this, rhs)._2();
                        }
                        ** GOTO lbl29
                    }
                    case 0: {
                        var8_10 = UInt$.MODULE$;
                        v0 /* !! */  = new Natural.End(0);
lbl29:
                        // 3 sources

                        var9_5 = v0 /* !! */ ;
lbl30:
                        // 2 sources

                        var10_3 = var9_5;
lbl31:
                        // 2 sources

                        return var10_3;
                    }
                    case -1: 
                }
                throw new IllegalArgumentException("/ by zero");
            }
            throw new MatchError((Object)$this);
        }
        throw new MatchError((Object)rhs);
    }

    /*
     * Unable to fully structure code
     */
    public static Tuple2 $div$percent(Natural $this, Natural rhs) {
        block8: {
            block10: {
                block9: {
                    block7: {
                        if (!(rhs instanceof Natural.End)) break block7;
                        var2_2 = (Natural.End)rhs;
                        var10_3 = new Tuple2((Object)$this.$div(var2_2.d()), (Object)$this.$percent(var2_2.d()));
                        ** GOTO lbl31
                    }
                    if (!(rhs instanceof Natural.Digit)) break block8;
                    if (!($this instanceof Natural.End)) break block9;
                    var3_4 = UInt$.MODULE$;
                    var9_5 = new Tuple2((Object)new Natural.End(0), (Object)$this);
                    ** GOTO lbl30
                }
                if (!($this instanceof Natural.Digit)) break block10;
                var4_6 = UInt$.MODULE$;
                var5_7 = rhs.compare(1);
                switch (var5_7) {
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)var5_7));
                    }
                    case 1: {
                        p = rhs.powerOfTwo();
                        if (p >= 0) {
                            var6_9 = UInt$.MODULE$;
                            mask = Natural$.MODULE$.apply(1L).$less$less(p).$minus(1);
                            v0 = new Tuple2((Object)$this.$greater$greater(p), (Object)$this.$amp(mask));
                        } else {
                            v0 = Natural$class.longdiv($this, $this, rhs);
                        }
                        ** GOTO lbl29
                    }
                    case 0: {
                        v0 = new Tuple2((Object)$this, (Object)Natural$.MODULE$.apply(0L));
lbl29:
                        // 3 sources

                        var9_5 = v0;
lbl30:
                        // 2 sources

                        var10_3 = var9_5;
lbl31:
                        // 2 sources

                        return var10_3;
                    }
                    case -1: 
                }
                throw new IllegalArgumentException("/ by zero");
            }
            throw new MatchError((Object)$this);
        }
        throw new MatchError((Object)rhs);
    }

    private static Tuple2 longdiv(Natural $this, Natural num, Natural denom) {
        Natural rem = num;
        Natural quo = Natural$.MODULE$.apply(0L);
        int remBits = num.getNumBits();
        int denomBits = denom.getNumBits();
        int shift = remBits - denomBits;
        while (shift >= 0) {
            Natural shifted = denom.$less$less(shift);
            if (shifted.$less$eq(rem)) {
                quo = quo.$plus(Natural$.MODULE$.apply(1L).$less$less(shift));
                rem = rem.$minus(shifted);
                shift = rem.getNumBits() - denomBits;
                continue;
            }
            --shift;
        }
        return new Tuple2((Object)quo, (Object)rem);
    }

    public static Natural $less$less(Natural $this, int n) {
        int m = n & 0x1F;
        Natural num = Natural$class.recur$14($this, $this, 0L, m);
        Predef$ predef$ = Predef$.MODULE$;
        return (Natural)RichInt$.MODULE$.until$extension0(0, n / 32).foldLeft((Object)num, (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Natural.Digit apply(Natural n, int x$4) {
                UInt$ uInt$ = UInt$.MODULE$;
                return new Natural.Digit(0, n);
            }
        });
    }

    public static Natural chop(Natural $this, int n) {
        return Natural$class.recur$15($this, $this, n);
    }

    public static Natural $greater$greater(Natural $this, int n) {
        int m = n & 0x1F;
        return Natural$class.recur$16($this, $this.chop(n / 32).reversed(), 0L, m).reversed();
    }

    public static Natural $bar(Natural $this, Natural rhs) {
        block7: {
            block10: {
                Natural natural;
                block6: {
                    Natural.Digit digit;
                    block9: {
                        Natural.Digit digit2;
                        block8: {
                            block2: {
                                block5: {
                                    Natural natural2;
                                    block4: {
                                        Natural.End end;
                                        block3: {
                                            if (!($this instanceof Natural.End)) break block2;
                                            end = (Natural.End)$this;
                                            if (!(rhs instanceof Natural.End)) break block3;
                                            Natural.End end2 = (Natural.End)rhs;
                                            natural2 = new Natural.End(UInt$.MODULE$.$bar$extension(end.d(), end2.d()));
                                            break block4;
                                        }
                                        if (!(rhs instanceof Natural.Digit)) break block5;
                                        Natural.Digit digit3 = (Natural.Digit)rhs;
                                        natural2 = new Natural.Digit(UInt$.MODULE$.$bar$extension(end.d(), digit3.d()), digit3.tl());
                                    }
                                    natural = natural2;
                                    break block6;
                                }
                                throw new MatchError((Object)rhs);
                            }
                            if (!($this instanceof Natural.Digit)) break block7;
                            digit2 = (Natural.Digit)$this;
                            if (!(rhs instanceof Natural.End)) break block8;
                            Natural.End end = (Natural.End)rhs;
                            digit = new Natural.Digit(UInt$.MODULE$.$bar$extension(digit2.d(), end.d()), digit2.tl());
                            break block9;
                        }
                        if (!(rhs instanceof Natural.Digit)) break block10;
                        Natural.Digit digit4 = (Natural.Digit)rhs;
                        digit = new Natural.Digit(UInt$.MODULE$.$bar$extension(digit2.d(), digit4.d()), digit2.tl().$bar(digit4.tl()));
                    }
                    natural = digit;
                }
                return natural;
            }
            throw new MatchError((Object)rhs);
        }
        throw new MatchError((Object)$this);
    }

    public static Natural $bar(Natural $this, int rhs) {
        block4: {
            Natural natural;
            block3: {
                block2: {
                    if (!($this instanceof Natural.End)) break block2;
                    Natural.End end = (Natural.End)$this;
                    natural = new Natural.End(UInt$.MODULE$.$bar$extension(end.d(), rhs));
                    break block3;
                }
                if (!($this instanceof Natural.Digit)) break block4;
                Natural.Digit digit = (Natural.Digit)$this;
                natural = new Natural.Digit(UInt$.MODULE$.$bar$extension(digit.d(), rhs), digit.tl());
            }
            return natural;
        }
        throw new MatchError((Object)$this);
    }

    public static Natural $amp(Natural $this, Natural rhs) {
        return Natural$class.and$1($this, $this, rhs).trim();
    }

    public static Natural $amp(Natural $this, int rhs) {
        return new Natural.End(UInt$.MODULE$.$amp$extension($this.digit(), rhs));
    }

    public static Natural $up(Natural $this, Natural rhs) {
        return Natural$class.xor$1($this, $this, rhs).trim();
    }

    public static Natural $up(Natural $this, int rhs) {
        block4: {
            Natural natural;
            block3: {
                block2: {
                    if (!($this instanceof Natural.End)) break block2;
                    Natural.End end = (Natural.End)$this;
                    natural = new Natural.End(UInt$.MODULE$.$up$extension(end.d(), rhs));
                    break block3;
                }
                if (!($this instanceof Natural.Digit)) break block4;
                Natural.Digit digit = (Natural.Digit)$this;
                natural = new Natural.Digit(UInt$.MODULE$.$up$extension(digit.d(), rhs), digit.tl());
            }
            return natural;
        }
        throw new MatchError((Object)$this);
    }

    public static boolean foldDigitsLeft$mZc$sp(Natural $this, boolean a, Function2 f) {
        return Natural$class.recur$18($this, $this, a, a, f);
    }

    public static byte foldDigitsLeft$mBc$sp(Natural $this, byte a, Function2 f) {
        return Natural$class.recur$19($this, $this, a, a, f);
    }

    public static char foldDigitsLeft$mCc$sp(Natural $this, char a, Function2 f) {
        return Natural$class.recur$20($this, $this, a, a, f);
    }

    public static double foldDigitsLeft$mDc$sp(Natural $this, double a, Function2 f) {
        return Natural$class.recur$21($this, $this, a, a, f);
    }

    public static float foldDigitsLeft$mFc$sp(Natural $this, float a, Function2 f) {
        return Natural$class.recur$22($this, $this, a, a, f);
    }

    public static int foldDigitsLeft$mIc$sp(Natural $this, int a, Function2 f) {
        return Natural$class.recur$23($this, $this, a, a, f);
    }

    public static long foldDigitsLeft$mJc$sp(Natural $this, long a, Function2 f) {
        return Natural$class.recur$24($this, $this, a, a, f);
    }

    public static short foldDigitsLeft$mSc$sp(Natural $this, short a, Function2 f) {
        return Natural$class.recur$25($this, $this, a, a, f);
    }

    public static void foldDigitsLeft$mVc$sp(Natural $this, BoxedUnit a, Function2 f) {
        Natural$class.recur$26($this, $this, a, a, f);
    }

    public static boolean foldDigitsRight$mZc$sp(Natural $this, boolean a, Function2 f) {
        return $this.reversed().foldDigitsLeft$mZc$sp(a, (Function2<Object, UInt, Object>)f);
    }

    public static byte foldDigitsRight$mBc$sp(Natural $this, byte a, Function2 f) {
        return $this.reversed().foldDigitsLeft$mBc$sp(a, (Function2<Object, UInt, Object>)f);
    }

    public static char foldDigitsRight$mCc$sp(Natural $this, char a, Function2 f) {
        return $this.reversed().foldDigitsLeft$mCc$sp(a, (Function2<Object, UInt, Object>)f);
    }

    public static double foldDigitsRight$mDc$sp(Natural $this, double a, Function2 f) {
        return $this.reversed().foldDigitsLeft$mDc$sp(a, (Function2<Object, UInt, Object>)f);
    }

    public static float foldDigitsRight$mFc$sp(Natural $this, float a, Function2 f) {
        return $this.reversed().foldDigitsLeft$mFc$sp(a, (Function2<Object, UInt, Object>)f);
    }

    public static int foldDigitsRight$mIc$sp(Natural $this, int a, Function2 f) {
        return $this.reversed().foldDigitsLeft$mIc$sp(a, (Function2<Object, UInt, Object>)f);
    }

    public static long foldDigitsRight$mJc$sp(Natural $this, long a, Function2 f) {
        return $this.reversed().foldDigitsLeft$mJc$sp(a, (Function2<Object, UInt, Object>)f);
    }

    public static short foldDigitsRight$mSc$sp(Natural $this, short a, Function2 f) {
        return $this.reversed().foldDigitsLeft$mSc$sp(a, (Function2<Object, UInt, Object>)f);
    }

    public static void foldDigitsRight$mVc$sp(Natural $this, BoxedUnit a, Function2 f) {
        $this.reversed().foldDigitsLeft$mVc$sp(a, (Function2<BoxedUnit, UInt, BoxedUnit>)f);
    }

    private static final Object recur$1(Natural $this, Natural next, Object sofar, Object a$1, Function2 f$1) {
        while (true) {
            if (next instanceof Natural.End) {
                Natural.End end = (Natural.End)next;
                return f$1.apply(a$1, (Object)new UInt(end.d()));
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            Natural natural = digit.tl();
            f$1.apply(a$1, (Object)new UInt(digit.d()));
            next = natural;
        }
        throw new MatchError((Object)next);
    }

    private static final int bit$1(Natural $this, int n, int b) {
        while (!UInt$.MODULE$.$eq$eq$extension0(n, 0L)) {
            ++b;
            n = UInt$.MODULE$.$greater$greater$greater$extension(n, 1);
        }
        return b;
    }

    private static final int recur$2(Natural $this, Natural next, int b) {
        while (true) {
            if (next instanceof Natural.End) {
                Natural.End end = (Natural.End)next;
                return b + Natural$class.bit$1($this, end.d(), 0);
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            b += 32;
            next = digit.tl();
        }
        throw new MatchError((Object)next);
    }

    private static final int recur$3(Natural $this, Natural next, int n) {
        while (true) {
            if (next instanceof Natural.End) {
                return n + 1;
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            ++n;
            next = digit.tl();
        }
        throw new MatchError((Object)next);
    }

    private static final List recur$4(Natural $this, Natural next, List sofar) {
        while (true) {
            if (next instanceof Natural.End) {
                Natural.End end = (Natural.End)next;
                int n = end.d();
                return sofar.$colon$colon((Object)new UInt(n));
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            int n = digit.d();
            sofar = sofar.$colon$colon((Object)new UInt(n));
            next = digit.tl();
        }
        throw new MatchError((Object)next);
    }

    private static final void recur$5(Natural $this, Natural next, int i, int[] arr$1) {
        while (true) {
            if (next instanceof Natural.End) {
                Natural.End end = (Natural.End)next;
                arr$1[i] = end.d();
                return;
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            arr$1[i] = digit.d();
            --i;
            next = digit.tl();
        }
        throw new MatchError((Object)next);
    }

    private static final Natural recur$6(Natural $this, Natural next, Natural sofar) {
        while (true) {
            if (next instanceof Natural.End) {
                Natural.End end = (Natural.End)next;
                return new Natural.Digit(end.d(), sofar);
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            sofar = new Natural.Digit(digit.d(), sofar);
            next = digit.tl();
        }
        throw new MatchError((Object)next);
    }

    private static final Natural recur$7(Natural $this, Natural next) {
        block7: {
            block6: {
                while (next instanceof Natural.Digit) {
                    Natural.Digit digit = (Natural.Digit)next;
                    UInt$ uInt$ = UInt$.MODULE$;
                    if (UInt$.MODULE$.$eq$eq$extension1(digit.d(), 0)) {
                        next = digit.tl();
                        continue;
                    }
                    break block6;
                }
                if (!(next instanceof Natural.End)) break block7;
            }
            return next;
        }
        throw new MatchError((Object)next);
    }

    private static final String recur$8(Natural $this, Natural next, String s) {
        block3: {
            Tuple2<Natural, Natural> tuple22;
            while (true) {
                Natural r;
                Natural q;
                block6: {
                    String string;
                    block5: {
                        block4: {
                            if (!(next instanceof Natural.End)) break block4;
                            Natural.End end = (Natural.End)next;
                            string = new StringBuilder().append((Object)((Object)BoxesRunTime.boxToLong((long)UInt$.MODULE$.toLong$extension(end.d()))).toString()).append((Object)s).toString();
                            break block5;
                        }
                        if (!(next instanceof Natural.Digit)) break block3;
                        tuple22 = next.$div$percent(Natural$.MODULE$.denom());
                        if (tuple22 == null) break;
                        Tuple2 tuple23 = new Tuple2(tuple22._1(), tuple22._2());
                        q = (Natural)tuple23._1();
                        r = (Natural)tuple23._2();
                        Natural natural = q;
                        UInt$ uInt$ = UInt$.MODULE$;
                        UInt uInt = new UInt(0);
                        if (natural != null ? !((Object)natural).equals(uInt) : uInt != null) break block6;
                        string = new StringBuilder().append((Object)((Object)BoxesRunTime.boxToLong((long)UInt$.MODULE$.toLong$extension(r.digit()))).toString()).append((Object)s).toString();
                    }
                    return string;
                }
                Predef$ predef$ = Predef$.MODULE$;
                s = new StringOps("%09d%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)UInt$.MODULE$.toLong$extension(r.digit())), s}));
                next = q;
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError((Object)next);
    }

    private static final boolean recur$9(Natural $this, Natural next) {
        block3: {
            boolean bl;
            block2: {
                while (true) {
                    if (next instanceof Natural.End) {
                        Natural.End end = (Natural.End)next;
                        UInt$ uInt$ = UInt$.MODULE$;
                        bl = UInt$.MODULE$.$eq$eq$extension1(end.d(), 0);
                        break block2;
                    }
                    if (!(next instanceof Natural.Digit)) break block3;
                    Natural.Digit digit = (Natural.Digit)next;
                    UInt$ uInt$ = UInt$.MODULE$;
                    if (!UInt$.MODULE$.$eq$eq$extension1(digit.d(), 0)) break;
                    next = digit.tl();
                }
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)next);
    }

    private static final int test$1(Natural $this, int n) {
        int i;
        if ((n & -n) != n) {
            return -1;
        }
        for (i = 1; i < 32 && UInt$.MODULE$.$bang$eq$extension0(UInt$.MODULE$.$greater$greater$greater$extension(n, i), 0L); ++i) {
        }
        return i - 1;
    }

    private static final int recur$10(Natural $this, Natural next, int shift, int bit) {
        block4: {
            int n;
            block3: {
                while (true) {
                    if (next instanceof Natural.End) {
                        Natural.End end = (Natural.End)next;
                        int t = Natural$class.test$1($this, end.d());
                        n = t < 0 ? -1 : (bit < 0 ? shift + t : -1);
                        break block3;
                    }
                    if (!(next instanceof Natural.Digit)) break block4;
                    Natural.Digit digit = (Natural.Digit)next;
                    int t = Natural$class.test$1($this, digit.d());
                    if (t < 0) {
                        shift += 32;
                        next = digit.tl();
                        continue;
                    }
                    if (bit >= 0) break;
                    bit = shift + t;
                    shift += 32;
                    next = digit.tl();
                }
                n = -1;
            }
            return n;
        }
        throw new MatchError((Object)next);
    }

    private static final int cmp$1(Natural $this, int a, int b, int c) {
        return UInt$.MODULE$.$less$extension(a, b) ? -1 : (UInt$.MODULE$.$greater$extension(a, b) ? 1 : c);
    }

    private static final int recur$11(Natural $this, Natural lhs, Natural rhs, int d) {
        block3: {
            while (true) {
                Natural.Digit digit;
                block9: {
                    int n;
                    block8: {
                        block4: {
                            block7: {
                                int n2;
                                block6: {
                                    Natural.End end;
                                    block5: {
                                        if (!(lhs instanceof Natural.End)) break block4;
                                        end = (Natural.End)lhs;
                                        if (!(rhs instanceof Natural.End)) break block5;
                                        Natural.End end2 = (Natural.End)rhs;
                                        n2 = Natural$class.cmp$1($this, end.d(), end2.d(), d);
                                        break block6;
                                    }
                                    if (!(rhs instanceof Natural.Digit)) break block7;
                                    n2 = -rhs.compare(end.d());
                                }
                                n = n2;
                                break block8;
                            }
                            throw new MatchError((Object)rhs);
                        }
                        if (!(lhs instanceof Natural.Digit)) break block3;
                        digit = (Natural.Digit)lhs;
                        if (!(rhs instanceof Natural.End)) break block9;
                        Natural.End end = (Natural.End)rhs;
                        n = lhs.compare(end.d());
                    }
                    return n;
                }
                if (!(rhs instanceof Natural.Digit)) break;
                Natural.Digit digit2 = (Natural.Digit)rhs;
                d = Natural$class.cmp$1($this, digit.d(), digit2.d(), d);
                rhs = digit2.tl();
                lhs = digit.tl();
            }
            throw new MatchError((Object)rhs);
        }
        throw new MatchError((Object)lhs);
    }

    private static final Natural recur$12(Natural $this, Natural left, Natural right, long carry) {
        block7: {
            block10: {
                Natural natural;
                block6: {
                    Natural.Digit digit;
                    block9: {
                        Natural.Digit digit2;
                        block8: {
                            block2: {
                                block5: {
                                    Natural natural2;
                                    block4: {
                                        Natural.End end;
                                        block3: {
                                            if (!(left instanceof Natural.End)) break block2;
                                            end = (Natural.End)left;
                                            if (!(right instanceof Natural.End)) break block3;
                                            Natural.End end2 = (Natural.End)right;
                                            natural2 = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(end.d()) + UInt$.MODULE$.toLong$extension(end2.d()) + carry);
                                            break block4;
                                        }
                                        if (!(right instanceof Natural.Digit)) break block5;
                                        Natural.Digit digit3 = (Natural.Digit)right;
                                        long t = UInt$.MODULE$.toLong$extension(end.d()) + UInt$.MODULE$.toLong$extension(digit3.d()) + carry;
                                        UInt$ uInt$ = UInt$.MODULE$;
                                        long l = t >> 32;
                                        UInt$ uInt$2 = UInt$.MODULE$;
                                        natural2 = new Natural.Digit((int)t, digit3.tl().$plus((int)l));
                                    }
                                    natural = natural2;
                                    break block6;
                                }
                                throw new MatchError((Object)right);
                            }
                            if (!(left instanceof Natural.Digit)) break block7;
                            digit2 = (Natural.Digit)left;
                            if (!(right instanceof Natural.End)) break block8;
                            Natural.End end = (Natural.End)right;
                            long t = UInt$.MODULE$.toLong$extension(digit2.d()) + UInt$.MODULE$.toLong$extension(end.d()) + carry;
                            UInt$ uInt$ = UInt$.MODULE$;
                            long l = t >> 32;
                            UInt$ uInt$3 = UInt$.MODULE$;
                            digit = new Natural.Digit((int)t, digit2.tl().$plus((int)l));
                            break block9;
                        }
                        if (!(right instanceof Natural.Digit)) break block10;
                        Natural.Digit digit4 = (Natural.Digit)right;
                        long t = UInt$.MODULE$.toLong$extension(digit2.d()) + UInt$.MODULE$.toLong$extension(digit4.d()) + carry;
                        UInt$ uInt$ = UInt$.MODULE$;
                        digit = new Natural.Digit((int)t, Natural$class.recur$12($this, digit2.tl(), digit4.tl(), t >> 32));
                    }
                    natural = digit;
                }
                return natural;
            }
            throw new MatchError((Object)right);
        }
        throw new MatchError((Object)left);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final Natural recur$13(Natural $this, Natural left, Natural right, long carry) {
        block11: {
            block14: {
                block10: {
                    block13: {
                        block12: {
                            block6: {
                                block9: {
                                    block8: {
                                        block7: {
                                            if (!(left instanceof Natural.End)) break block6;
                                            var6_4 = (Natural.End)left;
                                            if (!(right instanceof Natural.End)) break block7;
                                            var5_5 = (Natural.End)right;
                                            var17_6 = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(var6_4.d()) - UInt$.MODULE$.toLong$extension(var5_5.d()) - carry);
                                            break block8;
                                        }
                                        if (!(right instanceof Natural.Digit)) break block9;
                                        var7_7 = (Natural.Digit)right;
                                        t = UInt$.MODULE$.toLong$extension(var6_4.d()) - UInt$.MODULE$.toLong$extension(var7_7.d()) - carry;
                                        var9_9 = -(t >> 32);
                                        var8_10 = UInt$.MODULE$;
                                        tl = var7_7.tl().$minus((int)var9_9);
                                        if (!(tl instanceof Natural.End)) ** GOTO lbl-1000
                                        var11_12 = UInt$.MODULE$;
                                        if (UInt$.MODULE$.$eq$eq$extension1(tl.digit(), 0)) {
                                            var12_13 = UInt$.MODULE$;
                                            v0 /* !! */  = new Natural.End((int)t);
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            var13_14 = UInt$.MODULE$;
                                            v0 /* !! */  = new Natural.Digit((int)t, tl);
                                        }
                                        var17_6 = v0 /* !! */ ;
                                    }
                                    var37_15 = var17_6;
                                    break block10;
                                }
                                throw new MatchError((Object)right);
                            }
                            if (!(left instanceof Natural.Digit)) break block11;
                            var28_16 = (Natural.Digit)left;
                            if (!(right instanceof Natural.End)) break block12;
                            var18_17 = (Natural.End)right;
                            t = UInt$.MODULE$.toLong$extension(var28_16.d()) - UInt$.MODULE$.toLong$extension(var18_17.d()) - carry;
                            var20_19 = -(t >> 32);
                            var19_20 = UInt$.MODULE$;
                            tl = var28_16.tl().$minus((int)var20_19);
                            if (!(tl instanceof Natural.End)) ** GOTO lbl-1000
                            var22_22 = UInt$.MODULE$;
                            if (UInt$.MODULE$.$eq$eq$extension1(tl.digit(), 0)) {
                                var23_23 = UInt$.MODULE$;
                                v1 /* !! */  = new Natural.End((int)t);
                            } else lbl-1000:
                            // 2 sources

                            {
                                var24_24 = UInt$.MODULE$;
                                v1 /* !! */  = new Natural.Digit((int)t, tl);
                            }
                            var36_25 = v1 /* !! */ ;
                            break block13;
                        }
                        if (!(right instanceof Natural.Digit)) break block14;
                        var29_26 = (Natural.Digit)right;
                        t = UInt$.MODULE$.toLong$extension(var28_16.d()) - UInt$.MODULE$.toLong$extension(var29_26.d()) - carry;
                        tl = Natural$class.recur$13($this, var28_16.tl(), var29_26.tl(), -(t >> 32));
                        if (!(tl instanceof Natural.End)) ** GOTO lbl-1000
                        var30_29 = UInt$.MODULE$;
                        if (UInt$.MODULE$.$eq$eq$extension1(tl.digit(), 0)) {
                            var31_30 = UInt$.MODULE$;
                            v2 /* !! */  = new Natural.End((int)t);
                        } else lbl-1000:
                        // 2 sources

                        {
                            var32_31 = UInt$.MODULE$;
                            v2 /* !! */  = new Natural.Digit((int)t, tl);
                        }
                        var36_25 = v2 /* !! */ ;
                    }
                    var37_15 = var36_25;
                }
                return var37_15;
            }
            throw new MatchError((Object)right);
        }
        throw new MatchError((Object)left);
    }

    private static final Natural _pow$1(Natural $this, Natural t, Natural b, Natural e) {
        while (!e.isZero()) {
            if (e.isOdd()) {
                Natural natural = t.$times(b);
                e = e.$greater$greater(1);
                b = b.$times(b);
                t = natural;
                continue;
            }
            e = e.$greater$greater(1);
            b = b.$times(b);
        }
        return t;
    }

    private static final Natural _pow$2(Natural $this, Natural t, Natural b, int e) {
        while (true) {
            UInt$ uInt$ = UInt$.MODULE$;
            if (UInt$.MODULE$.$eq$eq$extension1(e, 0)) {
                return t;
            }
            UInt$ uInt$2 = UInt$.MODULE$;
            UInt$ uInt$3 = UInt$.MODULE$;
            if (UInt$.MODULE$.$eq$eq$extension1(UInt$.MODULE$.$amp$extension(e, 1), 1)) {
                Natural natural = t.$times(b);
                e = UInt$.MODULE$.$greater$greater$extension(e, 1);
                b = b.$times(b);
                t = natural;
                continue;
            }
            e = UInt$.MODULE$.$greater$greater$extension(e, 1);
            b = b.$times(b);
        }
    }

    private static final Natural recur$14(Natural $this, Natural next, long carry, int m$1) {
        block4: {
            Natural natural;
            block3: {
                block2: {
                    if (!(next instanceof Natural.End)) break block2;
                    Natural.End end = (Natural.End)next;
                    natural = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(end.d()) << m$1 | carry);
                    break block3;
                }
                if (!(next instanceof Natural.Digit)) break block4;
                Natural.Digit digit = (Natural.Digit)next;
                long t = UInt$.MODULE$.toLong$extension(digit.d()) << m$1 | carry;
                UInt$ uInt$ = UInt$.MODULE$;
                natural = new Natural.Digit((int)t, Natural$class.recur$14($this, digit.tl(), t >> 32, m$1));
            }
            return natural;
        }
        throw new MatchError((Object)next);
    }

    private static final Natural recur$15(Natural $this, Natural next, int n) {
        while (true) {
            block5: {
                Natural natural;
                block4: {
                    block3: {
                        if (n > 0) break block3;
                        natural = next;
                        break block4;
                    }
                    if (!(next instanceof Natural.End)) break block5;
                    UInt$ uInt$ = UInt$.MODULE$;
                    natural = new Natural.End(0);
                }
                return natural;
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            --n;
            next = digit.tl();
        }
        throw new MatchError((Object)next);
    }

    private static final Natural recur$16(Natural $this, Natural next, long carry, int m$2) {
        block4: {
            Natural natural;
            block3: {
                block2: {
                    if (!(next instanceof Natural.End)) break block2;
                    Natural.End end = (Natural.End)next;
                    natural = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(end.d()) >> m$2 | carry);
                    break block3;
                }
                if (!(next instanceof Natural.Digit)) break block4;
                Natural.Digit digit = (Natural.Digit)next;
                long t = (UInt$.MODULE$.toLong$extension(digit.d()) | carry) << 32 - m$2;
                long l = t >> 32;
                UInt$ uInt$ = UInt$.MODULE$;
                natural = new Natural.Digit((int)l, Natural$class.recur$16($this, digit.tl(), t & 0xFFFFFFFFL, m$2));
            }
            return natural;
        }
        throw new MatchError((Object)next);
    }

    private static final Natural and$1(Natural $this, Natural lhs, Natural rhs) {
        block7: {
            block10: {
                Natural.End end;
                block6: {
                    Natural natural;
                    block9: {
                        Natural.Digit digit;
                        block8: {
                            block2: {
                                block5: {
                                    Natural.End end2;
                                    block4: {
                                        Natural.End end3;
                                        block3: {
                                            if (!(lhs instanceof Natural.End)) break block2;
                                            end3 = (Natural.End)lhs;
                                            if (!(rhs instanceof Natural.End)) break block3;
                                            Natural.End end4 = (Natural.End)rhs;
                                            end2 = new Natural.End(UInt$.MODULE$.$amp$extension(end3.d(), end4.d()));
                                            break block4;
                                        }
                                        if (!(rhs instanceof Natural.Digit)) break block5;
                                        Natural.Digit digit2 = (Natural.Digit)rhs;
                                        end2 = new Natural.End(UInt$.MODULE$.$amp$extension(end3.d(), digit2.d()));
                                    }
                                    end = end2;
                                    break block6;
                                }
                                throw new MatchError((Object)rhs);
                            }
                            if (!(lhs instanceof Natural.Digit)) break block7;
                            digit = (Natural.Digit)lhs;
                            if (!(rhs instanceof Natural.End)) break block8;
                            Natural.End end5 = (Natural.End)rhs;
                            natural = new Natural.End(UInt$.MODULE$.$amp$extension(digit.d(), end5.d()));
                            break block9;
                        }
                        if (!(rhs instanceof Natural.Digit)) break block10;
                        Natural.Digit digit3 = (Natural.Digit)rhs;
                        natural = new Natural.Digit(UInt$.MODULE$.$amp$extension(digit.d(), digit3.d()), Natural$class.and$1($this, digit.tl(), digit3.tl()));
                    }
                    end = natural;
                }
                return end;
            }
            throw new MatchError((Object)rhs);
        }
        throw new MatchError((Object)lhs);
    }

    private static final Natural xor$1(Natural $this, Natural lhs, Natural rhs) {
        block7: {
            block10: {
                Natural natural;
                block6: {
                    Natural.Digit digit;
                    block9: {
                        Natural.Digit digit2;
                        block8: {
                            block2: {
                                block5: {
                                    Natural natural2;
                                    block4: {
                                        Natural.End end;
                                        block3: {
                                            if (!(lhs instanceof Natural.End)) break block2;
                                            end = (Natural.End)lhs;
                                            if (!(rhs instanceof Natural.End)) break block3;
                                            Natural.End end2 = (Natural.End)rhs;
                                            natural2 = new Natural.End(UInt$.MODULE$.$up$extension(end.d(), end2.d()));
                                            break block4;
                                        }
                                        if (!(rhs instanceof Natural.Digit)) break block5;
                                        Natural.Digit digit3 = (Natural.Digit)rhs;
                                        natural2 = new Natural.Digit(UInt$.MODULE$.$up$extension(end.d(), digit3.d()), digit3.tl());
                                    }
                                    natural = natural2;
                                    break block6;
                                }
                                throw new MatchError((Object)rhs);
                            }
                            if (!(lhs instanceof Natural.Digit)) break block7;
                            digit2 = (Natural.Digit)lhs;
                            if (!(rhs instanceof Natural.End)) break block8;
                            Natural.End end = (Natural.End)rhs;
                            digit = new Natural.Digit(UInt$.MODULE$.$up$extension(digit2.d(), end.d()), digit2.tl());
                            break block9;
                        }
                        if (!(rhs instanceof Natural.Digit)) break block10;
                        Natural.Digit digit4 = (Natural.Digit)rhs;
                        digit = new Natural.Digit(UInt$.MODULE$.$up$extension(digit2.d(), digit4.d()), digit2.tl().$up(digit4.tl()));
                    }
                    natural = digit;
                }
                return natural;
            }
            throw new MatchError((Object)rhs);
        }
        throw new MatchError((Object)lhs);
    }

    private static final boolean recur$18(Natural $this, Natural next, boolean sofar, boolean a$2, Function2 f$2) {
        while (true) {
            if (next instanceof Natural.End) {
                Natural.End end = (Natural.End)next;
                return BoxesRunTime.unboxToBoolean((Object)f$2.apply((Object)BoxesRunTime.boxToBoolean((boolean)a$2), (Object)new UInt(end.d())));
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            Natural natural = digit.tl();
            f$2.apply((Object)BoxesRunTime.boxToBoolean((boolean)a$2), (Object)new UInt(digit.d()));
            next = natural;
        }
        throw new MatchError((Object)next);
    }

    private static final byte recur$19(Natural $this, Natural next, byte sofar, byte a$3, Function2 f$3) {
        while (true) {
            if (next instanceof Natural.End) {
                Natural.End end = (Natural.End)next;
                return BoxesRunTime.unboxToByte((Object)f$3.apply((Object)BoxesRunTime.boxToByte((byte)a$3), (Object)new UInt(end.d())));
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            Natural natural = digit.tl();
            f$3.apply((Object)BoxesRunTime.boxToByte((byte)a$3), (Object)new UInt(digit.d()));
            next = natural;
        }
        throw new MatchError((Object)next);
    }

    private static final char recur$20(Natural $this, Natural next, char sofar, char a$4, Function2 f$4) {
        while (true) {
            if (next instanceof Natural.End) {
                Natural.End end = (Natural.End)next;
                return BoxesRunTime.unboxToChar((Object)f$4.apply((Object)BoxesRunTime.boxToCharacter((char)a$4), (Object)new UInt(end.d())));
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            Natural natural = digit.tl();
            f$4.apply((Object)BoxesRunTime.boxToCharacter((char)a$4), (Object)new UInt(digit.d()));
            next = natural;
        }
        throw new MatchError((Object)next);
    }

    private static final double recur$21(Natural $this, Natural next, double sofar, double a$5, Function2 f$5) {
        while (true) {
            if (next instanceof Natural.End) {
                Natural.End end = (Natural.End)next;
                return BoxesRunTime.unboxToDouble((Object)f$5.apply((Object)BoxesRunTime.boxToDouble((double)a$5), (Object)new UInt(end.d())));
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            Natural natural = digit.tl();
            f$5.apply((Object)BoxesRunTime.boxToDouble((double)a$5), (Object)new UInt(digit.d()));
            next = natural;
        }
        throw new MatchError((Object)next);
    }

    private static final float recur$22(Natural $this, Natural next, float sofar, float a$6, Function2 f$6) {
        while (true) {
            if (next instanceof Natural.End) {
                Natural.End end = (Natural.End)next;
                return BoxesRunTime.unboxToFloat((Object)f$6.apply((Object)BoxesRunTime.boxToFloat((float)a$6), (Object)new UInt(end.d())));
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            Natural natural = digit.tl();
            f$6.apply((Object)BoxesRunTime.boxToFloat((float)a$6), (Object)new UInt(digit.d()));
            next = natural;
        }
        throw new MatchError((Object)next);
    }

    private static final int recur$23(Natural $this, Natural next, int sofar, int a$7, Function2 f$7) {
        while (true) {
            if (next instanceof Natural.End) {
                Natural.End end = (Natural.End)next;
                return BoxesRunTime.unboxToInt((Object)f$7.apply((Object)BoxesRunTime.boxToInteger((int)a$7), (Object)new UInt(end.d())));
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            Natural natural = digit.tl();
            f$7.apply((Object)BoxesRunTime.boxToInteger((int)a$7), (Object)new UInt(digit.d()));
            next = natural;
        }
        throw new MatchError((Object)next);
    }

    private static final long recur$24(Natural $this, Natural next, long sofar, long a$8, Function2 f$8) {
        while (true) {
            if (next instanceof Natural.End) {
                Natural.End end = (Natural.End)next;
                return BoxesRunTime.unboxToLong((Object)f$8.apply((Object)BoxesRunTime.boxToLong((long)a$8), (Object)new UInt(end.d())));
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            Natural natural = digit.tl();
            f$8.apply((Object)BoxesRunTime.boxToLong((long)a$8), (Object)new UInt(digit.d()));
            next = natural;
        }
        throw new MatchError((Object)next);
    }

    private static final short recur$25(Natural $this, Natural next, short sofar, short a$9, Function2 f$9) {
        while (true) {
            if (next instanceof Natural.End) {
                Natural.End end = (Natural.End)next;
                return BoxesRunTime.unboxToShort((Object)f$9.apply((Object)BoxesRunTime.boxToShort((short)a$9), (Object)new UInt(end.d())));
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            Natural natural = digit.tl();
            f$9.apply((Object)BoxesRunTime.boxToShort((short)a$9), (Object)new UInt(digit.d()));
            next = natural;
        }
        throw new MatchError((Object)next);
    }

    private static final void recur$26(Natural $this, Natural next, BoxedUnit sofar, BoxedUnit a$10, Function2 f$10) {
        while (true) {
            if (next instanceof Natural.End) {
                Natural.End end = (Natural.End)next;
                f$10.apply((Object)a$10, (Object)new UInt(end.d()));
                return;
            }
            if (!(next instanceof Natural.Digit)) break;
            Natural.Digit digit = (Natural.Digit)next;
            Natural natural = digit.tl();
            f$10.apply((Object)a$10, (Object)new UInt(digit.d()));
            next = natural;
        }
        throw new MatchError((Object)next);
    }

    public static void $init$(Natural $this) {
    }
}

