/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.MapBuilder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import spire.algebra.Eq;
import spire.algebra.Field;
import spire.algebra.Order$;
import spire.algebra.Rig;
import spire.algebra.Ring;
import spire.algebra.Rng;
import spire.algebra.Semiring;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.QuickSort$;
import spire.math.poly.PolyDense;
import spire.math.poly.PolySparse;
import spire.math.poly.Term;
import spire.math.poly.Term$;

public abstract class Polynomial$class {
    public static void foreachNonZero(Polynomial $this, Function2 f, Semiring ring, Eq eq) {
        $this.foreach(new Serializable($this, f, ring, eq){
            public static final long serialVersionUID = 0L;
            private final Function2 f$1;
            private final Semiring ring$1;
            private final Eq eq$1;

            public final Object apply(int e, C c) {
                return this.eq$1.neqv(c, this.ring$1.zero()) ? this.f$1.apply((Object)BoxesRunTime.boxToInteger((int)e), c) : BoxedUnit.UNIT;
            }
            {
                void var4_4;
                void var3_3;
                this.f$1 = f$1;
                this.ring$1 = var3_3;
                this.eq$1 = var4_4;
            }
        });
    }

    public static List terms(Polynomial $this, Semiring ring, Eq eq) {
        ListBuffer lb = new ListBuffer();
        $this.foreachNonZero(new Serializable($this, lb){
            public static final long serialVersionUID = 0L;
            private final ListBuffer lb$1;

            public final ListBuffer<Term<C>> apply(int e, C c) {
                return this.lb$1.$plus$eq(new Term<C>(c, e));
            }
            {
                this.lb$1 = lb$1;
            }
        }, ring, eq);
        return lb.result();
    }

    public static Map data(Polynomial $this, Semiring ring, Eq eq) {
        MapBuilder bldr = new MapBuilder((GenMap)Predef$.MODULE$.Map().empty());
        $this.foreachNonZero(new Serializable($this, bldr){
            public static final long serialVersionUID = 0L;
            private final MapBuilder bldr$1;

            public final MapBuilder<Object, C, Map<Object, C>> apply(int e, C c) {
                return this.bldr$1.$plus$eq(new Tuple2((Object)BoxesRunTime.boxToInteger((int)e), c));
            }
            {
                this.bldr$1 = bldr$1;
            }
        }, ring, eq);
        return (Map)bldr.result();
    }

    public static Term maxTerm(Polynomial $this, Semiring ring) {
        return new Term($this.maxOrderTermCoeff(ring), $this.degree());
    }

    public static Polynomial compose(Polynomial $this, Polynomial y, Rig ring, Eq eq) {
        ObjectRef polynomial = new ObjectRef(Polynomial$.MODULE$.zero(eq, ring, $this.ct()));
        $this.foreachNonZero(new Serializable($this, polynomial, y, ring, eq){
            public static final long serialVersionUID = 0L;
            private final ObjectRef polynomial$1;
            private final Polynomial y$1;
            private final Rig ring$2;
            private final Eq eq$2;

            public final void apply(int e, C c) {
                Polynomial<C> z = this.y$1.pow(e, this.ring$2, this.eq$2).$colon$times(c, this.ring$2, this.eq$2);
                this.polynomial$1.elem = ((Polynomial)this.polynomial$1.elem).$plus(z, this.ring$2, this.eq$2);
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                this.polynomial$1 = polynomial$1;
                this.y$1 = var3_3;
                this.ring$2 = var4_4;
                this.eq$2 = var5_5;
            }
        }, ring, eq);
        return (Polynomial)polynomial.elem;
    }

    public static Polynomial monic(Polynomial $this, Field f, Eq eq) {
        return $this.$colon$div($this.maxOrderTermCoeff(f), f, eq);
    }

    public static Polynomial $minus(Polynomial $this, Polynomial rhs, Rng ring, Eq eq) {
        return $this.$plus(rhs.unary_$minus(ring), ring, eq);
    }

    public static Polynomial $div$tilde(Polynomial $this, Polynomial rhs, Field field, Eq eq) {
        return (Polynomial)$this.$div$percent(rhs, field, eq)._1();
    }

    public static Polynomial $percent(Polynomial $this, Polynomial rhs, Field field, Eq eq) {
        return (Polynomial)$this.$div$percent(rhs, field, eq)._2();
    }

    public static Polynomial pow(Polynomial $this, int k, Rig ring, Eq eq) {
        if (k < 0) {
            throw new IllegalArgumentException("negative exponent");
        }
        return k == 0 ? Polynomial$.MODULE$.one(eq, ring, $this.ct()) : (k == 1 ? $this : Polynomial$class.loop$2($this, $this, k - 1, $this, ring, eq));
    }

    public static Polynomial $colon$times(Polynomial $this, Object k, Semiring ring, Eq eq) {
        return $this.$times$colon(k, ring, eq);
    }

    public static Polynomial $colon$div(Polynomial $this, Object k, Field field, Eq eq) {
        return $this.$colon$times(field.reciprocal(k), field, eq);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equals(Polynomial $this, Object that) {
        boolean bl = false;
        if (that instanceof Polynomial) {
            bl = true;
            Polynomial polynomial = (Polynomial)that;
            if ($this.degree() == polynomial.degree()) {
                Tuple2<int[], Object> tuple22 = Polynomial$.MODULE$.spire$math$Polynomial$$split($this, $this.ct());
                if (tuple22 == null) throw new MatchError(tuple22);
                Tuple2 tuple23 = new Tuple2(tuple22._1(), tuple22._2());
                int[] les = (int[])tuple23._1();
                Object lcs = tuple23._2();
                Tuple2<int[], Object> tuple24 = Polynomial$.MODULE$.spire$math$Polynomial$$split(polynomial, ClassTag$.MODULE$.Any());
                if (tuple24 == null) throw new MatchError(tuple24);
                Tuple2 tuple25 = new Tuple2(tuple24._1(), tuple24._2());
                int[] res = (int[])tuple25._1();
                Object[] rcs = (Object[])tuple25._2();
                return Polynomial$class.loop$3($this, 0, 0, les, lcs, res, rcs);
            }
        }
        if (bl) {
            return false;
        }
        if ($this.isZero()) {
            Integer n = BoxesRunTime.boxToInteger((int)0);
            if (that == n) return true;
            if (that == null) return false;
            boolean bl2 = !(that instanceof Number) ? (!(that instanceof Character) ? that.equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)that), (Object)n)) : BoxesRunTime.equalsNumObject((Number)((Number)that), (Object)n);
            if (!bl2) return false;
            return true;
        }
        if ($this.degree() != 0) return false;
        Tuple2<int[], Object> tuple26 = Polynomial$.MODULE$.spire$math$Polynomial$$split($this, $this.ct());
        if (tuple26 == null) throw new MatchError(tuple26);
        Object object = tuple26._2();
        Object object2 = ScalaRunTime$.MODULE$.array_apply(object, 0);
        if (object2 == that) return true;
        if (object2 == null) return false;
        boolean bl3 = !(object2 instanceof Number) ? (!(object2 instanceof Character) ? object2.equals(that) : BoxesRunTime.equalsCharObject((Character)((Character)object2), (Object)that)) : BoxesRunTime.equalsNumObject((Number)((Number)object2), (Object)that);
        if (!bl3) return false;
        return true;
    }

    public static String toString(Polynomial $this) {
        String string;
        if ($this.isZero()) {
            string = "(0)";
        } else {
            Object object;
            ArrayBuilder bldr = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Term.class));
            $this.foreach(new Serializable($this, bldr){
                public static final long serialVersionUID = 0L;
                private final ArrayBuilder bldr$2;

                public final ArrayBuilder<Term<C>> apply(int e, C c) {
                    return (ArrayBuilder)this.bldr$2.$plus$eq(new Term<C>(c, e));
                }
                {
                    this.bldr$2 = bldr$2;
                }
            });
            Term[] ts = (Term[])bldr.result();
            Object object2 = Term$.MODULE$.ordering();
            Order$ order$ = Order$.MODULE$;
            ClassTag classTag = ClassTag$.MODULE$.apply(Term.class);
            Predef$ predef$ = Predef$.MODULE$;
            QuickSort$.MODULE$.sort(ts, object2.reverse(), classTag);
            String s = Predef$.MODULE$.refArrayOps((Object[])ts).mkString();
            StringBuilder stringBuilder = new StringBuilder().append((Object)"(");
            Predef$ predef$2 = Predef$.MODULE$;
            Object object3 = new StringOps(s).take(3);
            if (!(object3 != null ? !object3.equals(" - ") : " - " != null)) {
                Predef$ predef$3 = Predef$.MODULE$;
                object = new StringBuilder().append((Object)"-").append(new StringOps(s).drop(3)).toString();
            } else {
                Predef$ predef$4 = Predef$.MODULE$;
                object = new StringOps(s).drop(3);
            }
            string = stringBuilder.append(object).append((Object)")").toString();
        }
        return string;
    }

    public static PolyDense toDense$mcD$sp(Polynomial $this, Semiring ring, Eq eq) {
        return $this.toDense(ring, eq);
    }

    public static PolySparse toSparse$mcD$sp(Polynomial $this, Semiring ring, Eq eq) {
        return $this.toSparse(ring, eq);
    }

    public static void foreach$mcD$sp(Polynomial $this, Function2 f) {
        $this.foreach(f);
    }

    public static void foreachNonZero$mcD$sp(Polynomial $this, Function2 f, Semiring ring, Eq eq) {
        $this.foreachNonZero(f, ring, eq);
    }

    public static double[] coeffsArray$mcD$sp(Polynomial $this, Semiring ring) {
        return (double[])$this.coeffsArray(ring);
    }

    public static List terms$mcD$sp(Polynomial $this, Semiring ring, Eq eq) {
        return $this.terms(ring, eq);
    }

    public static Map data$mcD$sp(Polynomial $this, Semiring ring, Eq eq) {
        return $this.data(ring, eq);
    }

    public static double nth$mcD$sp(Polynomial $this, int n, Semiring ring) {
        return BoxesRunTime.unboxToDouble($this.nth(n, ring));
    }

    public static Term maxTerm$mcD$sp(Polynomial $this, Semiring ring) {
        return $this.maxTerm(ring);
    }

    public static double maxOrderTermCoeff$mcD$sp(Polynomial $this, Semiring ring) {
        return BoxesRunTime.unboxToDouble($this.maxOrderTermCoeff(ring));
    }

    public static double apply$mcD$sp(Polynomial $this, double x, Semiring r) {
        return BoxesRunTime.unboxToDouble((Object)$this.apply(BoxesRunTime.boxToDouble((double)x), r));
    }

    public static Polynomial compose$mcD$sp(Polynomial $this, Polynomial y, Rig ring, Eq eq) {
        return $this.compose(y, ring, eq);
    }

    public static Polynomial monic$mcD$sp(Polynomial $this, Field f, Eq eq) {
        return $this.monic(f, eq);
    }

    public static Polynomial derivative$mcD$sp(Polynomial $this, Ring ring, Eq eq) {
        return $this.derivative(ring, eq);
    }

    public static Polynomial integral$mcD$sp(Polynomial $this, Field field, Eq eq) {
        return $this.integral(field, eq);
    }

    public static Polynomial unary_$minus$mcD$sp(Polynomial $this, Rng ring) {
        return $this.unary_$minus(ring);
    }

    public static Polynomial $plus$mcD$sp(Polynomial $this, Polynomial rhs, Semiring ring, Eq eq) {
        return $this.$plus(rhs, ring, eq);
    }

    public static Polynomial $minus$mcD$sp(Polynomial $this, Polynomial rhs, Rng ring, Eq eq) {
        return $this.$minus(rhs, ring, eq);
    }

    public static Polynomial $times$mcD$sp(Polynomial $this, Polynomial rhs, Semiring ring, Eq eq) {
        return $this.$times(rhs, ring, eq);
    }

    public static Polynomial $div$tilde$mcD$sp(Polynomial $this, Polynomial rhs, Field field, Eq eq) {
        return $this.$div$tilde(rhs, field, eq);
    }

    public static Tuple2 $div$percent$mcD$sp(Polynomial $this, Polynomial rhs, Field field, Eq eq) {
        return $this.$div$percent(rhs, field, eq);
    }

    public static Polynomial $percent$mcD$sp(Polynomial $this, Polynomial rhs, Field field, Eq eq) {
        return $this.$percent(rhs, field, eq);
    }

    public static Polynomial pow$mcD$sp(Polynomial $this, int k, Rig ring, Eq eq) {
        return $this.pow(k, ring, eq);
    }

    public static Polynomial $times$colon$mcD$sp(Polynomial $this, double k, Semiring ring, Eq eq) {
        return $this.$times$colon(BoxesRunTime.boxToDouble((double)k), ring, eq);
    }

    public static Polynomial $colon$times$mcD$sp(Polynomial $this, double k, Semiring ring, Eq eq) {
        return $this.$colon$times(BoxesRunTime.boxToDouble((double)k), ring, eq);
    }

    public static Polynomial $colon$div$mcD$sp(Polynomial $this, double k, Field field, Eq eq) {
        return $this.$colon$div(BoxesRunTime.boxToDouble((double)k), field, eq);
    }

    private static final Polynomial loop$2(Polynomial $this, Polynomial b, int k, Polynomial extra, Rig ring$3, Eq eq$3) {
        while (k != 1) {
            extra = (k & 1) == 1 ? b.$times(extra, ring$3, eq$3) : extra;
            k >>>= 1;
            b = b.$times(b, ring$3, eq$3);
        }
        return b.$times(extra, ring$3, eq$3);
    }

    private static final boolean loop$3(Polynomial $this, int i, int j, int[] les$1, Object lcs$1, int[] res$1, Object[] rcs$1) {
        boolean bl;
        block6: {
            while (true) {
                if (i >= les$1.length && j >= res$1.length) {
                    bl = true;
                    break block6;
                }
                if (j >= res$1.length || les$1[i] < res$1[j]) {
                    Integer n = BoxesRunTime.boxToInteger((int)0);
                    Object object = ScalaRunTime$.MODULE$.array_apply(lcs$1, i);
                    boolean bl2 = object != n ? (object != null ? (!(object instanceof Number) ? (!(object instanceof Character) ? object.equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)object), (Object)n)) : BoxesRunTime.equalsNumObject((Number)((Number)object), (Object)n)) : false) : true;
                    if (bl2) {
                        ++i;
                        continue;
                    }
                    bl = false;
                    break block6;
                }
                if (i >= les$1.length || les$1[i] > res$1[j]) {
                    Object object = rcs$1[j];
                    Integer n = BoxesRunTime.boxToInteger((int)0);
                    boolean bl3 = object != n ? (object != null ? (!(object instanceof Number) ? (!(object instanceof Character) ? object.equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)object), (Object)n)) : BoxesRunTime.equalsNumObject((Number)((Number)object), (Object)n)) : false) : true;
                    if (bl3) {
                        ++j;
                        continue;
                    }
                    bl = false;
                    break block6;
                }
                Object object = rcs$1[j];
                Object object2 = ScalaRunTime$.MODULE$.array_apply(lcs$1, i);
                boolean bl4 = object2 != object ? (object2 != null ? (!(object2 instanceof Number) ? (!(object2 instanceof Character) ? object2.equals(object) : BoxesRunTime.equalsCharObject((Character)((Character)object2), (Object)object)) : BoxesRunTime.equalsNumObject((Number)((Number)object2), (Object)object)) : false) : true;
                if (!bl4) break;
                ++j;
                ++i;
            }
            bl = false;
        }
        return bl;
    }

    public static void $init$(Polynomial $this) {
    }
}

