/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.MapBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import spire.algebra.Eq;
import spire.algebra.Field;
import spire.algebra.Rig;
import spire.algebra.Rng;
import spire.algebra.Semiring;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.Polynomial$mcD$sp;
import spire.math.poly.Term;
import spire.math.poly.Term$mcD$sp;

public abstract class Polynomial$mcD$sp$class {
    public static void foreachNonZero(Polynomial$mcD$sp $this, Function2 f, Semiring ring, Eq eq) {
        $this.foreachNonZero$mcD$sp(f, ring, eq);
    }

    public static void foreachNonZero$mcD$sp(Polynomial$mcD$sp $this, Function2 f, Semiring ring, Eq eq) {
        $this.foreach(new Serializable($this, f, ring, eq){
            private final Function2 f$2;
            private final Semiring ring$4;
            private final Eq eq$4;

            public final Object apply(int e, double c) {
                return this.eq$4.neqv$mcD$sp(c, this.ring$4.zero$mcD$sp()) ? this.f$2.apply((Object)BoxesRunTime.boxToInteger((int)e), (Object)BoxesRunTime.boxToDouble((double)c)) : BoxedUnit.UNIT;
            }
            {
                this.f$2 = f$2;
                this.ring$4 = ring$4;
                this.eq$4 = eq$4;
            }
        });
    }

    public static List terms(Polynomial$mcD$sp $this, Semiring ring, Eq eq) {
        return $this.terms$mcD$sp(ring, eq);
    }

    public static List terms$mcD$sp(Polynomial$mcD$sp $this, Semiring ring, Eq eq) {
        ListBuffer lb = new ListBuffer();
        $this.foreachNonZero$mcD$sp(new Serializable($this, lb){
            private final ListBuffer lb$2;

            public final ListBuffer<Term<Object>> apply(int e, double c) {
                return this.lb$2.$plus$eq((Object)new Term$mcD$sp(c, e));
            }
            {
                this.lb$2 = lb$2;
            }
        }, ring, eq);
        return lb.result();
    }

    public static Map data(Polynomial$mcD$sp $this, Semiring ring, Eq eq) {
        return $this.data$mcD$sp(ring, eq);
    }

    public static Map data$mcD$sp(Polynomial$mcD$sp $this, Semiring ring, Eq eq) {
        MapBuilder bldr = new MapBuilder((GenMap)Predef$.MODULE$.Map().empty());
        $this.foreachNonZero$mcD$sp(new Serializable($this, bldr){
            private final MapBuilder bldr$3;

            public final MapBuilder<Object, Object, Map<Object, Object>> apply(int e, double c) {
                return this.bldr$3.$plus$eq((Tuple2)new Tuple2.mcID.sp(e, c));
            }
            {
                this.bldr$3 = bldr$3;
            }
        }, ring, eq);
        return (Map)bldr.result();
    }

    public static Term maxTerm(Polynomial$mcD$sp $this, Semiring ring) {
        return $this.maxTerm$mcD$sp(ring);
    }

    public static Term maxTerm$mcD$sp(Polynomial$mcD$sp $this, Semiring ring) {
        return new Term$mcD$sp($this.maxOrderTermCoeff(ring), $this.degree());
    }

    public static Polynomial compose(Polynomial$mcD$sp $this, Polynomial y, Rig ring, Eq eq) {
        return $this.compose$mcD$sp(y, ring, eq);
    }

    public static Polynomial compose$mcD$sp(Polynomial$mcD$sp $this, Polynomial y, Rig ring, Eq eq) {
        ObjectRef polynomial = new ObjectRef(Polynomial$.MODULE$.zero$mDc$sp(eq, ring, $this.ct()));
        $this.foreachNonZero$mcD$sp(new Serializable($this, polynomial, y, ring, eq){
            private final ObjectRef polynomial$2;
            private final Polynomial y$2;
            private final Rig ring$5;
            private final Eq eq$5;

            public final void apply(int e, double c) {
                Polynomial<Object> z = this.y$2.pow$mcD$sp(e, this.ring$5, this.eq$5).$colon$times$mcD$sp(c, this.ring$5, this.eq$5);
                this.polynomial$2.elem = ((Polynomial)this.polynomial$2.elem).$plus$mcD$sp(z, this.ring$5, this.eq$5);
            }
            {
                this.polynomial$2 = polynomial$2;
                this.y$2 = y$2;
                this.ring$5 = ring$5;
                this.eq$5 = eq$5;
            }
        }, ring, eq);
        return (Polynomial)polynomial.elem;
    }

    public static Polynomial monic(Polynomial$mcD$sp $this, Field f, Eq eq) {
        return $this.monic$mcD$sp(f, eq);
    }

    public static Polynomial monic$mcD$sp(Polynomial$mcD$sp $this, Field f, Eq eq) {
        return $this.$colon$div$mcD$sp($this.maxOrderTermCoeff(f), f, eq);
    }

    public static Polynomial $minus(Polynomial$mcD$sp $this, Polynomial rhs, Rng ring, Eq eq) {
        return $this.$minus$mcD$sp(rhs, ring, eq);
    }

    public static Polynomial $minus$mcD$sp(Polynomial$mcD$sp $this, Polynomial rhs, Rng ring, Eq eq) {
        return $this.$plus(rhs.unary_$minus$mcD$sp(ring), ring, eq);
    }

    public static Polynomial $div$tilde(Polynomial$mcD$sp $this, Polynomial rhs, Field field, Eq eq) {
        return $this.$div$tilde$mcD$sp(rhs, field, eq);
    }

    public static Polynomial $div$tilde$mcD$sp(Polynomial$mcD$sp $this, Polynomial rhs, Field field, Eq eq) {
        return (Polynomial)$this.$div$percent(rhs, field, eq)._1();
    }

    public static Polynomial $percent(Polynomial$mcD$sp $this, Polynomial rhs, Field field, Eq eq) {
        return $this.$percent$mcD$sp(rhs, field, eq);
    }

    public static Polynomial $percent$mcD$sp(Polynomial$mcD$sp $this, Polynomial rhs, Field field, Eq eq) {
        return (Polynomial)$this.$div$percent(rhs, field, eq)._2();
    }

    public static Polynomial pow(Polynomial$mcD$sp $this, int k, Rig ring, Eq eq) {
        return $this.pow$mcD$sp(k, ring, eq);
    }

    public static Polynomial pow$mcD$sp(Polynomial$mcD$sp $this, int k, Rig ring, Eq eq) {
        if (k < 0) {
            throw new IllegalArgumentException("negative exponent");
        }
        return k == 0 ? Polynomial$.MODULE$.one$mDc$sp(eq, ring, $this.ct()) : (k == 1 ? $this : Polynomial$mcD$sp$class.loop$4($this, $this, k - 1, $this, ring, eq));
    }

    public static Polynomial $colon$times(Polynomial$mcD$sp $this, double k, Semiring ring, Eq eq) {
        return $this.$colon$times$mcD$sp(k, ring, eq);
    }

    public static Polynomial $colon$times$mcD$sp(Polynomial$mcD$sp $this, double k, Semiring ring, Eq eq) {
        return $this.$times$colon(k, ring, eq);
    }

    public static Polynomial $colon$div(Polynomial$mcD$sp $this, double k, Field field, Eq eq) {
        return $this.$colon$div$mcD$sp(k, field, eq);
    }

    public static Polynomial $colon$div$mcD$sp(Polynomial$mcD$sp $this, double k, Field field, Eq eq) {
        return $this.$colon$times$mcD$sp(field.reciprocal$mcD$sp(k), field, eq);
    }

    private static final Polynomial loop$4(Polynomial$mcD$sp $this, Polynomial b, int k, Polynomial extra, Rig ring$6, Eq eq$6) {
        while (k != 1) {
            extra = (k & 1) == 1 ? b.$times$mcD$sp(extra, ring$6, eq$6) : extra;
            k >>>= 1;
            b = b.$times$mcD$sp(b, ring$6, eq$6);
        }
        return b.$times$mcD$sp(extra, ring$6, eq$6);
    }

    public static void $init$(Polynomial$mcD$sp $this) {
    }
}

