/*
 * Decompiled with CFR 0.152.
 */
package spire.math.algebraic;

import java.math.MathContext;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.ScalaNumericAnyConversions;
import scala.package$;
import scala.runtime.BoxesRunTime;
import spire.algebra.Sign;
import spire.algebra.Sign$;
import spire.algebra.Sign$Negative$;
import spire.algebra.Sign$Positive$;
import spire.algebra.Sign$Zero$;
import spire.math.Approximation;
import spire.math.ApproximationContext;
import spire.math.Fractional;
import spire.math.Fractional$;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.algebraic.Add$;
import spire.math.algebraic.BigDecimalApprox;
import spire.math.algebraic.BigDecimalApproximations$;
import spire.math.algebraic.BigIntLit$;
import spire.math.algebraic.Div$;
import spire.math.algebraic.Expr$;
import spire.math.algebraic.IntLit$;
import spire.math.algebraic.KRoot$;
import spire.math.algebraic.Mul$;
import spire.math.algebraic.Neg$;
import spire.math.algebraic.RealLike;
import spire.math.algebraic.Sub$;

public abstract class BigDecimalApprox$class {
    public static Sign sign(BigDecimalApprox $this) {
        Sign sign2;
        Option<Object> option2 = IntLit$.MODULE$.unapply($this, $this.coexpr());
        if (option2.isEmpty()) {
            Option<BigInt> option3 = BigIntLit$.MODULE$.unapply($this, $this.coexpr());
            if (option3.isEmpty()) {
                Option<BigDecimalApprox> option4 = Neg$.MODULE$.unapply($this, $this.coexpr());
                if (option4.isEmpty()) {
                    Option<Tuple2<BigDecimalApprox, BigDecimalApprox>> option5 = Mul$.MODULE$.unapply($this, $this.coexpr());
                    if (option5.isEmpty()) {
                        Option<Tuple2<BigDecimalApprox, BigDecimalApprox>> option6 = Div$.MODULE$.unapply($this, $this.coexpr());
                        if (option6.isEmpty()) {
                            BigDecimal sep = package$.MODULE$.BigDecimal().apply(1L, -$this.decimalLowerBound());
                            sign2 = Sign$.MODULE$.apply(BigDecimalApprox$class.findSign$1($this, 0, sep));
                        } else {
                            sign2 = ((BigDecimalApprox)((Tuple2)option6.get())._1()).sign().$times(((BigDecimalApprox)((Tuple2)option6.get())._2()).sign());
                        }
                    } else {
                        sign2 = ((BigDecimalApprox)((Tuple2)option5.get())._1()).sign().$times(((BigDecimalApprox)((Tuple2)option5.get())._2()).sign());
                    }
                } else {
                    sign2 = ((BigDecimalApprox)option4.get()).sign().unary_$minus();
                }
            } else {
                sign2 = Sign$.MODULE$.apply(((BigInt)option3.get()).signum());
            }
        } else {
            sign2 = Sign$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)option2.get()));
        }
        return sign2;
    }

    public static BigDecimalApprox $div$tilde(BigDecimalApprox $this, BigDecimalApprox that) {
        return (BigDecimalApprox)BigIntLit$.MODULE$.apply($this.$div(that).toBigInt(), $this.coexpr());
    }

    public static BigDecimalApprox $percent(BigDecimalApprox $this, BigDecimalApprox that) {
        return $this.$minus($this.$div$tilde(that).$times(that));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BigInt toBigInt(BigDecimalApprox $this) {
        BigInt bigInt;
        Sign sign2 = $this.sign();
        Sign$Zero$ sign$Zero$ = Sign$Zero$.MODULE$;
        if (sign$Zero$ == null) {
            if (sign2 == null) return package$.MODULE$.BigInt().apply(0);
        } else if (sign$Zero$.equals(sign2)) {
            return package$.MODULE$.BigInt().apply(0);
        }
        Sign$Negative$ sign$Negative$ = Sign$Negative$.MODULE$;
        if (sign$Negative$ == null) {
            if (sign2 == null) return ((BigDecimalApprox)$this.unary_$minus()).toBigInt().unary_$minus();
        } else if (sign$Negative$.equals(sign2)) {
            return ((BigDecimalApprox)$this.unary_$minus()).toBigInt().unary_$minus();
        }
        Sign$Positive$ sign$Positive$ = Sign$Positive$.MODULE$;
        if (sign$Positive$ == null) {
            if (sign2 != null) {
                throw new MatchError((Object)sign2);
            }
        } else if (!sign$Positive$.equals(sign2)) throw new MatchError((Object)sign2);
        BigDecimal a = $this.$plus$div$minus(BigDecimal$.MODULE$.double2bigDecimal(0.01));
        BigInt b = a.toBigInt();
        if (a.$plus(BigDecimal$.MODULE$.double2bigDecimal(0.02)).$greater$eq(package$.MODULE$.BigDecimal().apply(b.$plus(BigInt$.MODULE$.int2bigInt(1))))) {
            BigInt bigInt2;
            Sign sign3 = ((BigDecimalApprox)$this.$minus((RealLike)Expr$.MODULE$.apply(b.$plus(BigInt$.MODULE$.int2bigInt(1)), $this.coexpr()))).sign();
            Sign$Positive$ sign$Positive$2 = Sign$Positive$.MODULE$;
            if (!(sign$Positive$2 != null ? !sign$Positive$2.equals(sign3) : sign3 != null)) {
                bigInt2 = b.$plus(BigInt$.MODULE$.int2bigInt(1));
            } else {
                Sign$Negative$ sign$Negative$2 = Sign$Negative$.MODULE$;
                if (!(sign$Negative$2 != null ? !sign$Negative$2.equals(sign3) : sign3 != null)) {
                    bigInt2 = b;
                } else {
                    Sign$Zero$ sign$Zero$2 = Sign$Zero$.MODULE$;
                    if (sign$Zero$2 == null) {
                        if (sign3 != null) {
                            throw new MatchError((Object)sign3);
                        }
                    } else if (!sign$Zero$2.equals(sign3)) throw new MatchError((Object)sign3);
                    bigInt2 = b.$plus(BigInt$.MODULE$.int2bigInt(1));
                }
            }
            bigInt = bigInt2;
            return bigInt;
        }
        if (a.$minus(BigDecimal$.MODULE$.double2bigDecimal(0.02)).$less(package$.MODULE$.BigDecimal().apply(b))) {
            BigInt bigInt3;
            Sign sign4 = ((BigDecimalApprox)$this.$minus((RealLike)Expr$.MODULE$.apply(b, $this.coexpr()))).sign();
            Sign$Positive$ sign$Positive$3 = Sign$Positive$.MODULE$;
            if (!(sign$Positive$3 != null ? !sign$Positive$3.equals(sign4) : sign4 != null)) {
                bigInt3 = b;
            } else {
                Sign$Negative$ sign$Negative$3 = Sign$Negative$.MODULE$;
                if (!(sign$Negative$3 != null ? !sign$Negative$3.equals(sign4) : sign4 != null)) {
                    bigInt3 = b.$minus(BigInt$.MODULE$.int2bigInt(1));
                } else {
                    Sign$Zero$ sign$Zero$3 = Sign$Zero$.MODULE$;
                    if (sign$Zero$3 == null) {
                        if (sign4 != null) {
                            throw new MatchError((Object)sign4);
                        }
                    } else if (!sign$Zero$3.equals(sign4)) throw new MatchError((Object)sign4);
                    bigInt3 = b;
                }
            }
            bigInt = bigInt3;
            return bigInt;
        }
        bigInt = b;
        return bigInt;
    }

    public static Object approximateTo(BigDecimalApprox $this, Object b, Approximation approx) {
        return approx.apply($this, b);
    }

    public static BigDecimal $plus$div$minus(BigDecimalApprox $this, BigDecimal err) {
        return (BigDecimal)$this.approximateTo(err, BigDecimalApproximations$.MODULE$.Absolute($this.coexpr()));
    }

    public static BigDecimal toBigDecimal(BigDecimalApprox $this, MathContext mc) {
        return ((BigDecimal)$this.approximateTo(mc, BigDecimalApproximations$.MODULE$.Relative($this.coexpr()))).round(mc);
    }

    public static MathContext toBigDecimal$default$1(BigDecimalApprox $this) {
        return MathContext.DECIMAL128;
    }

    public static Object simulate(BigDecimalApprox $this, Fractional f) {
        Object object;
        Option<Object> option2 = IntLit$.MODULE$.unapply($this, $this.coexpr());
        if (option2.isEmpty()) {
            Option<BigInt> option3 = BigIntLit$.MODULE$.unapply($this, $this.coexpr());
            if (option3.isEmpty()) {
                Option<Tuple2<BigDecimalApprox, BigDecimalApprox>> option4 = Add$.MODULE$.unapply($this, $this.coexpr());
                if (option4.isEmpty()) {
                    Option<Tuple2<BigDecimalApprox, BigDecimalApprox>> option5 = Sub$.MODULE$.unapply($this, $this.coexpr());
                    if (option5.isEmpty()) {
                        Option<Tuple2<BigDecimalApprox, BigDecimalApprox>> option6 = Mul$.MODULE$.unapply($this, $this.coexpr());
                        if (option6.isEmpty()) {
                            Option<Tuple2<BigDecimalApprox, BigDecimalApprox>> option7 = Div$.MODULE$.unapply($this, $this.coexpr());
                            if (option7.isEmpty()) {
                                Option<Tuple2<BigDecimalApprox, Object>> option8 = KRoot$.MODULE$.unapply($this, $this.coexpr());
                                if (option8.isEmpty()) {
                                    Option<BigDecimalApprox> option9 = Neg$.MODULE$.unapply($this, $this.coexpr());
                                    if (option9.isEmpty()) {
                                        throw new MatchError((Object)$this);
                                    }
                                    object = f.negate(((BigDecimalApprox)option9.get()).simulate(f));
                                } else {
                                    object = f.nroot(((BigDecimalApprox)((Tuple2)option8.get())._1()).simulate(f), ((Tuple2)option8.get())._2$mcI$sp());
                                }
                            } else {
                                object = f.div(((BigDecimalApprox)((Tuple2)option7.get())._1()).simulate(f), ((BigDecimalApprox)((Tuple2)option7.get())._2()).simulate(f));
                            }
                        } else {
                            object = f.times(((BigDecimalApprox)((Tuple2)option6.get())._1()).simulate(f), ((BigDecimalApprox)((Tuple2)option6.get())._2()).simulate(f));
                        }
                    } else {
                        object = f.minus(((BigDecimalApprox)((Tuple2)option5.get())._1()).simulate(f), ((BigDecimalApprox)((Tuple2)option5.get())._2()).simulate(f));
                    }
                } else {
                    object = f.plus(((BigDecimalApprox)((Tuple2)option4.get())._1()).simulate(f), ((BigDecimalApprox)((Tuple2)option4.get())._2()).simulate(f));
                }
            } else {
                object = f.fromBigInt((BigInt)option3.get());
            }
        } else {
            object = f.fromInt(BoxesRunTime.unboxToInt((Object)option2.get()));
        }
        return object;
    }

    public static Rational toRational(BigDecimalApprox $this, ApproximationContext ac) {
        return $this.simulate(Fractional$.MODULE$.RationalIsFractional(ac));
    }

    public static ApproximationContext toRational$default$1(BigDecimalApprox $this) {
        return new ApproximationContext<Rational>(Rational$.MODULE$.apply(1L, 10000000000000000L));
    }

    public static boolean isWhole(BigDecimalApprox $this) {
        Sign sign2 = $this.$percent((BigDecimalApprox)IntLit$.MODULE$.apply(1, $this.coexpr())).sign();
        Sign$Zero$ sign$Zero$ = Sign$Zero$.MODULE$;
        return !(sign2 != null ? !sign2.equals(sign$Zero$) : sign$Zero$ != null);
    }

    public static Object underlying(BigDecimalApprox $this) {
        return $this;
    }

    public static double doubleValue(BigDecimalApprox $this) {
        return ((ScalaNumericAnyConversions)$this.approximateTo(new MathContext(17), BigDecimalApproximations$.MODULE$.Relative($this.coexpr()))).toDouble();
    }

    public static float floatValue(BigDecimalApprox $this) {
        return (float)$this.doubleValue();
    }

    public static int intValue(BigDecimalApprox $this) {
        return $this.toBigInt().toInt();
    }

    public static long longValue(BigDecimalApprox $this) {
        return $this.toBigInt().toLong();
    }

    public static String toString(BigDecimalApprox $this) {
        BigDecimal approx = $this.toBigDecimal(new MathContext(9));
        BigDecimalApprox bigDecimalApprox = $this;
        Object a = Expr$.MODULE$.apply(approx, $this.coexpr());
        String prefix = !(bigDecimalApprox != null ? !bigDecimalApprox.equals(a) : a != null) ? "" : "~";
        return new StringBuilder().append((Object)prefix).append((Object)approx.toString()).toString();
    }

    private static final int findSign$1(BigDecimalApprox $this, int scale, BigDecimal sep$1) {
        while (true) {
            block5: {
                int n;
                block4: {
                    BigDecimal err;
                    block3: {
                        BigDecimal a;
                        if (!(a = $this.$plus$div$minus(err = package$.MODULE$.BigDecimal().apply(1L, scale))).abs().$greater(err)) break block3;
                        n = a.signum();
                        break block4;
                    }
                    if (!err.$times(BigDecimal$.MODULE$.int2bigDecimal(2)).$less(sep$1)) break block5;
                    n = 0;
                }
                return n;
            }
            ++scale;
        }
    }

    public static void $init$(BigDecimalApprox $this) {
    }
}

