/*
 * Decompiled with CFR 0.152.
 */
package spire.math.prime;

import java.math.BigInteger;
import java.util.Random;
import scala.Function0;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.Map$;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import spire.algebra.Sign;
import spire.algebra.Sign$;
import spire.algebra.Sign$Positive$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.prime.Factors;
import spire.math.prime.Factors$;
import spire.math.prime.Siever;
import spire.math.prime.package$;

public final class package$ {
    public static final package$ MODULE$;
    private final Random srand;
    private final int SieveSize;

    static {
        new package$();
    }

    public boolean isPrime(SafeLong n) {
        return n.isProbablePrime(40);
    }

    public Factors factor(SafeLong n) {
        return this.factorPollardRho(n);
    }

    public Factors factorTrialDivision(SafeLong n0) {
        Integer n = BoxesRunTime.boxToInteger((int)0);
        boolean bl = n0 != n ? (n0 != null ? (!(n0 instanceof Number) ? (!(n0 instanceof Character) ? ((Object)((Object)n0)).equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)n0)), (Object)n)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)n0)), (Object)n)) : false) : true;
        if (bl) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n2 = n0.abs();
        Sign sign = Sign$.MODULE$.apply(n0.signum());
        SafeLong safeLong = SafeLong$.MODULE$.one();
        boolean bl2 = n2 != safeLong ? (n2 != null ? (!(n2 instanceof Number) ? (!(n2 instanceof Character) ? ((Object)((Object)n2)).equals((Object)safeLong) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)n2)), (Object)((Object)safeLong))) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)n2)), (Object)((Object)safeLong))) : false) : true;
        if (bl2) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), sign);
        }
        scala.collection.mutable.Map facts = Map$.MODULE$.empty();
        SafeLong x = n2;
        Tuple2<SafeLong, Object> tuple22 = this.findPowers(n2, SafeLong$.MODULE$.apply(2L));
        if (tuple22 != null) {
            Tuple2 tuple23 = new Tuple2(tuple22._1(), (Object)BoxesRunTime.boxToInteger((int)tuple22._2$mcI$sp()));
            SafeLong x1 = (SafeLong)((Object)tuple23._1());
            int e1 = tuple23._2$mcI$sp();
            if (e1 > 0) {
                facts.update((Object)SafeLong$.MODULE$.apply(2L), (Object)BoxesRunTime.boxToInteger((int)e1));
                x = x1;
            }
            SafeLong limit = (SafeLong)((Object)SafeLong$.MODULE$.SafeLongAlgebra().sqrt((Object)x));
            SafeLong index$macro$540 = SafeLong$.MODULE$.apply(3L);
            while (index$macro$540.$less$eq((Object)limit) && x.$greater((Object)SafeLong$.MODULE$.apply(1L))) {
                Tuple2<SafeLong, Object> tuple24 = this.findPowers(x, index$macro$540);
                if (tuple24 != null) {
                    Tuple2 tuple25 = new Tuple2(tuple24._1(), (Object)BoxesRunTime.boxToInteger((int)tuple24._2$mcI$sp()));
                    SafeLong x2 = (SafeLong)((Object)tuple25._1());
                    int e2 = tuple25._2$mcI$sp();
                    if (e2 > 0) {
                        facts.update((Object)index$macro$540, (Object)BoxesRunTime.boxToInteger((int)e2));
                        x = x2;
                        limit = (SafeLong)((Object)SafeLong$.MODULE$.SafeLongAlgebra().sqrt((Object)x2));
                    }
                    index$macro$540 = index$macro$540.$plus(2L);
                    continue;
                }
                throw new MatchError(tuple24);
            }
            if (x.$greater((Object)SafeLong$.MODULE$.apply(1L))) {
                facts.update((Object)x, (Object)BoxesRunTime.boxToInteger((int)1));
            }
            return new Factors((Map<SafeLong, Object>)facts.toMap(Predef$.MODULE$.$conforms()), sign);
        }
        throw new MatchError(tuple22);
    }

    public Factors factorWheelDivision(SafeLong n0) {
        Integer n = BoxesRunTime.boxToInteger((int)0);
        boolean bl = n0 != n ? (n0 != null ? (!(n0 instanceof Number) ? (!(n0 instanceof Character) ? ((Object)((Object)n0)).equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)n0)), (Object)n)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)n0)), (Object)n)) : false) : true;
        if (bl) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n2 = n0.abs();
        Sign sign = Sign$.MODULE$.apply(n0.signum());
        Integer n3 = BoxesRunTime.boxToInteger((int)1);
        boolean bl2 = n2 != n3 ? (n2 != null ? (!(n2 instanceof Number) ? (!(n2 instanceof Character) ? ((Object)((Object)n2)).equals(n3) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)n2)), (Object)n3)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)n2)), (Object)n3)) : false) : true;
        if (bl2) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), sign);
        }
        scala.collection.mutable.Map facts = Map$.MODULE$.empty();
        SafeLong x = n2;
        Tuple2<SafeLong, Object> tuple22 = this.findPowers(n2, SafeLong$.MODULE$.apply(2L));
        if (tuple22 != null) {
            Tuple2 tuple23 = new Tuple2(tuple22._1(), (Object)BoxesRunTime.boxToInteger((int)tuple22._2$mcI$sp()));
            SafeLong x1 = (SafeLong)((Object)tuple23._1());
            int e1 = tuple23._2$mcI$sp();
            if (e1 > 0) {
                facts.update((Object)SafeLong$.MODULE$.apply(2L), (Object)BoxesRunTime.boxToInteger((int)e1));
                x = x1;
            }
            SafeLong index$macro$541 = SafeLong$.MODULE$.apply(3L);
            while (index$macro$541.$less((Object)SafeLong$.MODULE$.apply(30L)) && x.$greater((Object)SafeLong$.MODULE$.apply(1L))) {
                Tuple2<SafeLong, Object> tuple24 = this.findPowers(x, index$macro$541);
                if (tuple24 != null) {
                    Tuple2 tuple25 = new Tuple2(tuple24._1(), (Object)BoxesRunTime.boxToInteger((int)tuple24._2$mcI$sp()));
                    SafeLong x2 = (SafeLong)((Object)tuple25._1());
                    int e2 = tuple25._2$mcI$sp();
                    if (e2 > 0) {
                        facts.update((Object)index$macro$541, (Object)BoxesRunTime.boxToInteger((int)e2));
                        x = x2;
                    }
                    index$macro$541 = index$macro$541.$plus(2L);
                    continue;
                }
                throw new MatchError(tuple24);
            }
            SafeLong limit = (SafeLong)((Object)SafeLong$.MODULE$.SafeLongAlgebra().sqrt((Object)x));
            SafeLong b = SafeLong$.MODULE$.apply(31L);
            int i = 0;
            int[] offsets = new int[]{2, 2, 2, 4, 2, 4, 2, 4, 6, 2};
            while (b.$less$eq((Object)limit) && x.$greater((Object)SafeLong$.MODULE$.apply(1L))) {
                Tuple2<SafeLong, Object> tuple26 = this.findPowers(x, b);
                if (tuple26 != null) {
                    Tuple2 tuple27 = new Tuple2(tuple26._1(), (Object)BoxesRunTime.boxToInteger((int)tuple26._2$mcI$sp()));
                    SafeLong x2 = (SafeLong)((Object)tuple27._1());
                    int e2 = tuple27._2$mcI$sp();
                    if (e2 > 0) {
                        facts.update((Object)b, (Object)BoxesRunTime.boxToInteger((int)e2));
                        x = x2;
                        limit = (SafeLong)((Object)SafeLong$.MODULE$.SafeLongAlgebra().sqrt((Object)x2));
                    }
                    b = b.$plus(offsets[i]);
                    i = (i + 1) % 10;
                    continue;
                }
                throw new MatchError(tuple26);
            }
            if (x.$greater((Object)SafeLong$.MODULE$.apply(1L))) {
                facts.update((Object)x, (Object)BoxesRunTime.boxToInteger((int)1));
            }
            return new Factors((Map<SafeLong, Object>)facts.toMap(Predef$.MODULE$.$conforms()), sign);
        }
        throw new MatchError(tuple22);
    }

    public Factors factorPollardRho(SafeLong n0) {
        Integer n;
        Integer n2 = BoxesRunTime.boxToInteger((int)0);
        boolean bl = n0 != n2 ? (n0 != null ? (!(n0 instanceof Number) ? (!(n0 instanceof Character) ? ((Object)((Object)n0)).equals(n2) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)n0)), (Object)n2)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)n0)), (Object)n2)) : false) : true;
        if (bl) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n3 = n0.abs();
        boolean bl2 = n3 != (n = BoxesRunTime.boxToInteger((int)1)) ? (n3 != null ? (!(n3 instanceof Number) ? (!(n3 instanceof Character) ? ((Object)((Object)n3)).equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)n3)), (Object)n)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)n3)), (Object)n)) : false) : true;
        if (bl2) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), Sign$.MODULE$.apply(n0.signum()));
        }
        return n0.$less((Object)SafeLong$.MODULE$.apply(0L)) ? this.factor$1(n3).unary_$minus() : this.factor$1(n3);
    }

    private Random srand() {
        return this.srand;
    }

    private SafeLong rand(SafeLong n) {
        int bits = n.bitLength();
        BigInteger x = new BigInteger(bits, this.srand());
        while (x.signum() == 0) {
            x = new BigInteger(bits, this.srand());
        }
        return SafeLong$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(x));
    }

    private Tuple2<SafeLong, Object> findPowers(SafeLong x0, SafeLong b) {
        SafeLong x = x0;
        int e = 0;
        while (x.$greater((Object)SafeLong$.MODULE$.apply(1L))) {
            Integer n = BoxesRunTime.boxToInteger((int)0);
            SafeLong safeLong = x.$percent(b);
            boolean bl = safeLong != n ? (safeLong != null ? (!(safeLong instanceof Number) ? (!(safeLong instanceof Character) ? ((Object)((Object)safeLong)).equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)safeLong)), (Object)n)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)safeLong)), (Object)n)) : false) : true;
            if (!bl) break;
            ++e;
            x = x.$div(b);
        }
        return new Tuple2((Object)x, (Object)BoxesRunTime.boxToInteger((int)e));
    }

    private int SieveSize() {
        return this.SieveSize;
    }

    public Siever sieverUpToNth(long n) {
        double upper = (double)n * spire.math.package$.MODULE$.log(n) + (double)n * spire.math.package$.MODULE$.log(spire.math.package$.MODULE$.log((double)n - 0.9385));
        long cutoff = spire.math.package$.MODULE$.max(1000L, (long)(spire.math.package$.MODULE$.sqrt(upper) + (double)512L));
        return new Siever(this.SieveSize(), SafeLong$.MODULE$.apply(cutoff));
    }

    public SafeLong nth(long n) {
        return this.sieverUpToNth(n).nth(n);
    }

    /*
     * WARNING - void declaration
     */
    public SafeLong[] fill(int n) {
        SafeLong[] safeLongArray;
        if (n <= 0) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
        }
        if (n == 1) {
            safeLongArray = (SafeLong[])((Object[])new SafeLong[]{SafeLong$.MODULE$.two()});
        } else {
            void var3_3;
            Siever siever = this.sieverUpToNth(n);
            SafeLong[] arr = new SafeLong[n];
            arr[0] = SafeLong$.MODULE$.two();
            arr[1] = SafeLong$.MODULE$.three();
            this.loop$1(2, SafeLong$.MODULE$.three(), siever, arr);
            safeLongArray = var3_3;
        }
        return safeLongArray;
    }

    public SafeLong[] fill(int start, int limit) {
        SafeLong[] safeLongArray;
        if (start == 0) {
            safeLongArray = this.fill(limit);
        } else {
            Siever siever = this.sieverUpToNth(start + limit);
            safeLongArray = this.loop$2(1, SafeLong$.MODULE$.three(), start, limit, siever);
        }
        return safeLongArray;
    }

    public Stream<SafeLong> stream() {
        return this.stream(this.SieveSize(), SafeLong$.MODULE$.apply(1000000L));
    }

    public Stream<SafeLong> stream(int chunkSize, SafeLong cutoff) {
        SafeLong safeLong = SafeLong$.MODULE$.two();
        return Stream$.MODULE$.consWrapper((Function0)new Serializable(chunkSize, cutoff){
            public static final long serialVersionUID = 0L;
            public final int chunkSize$1;
            public final SafeLong cutoff$1;

            public final Stream<SafeLong> apply() {
                SafeLong safeLong = SafeLong$.MODULE$.three();
                return Stream$.MODULE$.consWrapper((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.stream.1 $outer;

                    public final Stream<SafeLong> apply() {
                        return new Siever(this.$outer.chunkSize$1, this.$outer.cutoff$1).streamAfter(SafeLong$.MODULE$.three());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).$hash$colon$colon((Object)((Object)safeLong));
            }
            {
                this.chunkSize$1 = chunkSize$1;
                this.cutoff$1 = cutoff$1;
            }
        }).$hash$colon$colon((Object)safeLong);
    }

    private final SafeLong f$1(SafeLong x, SafeLong n$1, SafeLong c$1) {
        return x.$times(x).$percent(n$1).$plus(c$1).$percent(n$1);
    }

    private final SafeLong fastRho$1(SafeLong x, SafeLong q0, SafeLong r, SafeLong m, SafeLong n$1, SafeLong c$1) {
        SafeLong ys;
        SafeLong g;
        while (true) {
            Integer n;
            SafeLong y = x;
            SafeLong q = q0;
            int index$macro$542 = 0;
            while (r.$greater((Object)SafeLong$.MODULE$.apply(index$macro$542))) {
                y = y.$times(y).$percent(n$1).$plus(c$1).$percent(n$1);
                ++index$macro$542;
            }
            g = SafeLong$.MODULE$.one();
            SafeLong k = SafeLong$.MODULE$.zero();
            ys = y;
            while (r.$greater((Object)k)) {
                Integer n2 = BoxesRunTime.boxToInteger((int)1);
                boolean bl = g != n2 ? (g != null ? (!(g instanceof Number) ? (!(g instanceof Character) ? ((Object)((Object)g)).equals(n2) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)g)), (Object)n2)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)g)), (Object)n2)) : false) : true;
                if (!bl) break;
                ys = y;
                SafeLong limit = m.min(r.$minus(k));
                int index$macro$543 = 0;
                while (limit.$greater((Object)SafeLong$.MODULE$.apply(index$macro$543))) {
                    y = y.$times(y).$percent(n$1).$plus(c$1).$percent(n$1);
                    q = q.$times(x.$minus(y).abs()).$percent(n$1);
                    ++index$macro$543;
                }
                Integer n3 = BoxesRunTime.boxToInteger((int)0);
                g = (q != n3 ? (q != null ? (!(q instanceof Number) ? (!(q instanceof Character) ? ((Object)((Object)q)).equals(n3) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)q)), (Object)n3)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)q)), (Object)n3)) : false) : true) ? n$1 : n$1.gcd(q);
                k = k.$plus(m);
            }
            boolean bl = g != (n = BoxesRunTime.boxToInteger((int)1)) ? (g != null ? (!(g instanceof Number) ? (!(g instanceof Character) ? ((Object)((Object)g)).equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)g)), (Object)n)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)g)), (Object)n)) : false) : true;
            if (!bl) break;
            r = r.$times(2L);
            q0 = q;
            x = y;
        }
        return (g != n$1 ? (g != null ? (!(g instanceof Number) ? (!(g instanceof Character) ? ((Object)((Object)g)).equals((Object)n$1) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)g)), (Object)((Object)n$1))) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)g)), (Object)((Object)n$1))) : false) : true) ? this.slowRho$1(x, ys, n$1, c$1) : g;
    }

    private final SafeLong slowRho$1(SafeLong x, SafeLong ys, SafeLong n$1, SafeLong c$1) {
        SafeLong g;
        while (true) {
            Integer n;
            SafeLong yys;
            boolean bl = (g = n$1.gcd(x.$minus(yys = ys.$times(ys).$percent(n$1).$plus(c$1).$percent(n$1)).abs())) != (n = BoxesRunTime.boxToInteger((int)1)) ? (g != null ? (!(g instanceof Number) ? (!(g instanceof Character) ? ((Object)((Object)g)).equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)g)), (Object)n)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)g)), (Object)n)) : false) : true;
            if (!bl) break;
            ys = yys;
        }
        return g;
    }

    private final SafeLong rho$1(SafeLong n, SafeLong c) {
        return this.fastRho$1(this.rand(n), SafeLong$.MODULE$.one(), SafeLong$.MODULE$.one(), this.rand(n), n, c);
    }

    private final Factors factor$1(SafeLong n) {
        Factors factors;
        Integer n2 = BoxesRunTime.boxToInteger((int)1);
        boolean bl = n != n2 ? (n != null ? (!(n instanceof Number) ? (!(n instanceof Character) ? ((Object)((Object)n)).equals(n2) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)n)), (Object)n2)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)n)), (Object)n2)) : false) : true;
        if (bl) {
            factors = Factors$.MODULE$.one();
        } else if (this.isPrime(n)) {
            Tuple2[] tuple2Array = new Tuple2[1];
            Integer n3 = BoxesRunTime.boxToInteger((int)1);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)n);
            Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
            tuple2Array[0] = new Tuple2(object, (Object)n3);
            factors = new Factors((Map<SafeLong, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), Sign$Positive$.MODULE$);
        } else {
            Integer n4 = BoxesRunTime.boxToInteger((int)0);
            SafeLong safeLong = n.$percent(2L);
            boolean bl2 = safeLong != n4 ? (safeLong != null ? (!(safeLong instanceof Number) ? (!(safeLong instanceof Character) ? ((Object)((Object)safeLong)).equals(n4) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)safeLong)), (Object)n4)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)safeLong)), (Object)n4)) : false) : true;
            if (bl2) {
                SafeLong x = n.$div(2L);
                int e = 1;
                while (true) {
                    Integer n5 = BoxesRunTime.boxToInteger((int)0);
                    SafeLong safeLong2 = x.$percent(2L);
                    boolean bl3 = safeLong2 != n5 ? (safeLong2 != null ? (!(safeLong2 instanceof Number) ? (!(safeLong2 instanceof Character) ? ((Object)((Object)safeLong2)).equals(n5) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)safeLong2)), (Object)n5)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)safeLong2)), (Object)n5)) : false) : true;
                    if (!bl3) break;
                    x = x.$div(2L);
                    ++e;
                }
                Tuple2[] tuple2Array = new Tuple2[1];
                Integer n6 = BoxesRunTime.boxToInteger((int)e);
                Object object = Predef$.MODULE$.ArrowAssoc((Object)SafeLong$.MODULE$.apply(2L));
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[0] = new Tuple2(object, (Object)n6);
                factors = new Factors((Map<SafeLong, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), Sign$Positive$.MODULE$).$times(this.factor$1(x));
            } else {
                SafeLong divisor = this.rho$1(n, this.rand(n));
                while (true) {
                    boolean bl4 = divisor != n ? (divisor != null ? (!(divisor instanceof Number) ? (!(divisor instanceof Character) ? ((Object)((Object)divisor)).equals((Object)n) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)divisor)), (Object)((Object)n))) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)divisor)), (Object)((Object)n))) : false) : true;
                    if (!bl4) break;
                    divisor = this.rho$1(n, this.rand(n));
                }
                factors = this.factor$1(divisor).$times(this.factor$1(n.$div(divisor)));
            }
        }
        return factors;
    }

    private final void loop$1(int i, SafeLong last, Siever siever$1, SafeLong[] arr$1) {
        while (i < arr$1.length) {
            SafeLong p;
            arr$1[i] = p = siever$1.nextAfter(last);
            last = p;
            ++i;
        }
    }

    private final SafeLong[] loop$2(int i, SafeLong p, int start$1, int limit$1, Siever siever$2) {
        while (i < start$1) {
            p = siever$2.nextAfter(p);
            ++i;
        }
        return siever$2.arrayAt(p, limit$1);
    }

    private package$() {
        MODULE$ = this;
        this.srand = new Random();
        this.SieveSize = 9600000;
    }
}

