/*
 * Decompiled with CFR 0.152.
 */
package spire.math.algebraic;

import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.math.BigInt;
import spire.algebra.Sign;
import spire.algebra.Sign$Negative$;
import spire.algebra.Sign$Positive$;
import spire.algebra.Sign$Zero$;
import spire.math.algebraic.Add$;
import spire.math.algebraic.BigIntLit$;
import spire.math.algebraic.Div$;
import spire.math.algebraic.IntLit$;
import spire.math.algebraic.KRoot$;
import spire.math.algebraic.Mul$;
import spire.math.algebraic.Neg$;
import spire.math.algebraic.RealLike;
import spire.math.algebraic.Sub$;

public abstract class RealLike$class {
    public static int signum(RealLike $this) {
        return $this.sign().toInt();
    }

    public static boolean isPositive(RealLike $this) {
        Sign sign = $this.sign();
        Sign$Positive$ sign$Positive$ = Sign$Positive$.MODULE$;
        return sign != null && sign.equals(sign$Positive$);
    }

    public static boolean isZero(RealLike $this) {
        Sign sign = $this.sign();
        Sign$Zero$ sign$Zero$ = Sign$Zero$.MODULE$;
        return sign != null && sign.equals(sign$Zero$);
    }

    public static boolean isNegative(RealLike $this) {
        Sign sign = $this.sign();
        Sign$Negative$ sign$Negative$ = Sign$Negative$.MODULE$;
        return sign != null && sign.equals(sign$Negative$);
    }

    public static boolean isNonNegative(RealLike $this) {
        Sign sign = $this.sign();
        Sign$Negative$ sign$Negative$ = Sign$Negative$.MODULE$;
        return sign == null || !sign.equals(sign$Negative$);
    }

    public static boolean isNonZero(RealLike $this) {
        Sign sign = $this.sign();
        Sign$Zero$ sign$Zero$ = Sign$Zero$.MODULE$;
        return sign == null || !sign.equals(sign$Zero$);
    }

    public static boolean isNonPositive(RealLike $this) {
        Sign sign = $this.sign();
        Sign$Positive$ sign$Positive$ = Sign$Positive$.MODULE$;
        return sign == null || !sign.equals(sign$Positive$);
    }

    public static int compare(RealLike $this, RealLike that) {
        return $this.$minus(that).signum();
    }

    public static RealLike abs(RealLike $this) {
        Sign sign = $this.sign();
        Sign$Negative$ sign$Negative$ = Sign$Negative$.MODULE$;
        return sign != null && sign.equals(sign$Negative$) ? $this.unary_$minus() : $this;
    }

    public static RealLike $times(RealLike $this, RealLike that) {
        return Mul$.MODULE$.apply($this, that, $this.coexpr());
    }

    public static RealLike $plus(RealLike $this, RealLike that) {
        return Add$.MODULE$.apply($this, that, $this.coexpr());
    }

    public static RealLike $minus(RealLike $this, RealLike that) {
        return Sub$.MODULE$.apply($this, that, $this.coexpr());
    }

    public static RealLike $div(RealLike $this, RealLike that) {
        return Div$.MODULE$.apply($this, that, $this.coexpr());
    }

    public static RealLike unary_$minus(RealLike $this) {
        return Neg$.MODULE$.apply($this, $this.coexpr());
    }

    public static RealLike sqrt(RealLike $this) {
        return $this.nroot(2);
    }

    public static RealLike nroot(RealLike $this, int k) {
        Sign sign = $this.sign();
        Sign$Negative$ sign$Negative$ = Sign$Negative$.MODULE$;
        if (sign != null && sign.equals(sign$Negative$) && k % 2 == 0) {
            throw new ArithmeticException("Cannot find an even root of a negative number.");
        }
        return KRoot$.MODULE$.apply($this, k, $this.coexpr());
    }

    public static RealLike pow(RealLike $this, int k) {
        RealLike realLike;
        if (k < 0) {
            realLike = ((RealLike)IntLit$.MODULE$.apply(1, $this.coexpr())).$div($this.pow(-k));
        } else if (k == 0) {
            realLike = (RealLike)IntLit$.MODULE$.apply(1, $this.coexpr());
        } else if (k == 1) {
            realLike = $this;
        } else {
            Object x = $this.pow(k / 2);
            RealLike x2 = x.$times(x);
            realLike = k % 2 == 0 ? x2 : x2.$times((RealLike)$this);
        }
        return realLike;
    }

    public static boolean isRadical(RealLike $this) {
        boolean bl;
        Option<Tuple2<RealLike, RealLike>> option2 = Add$.MODULE$.unapply($this, $this.coexpr());
        if (option2.isEmpty()) {
            Option<Tuple2<RealLike, RealLike>> option3 = Sub$.MODULE$.unapply($this, $this.coexpr());
            if (option3.isEmpty()) {
                Option<Tuple2<RealLike, RealLike>> option4 = Mul$.MODULE$.unapply($this, $this.coexpr());
                if (option4.isEmpty()) {
                    Option<Tuple2<RealLike, RealLike>> option5 = Div$.MODULE$.unapply($this, $this.coexpr());
                    if (option5.isEmpty()) {
                        Option<RealLike> option6 = Neg$.MODULE$.unapply($this, $this.coexpr());
                        if (option6.isEmpty()) {
                            Option<Tuple2<RealLike, Object>> option7 = KRoot$.MODULE$.unapply($this, $this.coexpr());
                            if (option7.isEmpty()) {
                                Option<Object> option8 = IntLit$.MODULE$.unapply($this, $this.coexpr());
                                if (option8.isEmpty()) {
                                    Option<BigInt> option9 = BigIntLit$.MODULE$.unapply($this, $this.coexpr());
                                    if (option9.isEmpty()) {
                                        throw new MatchError((Object)$this);
                                    }
                                    bl = false;
                                } else {
                                    bl = false;
                                }
                            } else {
                                bl = true;
                            }
                        } else {
                            bl = ((RealLike)option6.get()).isRadical();
                        }
                    } else {
                        bl = ((RealLike)((Tuple2)option5.get())._1()).isRadical() || ((RealLike)((Tuple2)option5.get())._2()).isRadical();
                    }
                } else {
                    bl = ((RealLike)((Tuple2)option4.get())._1()).isRadical() || ((RealLike)((Tuple2)option4.get())._2()).isRadical();
                }
            } else {
                bl = ((RealLike)((Tuple2)option3.get())._1()).isRadical() || ((RealLike)((Tuple2)option3.get())._2()).isRadical();
            }
        } else {
            bl = ((RealLike)((Tuple2)option2.get())._1()).isRadical() || ((RealLike)((Tuple2)option2.get())._2()).isRadical();
        }
        return bl;
    }

    public static void $init$(RealLike $this) {
    }
}

