/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import spire.algebra.Eq;
import spire.algebra.Field;
import spire.algebra.Rng;
import spire.algebra.Semiring;
import spire.algebra.Semiring$;
import spire.math.Polynomial;
import spire.math.poly.PolyDense;
import spire.math.poly.PolySparse;
import spire.math.poly.PolySparse$mcD$sp;
import spire.math.poly.Term;
import spire.math.poly.Term$mcD$sp;
import spire.std.package$int$;
import spire.syntax.std.package$array$;

public final class PolySparse$
implements Serializable {
    public static final PolySparse$ MODULE$;

    static {
        new PolySparse$();
    }

    public final <C> PolySparse<C> spire$math$poly$PolySparse$$dense2sparse(PolyDense<C> poly, Semiring<C> evidence$1, Eq<C> evidence$2, ClassTag<C> evidence$3) {
        Object cs = poly.coeffs();
        int[] es = new int[ScalaRunTime$.MODULE$.array_length(cs)];
        for (int index$macro$201 = 0; index$macro$201 < es.length; ++index$macro$201) {
            es[index$macro$201] = index$macro$201;
        }
        return this.safe(es, cs, evidence$1, evidence$2, evidence$3);
    }

    public final <C> PolySparse<C> safe(int[] exp, Object coeff, Semiring<C> evidence$4, Eq<C> evidence$5, ClassTag<C> evidence$6) {
        PolySparse polySparse;
        int len = 0;
        for (int index$macro$202 = 0; index$macro$202 < ScalaRunTime$.MODULE$.array_length(coeff); ++index$macro$202) {
            Semiring$ semiring$ = Semiring$.MODULE$;
            if (!evidence$5.neqv(ScalaRunTime$.MODULE$.array_apply(coeff, index$macro$202), evidence$4.zero())) continue;
            ++len;
        }
        if (len == ScalaRunTime$.MODULE$.array_length(coeff)) {
            polySparse = new PolySparse(exp, coeff, evidence$6);
        } else {
            int[] es = new int[len];
            Object cs = evidence$6.newArray(len);
            polySparse = this.loop$2(0, 0, exp, coeff, evidence$4, evidence$5, evidence$6, es, cs);
        }
        return polySparse;
    }

    public final <C> PolySparse<C> apply(Map<Object, C> data2, Semiring<C> evidence$7, Eq<C> evidence$8, ClassTag<C> evidence$9) {
        Tuple2[] data0 = (Tuple2[])data2.toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        package$array$.MODULE$.arrayOps(data0).qsortBy$mIc$sp(new Serializable(){

            public final int apply(Tuple2<Object, C> x$21) {
                return x$21._1$mcI$sp();
            }
        }, package$int$.MODULE$.IntAlgebra(), ClassTag$.MODULE$.apply(Tuple2.class));
        int[] es = new int[data0.length];
        Object cs = evidence$9.newArray(data0.length);
        for (int index$macro$203 = 0; index$macro$203 < data0.length; ++index$macro$203) {
            Tuple2 tuple22 = data0[index$macro$203];
            if (tuple22 != null) {
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)tuple22._1$mcI$sp()), tuple22._2());
                int e = tuple23._1$mcI$sp();
                Object c = tuple23._2();
                es[index$macro$203] = e;
                ScalaRunTime$.MODULE$.array_update(cs, index$macro$203, c);
                continue;
            }
            throw new MatchError((Object)tuple22);
        }
        return this.safe(es, cs, evidence$7, evidence$8, evidence$9);
    }

    public final <C> PolySparse<C> apply(Polynomial<C> poly, Semiring<C> evidence$10, Eq<C> evidence$11, ClassTag<C> evidence$12) {
        PolySparse<C> polySparse;
        if (poly instanceof PolySparse) {
            PolySparse<C> polySparse2;
            polySparse = polySparse2 = (PolySparse<C>)poly;
        } else if (poly instanceof PolyDense) {
            polySparse = this.spire$math$poly$PolySparse$$dense2sparse((PolyDense)poly, evidence$10, evidence$11, evidence$12);
        } else {
            IntRef len = IntRef.create((int)0);
            poly.foreachNonZero(new Serializable(len){
                private final IntRef len$1;

                public final void apply(int x$25, C x$26) {
                    ++this.len$1.elem;
                }
                {
                    this.len$1 = len$1;
                }
            }, evidence$10, evidence$11);
            int[] es = new int[len.elem];
            Object cs = evidence$12.newArray(len.elem);
            IntRef i = IntRef.create((int)0);
            poly.foreachNonZero(new Serializable(es, cs, i){
                private final int[] es$3;
                private final Object cs$3;
                private final IntRef i$1;

                public final void apply(int e, C c) {
                    this.es$3[this.i$1.elem] = e;
                    ScalaRunTime$.MODULE$.array_update(this.cs$3, this.i$1.elem, c);
                    ++this.i$1.elem;
                }
                {
                    this.es$3 = es$3;
                    this.cs$3 = cs$3;
                    this.i$1 = i$1;
                }
            }, evidence$10, evidence$11);
            polySparse = this.safe(es, cs, evidence$10, evidence$11, evidence$12);
        }
        return polySparse;
    }

    public final <C> PolySparse<C> zero(Semiring<C> evidence$13, Eq<C> evidence$14, ClassTag<C> evidence$15) {
        return new PolySparse<C>(new int[0], evidence$15.newArray(0), evidence$15);
    }

    public final <C> PolySparse<C> spire$math$poly$PolySparse$$multiplyTerm(PolySparse<C> poly, C c, int e, Semiring<C> evidence$16, Eq<C> evidence$17, ClassTag<C> evidence$18) {
        int[] exp = poly.exp();
        Object coeff = poly.coeff();
        Object cs = evidence$18.newArray(ScalaRunTime$.MODULE$.array_length(coeff));
        int[] es = new int[exp.length];
        for (int index$macro$204 = 0; index$macro$204 < ScalaRunTime$.MODULE$.array_length(coeff); ++index$macro$204) {
            ScalaRunTime$.MODULE$.array_update(cs, index$macro$204, evidence$16.times(c, ScalaRunTime$.MODULE$.array_apply(coeff, index$macro$204)));
            es[index$macro$204] = exp[index$macro$204] + e;
        }
        return new PolySparse<C>(es, cs, evidence$18);
    }

    public final <C> PolySparse<C> spire$math$poly$PolySparse$$multiplySparse(PolySparse<C> lhs, PolySparse<C> rhs, Semiring<C> evidence$19, Eq<C> evidence$20, ClassTag<C> evidence$21) {
        int[] lexp = lhs.exp();
        Object lcoeff = lhs.coeff();
        PolySparse<Object> sum2 = new PolySparse<C>(new int[0], evidence$21.newArray(0), evidence$21);
        for (int index$macro$205 = 0; index$macro$205 < lexp.length; ++index$macro$205) {
            sum2 = this.spire$math$poly$PolySparse$$addSparse(sum2, this.spire$math$poly$PolySparse$$multiplyTerm(rhs, ScalaRunTime$.MODULE$.array_apply(lcoeff, index$macro$205), lexp[index$macro$205], evidence$19, evidence$20, evidence$21), evidence$20, evidence$19, evidence$21);
        }
        return sum2;
    }

    private final <C> int countSumTerms(PolySparse<C> lhs, PolySparse<C> rhs, int lOffset, int rOffset) {
        if (lhs != null) {
            Tuple2 tuple22 = new Tuple2((Object)lhs.exp(), lhs.coeff());
            int[] lexp = (int[])tuple22._1();
            tuple22._2();
            if (rhs != null) {
                Tuple2 tuple23 = new Tuple2((Object)rhs.exp(), rhs.coeff());
                int[] rexp = (int[])tuple23._1();
                tuple23._2();
                return this.loop$3(0, 0, 0, lOffset, rOffset, lexp, rexp);
            }
            throw new MatchError(rhs);
        }
        throw new MatchError(lhs);
    }

    private final <C> int countSumTerms$default$3() {
        return 0;
    }

    private final <C> int countSumTerms$default$4() {
        return 0;
    }

    public final <C> PolySparse<C> spire$math$poly$PolySparse$$addSparse(PolySparse<C> lhs, PolySparse<C> rhs, Eq<C> evidence$22, Semiring<C> evidence$23, ClassTag<C> evidence$24) {
        if (lhs != null) {
            Tuple2 tuple22 = new Tuple2((Object)lhs.exp(), lhs.coeff());
            int[] lexp = (int[])tuple22._1();
            Object lcoeff = tuple22._2();
            if (rhs != null) {
                Tuple2 tuple23 = new Tuple2((Object)rhs.exp(), rhs.coeff());
                int[] rexp = (int[])tuple23._1();
                Object rcoeff = tuple23._2();
                int len = this.countSumTerms(lhs, rhs, this.countSumTerms$default$3(), this.countSumTerms$default$4());
                int[] es = new int[len];
                Object cs = evidence$24.newArray(len);
                return this.sum$1(0, 0, 0, evidence$22, evidence$23, evidence$24, lexp, lcoeff, rexp, rcoeff, es, cs);
            }
            throw new MatchError(rhs);
        }
        throw new MatchError(lhs);
    }

    public final <C> PolySparse<C> spire$math$poly$PolySparse$$subtractScaled(PolySparse<C> lhs, C c, int e, PolySparse<C> rhs, Eq<C> evidence$25, Rng<C> evidence$26, ClassTag<C> evidence$27) {
        if (lhs != null) {
            Tuple2 tuple22 = new Tuple2((Object)lhs.exp(), lhs.coeff());
            int[] lexp = (int[])tuple22._1();
            Object lcoeff = tuple22._2();
            if (rhs != null) {
                Tuple2 tuple23 = new Tuple2((Object)rhs.exp(), rhs.coeff());
                int[] rexp = (int[])tuple23._1();
                Object rcoeff = tuple23._2();
                int len = this.countSumTerms(lhs, rhs, 0, e);
                int[] es = new int[len];
                Object cs = evidence$27.newArray(len);
                return this.loop$4(0, 0, 0, c, e, evidence$25, evidence$26, evidence$27, lexp, lcoeff, rexp, rcoeff, es, cs);
            }
            throw new MatchError(rhs);
        }
        throw new MatchError(lhs);
    }

    public final <C> Tuple2<PolySparse<C>, PolySparse<C>> spire$math$poly$PolySparse$$quotmodSparse(PolySparse<C> lhs, PolySparse<C> rhs, Field<C> evidence$28, Eq<C> evidence$29, ClassTag<C> evidence$30) {
        int rdegree = rhs.degree();
        C rmaxCoeff = rhs.maxOrderTermCoeff(evidence$28);
        return this.loop$5((List)Nil$.MODULE$, lhs, rhs, evidence$28, evidence$29, evidence$30, rdegree, rmaxCoeff);
    }

    public <C> PolySparse<C> apply(int[] exp, Object coeff, ClassTag<C> ct) {
        return new PolySparse<C>(exp, coeff, ct);
    }

    public <C> Option<Tuple2<int[], Object>> unapply(PolySparse<C> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.exp(), x$0.coeff()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final PolySparse<Object> dense2sparse$mDc$sp(PolyDense<Object> poly, Semiring<Object> evidence$1, Eq<Object> evidence$2, ClassTag<Object> evidence$3) {
        double[] cs = poly.coeffs$mcD$sp();
        int[] es = new int[cs.length];
        for (int index$macro$201 = 0; index$macro$201 < es.length; ++index$macro$201) {
            es[index$macro$201] = index$macro$201;
        }
        return this.safe$mDc$sp(es, cs, evidence$1, evidence$2, evidence$3);
    }

    public final PolySparse<Object> safe$mDc$sp(int[] exp, double[] coeff, Semiring<Object> evidence$4, Eq<Object> evidence$5, ClassTag<Object> evidence$6) {
        PolySparse polySparse;
        int len = 0;
        for (int index$macro$202 = 0; index$macro$202 < coeff.length; ++index$macro$202) {
            Semiring$ semiring$ = Semiring$.MODULE$;
            if (!evidence$5.neqv$mcD$sp(coeff[index$macro$202], evidence$4.zero$mcD$sp())) continue;
            ++len;
        }
        if (len == coeff.length) {
            polySparse = new PolySparse$mcD$sp(exp, coeff, evidence$6);
        } else {
            int[] es = new int[len];
            double[] cs = (double[])evidence$6.newArray(len);
            polySparse = this.loop$6(0, 0, exp, coeff, evidence$4, evidence$5, evidence$6, es, cs);
        }
        return polySparse;
    }

    public final PolySparse<Object> apply$mDc$sp(Map<Object, Object> data2, Semiring<Object> evidence$7, Eq<Object> evidence$8, ClassTag<Object> evidence$9) {
        Tuple2[] data0 = (Tuple2[])data2.toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        package$array$.MODULE$.arrayOps(data0).qsortBy$mIc$sp(new Serializable(){

            public final int apply(Tuple2<Object, Object> x$21) {
                return x$21._1$mcI$sp();
            }
        }, package$int$.MODULE$.IntAlgebra(), ClassTag$.MODULE$.apply(Tuple2.class));
        int[] es = new int[data0.length];
        double[] cs = (double[])evidence$9.newArray(data0.length);
        for (int index$macro$203 = 0; index$macro$203 < data0.length; ++index$macro$203) {
            Tuple2 tuple22 = data0[index$macro$203];
            if (tuple22 != null) {
                Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(tuple22._1$mcI$sp(), tuple22._2$mcD$sp());
                int e = sp2._1$mcI$sp();
                double c = sp2._2$mcD$sp();
                es[index$macro$203] = e;
                cs[index$macro$203] = c;
                continue;
            }
            throw new MatchError((Object)tuple22);
        }
        return this.safe$mDc$sp(es, cs, evidence$7, evidence$8, evidence$9);
    }

    public final PolySparse<Object> apply$mDc$sp(Polynomial<Object> poly, Semiring<Object> evidence$10, Eq<Object> evidence$11, ClassTag<Object> evidence$12) {
        PolySparse<Object> polySparse;
        if (poly instanceof PolySparse) {
            PolySparse<Object> polySparse2;
            polySparse = polySparse2 = (PolySparse<Object>)poly;
        } else if (poly instanceof PolyDense) {
            polySparse = this.spire$math$poly$PolySparse$$dense2sparse((PolyDense)poly, evidence$10, evidence$11, evidence$12);
        } else {
            IntRef len = IntRef.create((int)0);
            poly.foreachNonZero$mcD$sp(new Serializable(len){
                public final IntRef len$2;

                public final void apply(int x$25, double x$26) {
                    ++this.len$2.elem;
                }

                public void apply$mcVID$sp(int x$25, double x$26) {
                    ++this.len$2.elem;
                }
                {
                    this.len$2 = len$2;
                }
            }, evidence$10, evidence$11);
            int[] es = new int[len.elem];
            double[] cs = (double[])evidence$12.newArray(len.elem);
            IntRef i = IntRef.create((int)0);
            poly.foreachNonZero$mcD$sp(new Serializable(es, cs, i){
                private final int[] es$7;
                private final double[] cs$7;
                private final IntRef i$2;

                public final void apply(int e, double c) {
                    this.apply$mcVID$sp(e, c);
                }

                public void apply$mcVID$sp(int e, double c) {
                    this.es$7[this.i$2.elem] = e;
                    this.cs$7[this.i$2.elem] = c;
                    ++this.i$2.elem;
                }
                {
                    this.es$7 = es$7;
                    this.cs$7 = cs$7;
                    this.i$2 = i$2;
                }
            }, evidence$10, evidence$11);
            polySparse = this.safe$mDc$sp(es, cs, evidence$10, evidence$11, evidence$12);
        }
        return polySparse;
    }

    public final PolySparse<Object> zero$mDc$sp(Semiring<Object> evidence$13, Eq<Object> evidence$14, ClassTag<Object> evidence$15) {
        return new PolySparse$mcD$sp(new int[0], (double[])evidence$15.newArray(0), evidence$15);
    }

    private final PolySparse<Object> multiplyTerm$mDc$sp(PolySparse<Object> poly, double c, int e, Semiring<Object> evidence$16, Eq<Object> evidence$17, ClassTag<Object> evidence$18) {
        int[] exp = poly.exp();
        double[] coeff = poly.coeff$mcD$sp();
        double[] cs = (double[])evidence$18.newArray(coeff.length);
        int[] es = new int[exp.length];
        for (int index$macro$204 = 0; index$macro$204 < coeff.length; ++index$macro$204) {
            cs[index$macro$204] = evidence$16.times$mcD$sp(c, coeff[index$macro$204]);
            es[index$macro$204] = exp[index$macro$204] + e;
        }
        return new PolySparse$mcD$sp(es, cs, evidence$18);
    }

    private final PolySparse<Object> multiplySparse$mDc$sp(PolySparse<Object> lhs, PolySparse<Object> rhs, Semiring<Object> evidence$19, Eq<Object> evidence$20, ClassTag<Object> evidence$21) {
        int[] lexp = lhs.exp();
        double[] lcoeff = lhs.coeff$mcD$sp();
        PolySparse sum2 = new PolySparse$mcD$sp(new int[0], (double[])evidence$21.newArray(0), evidence$21);
        for (int index$macro$205 = 0; index$macro$205 < lexp.length; ++index$macro$205) {
            sum2 = this.spire$math$poly$PolySparse$$addSparse(sum2, this.spire$math$poly$PolySparse$$multiplyTerm(rhs, BoxesRunTime.boxToDouble((double)lcoeff[index$macro$205]), lexp[index$macro$205], evidence$19, evidence$20, evidence$21), evidence$20, evidence$19, evidence$21);
        }
        return sum2;
    }

    private final int countSumTerms$mDc$sp(PolySparse<Object> lhs, PolySparse<Object> rhs, int lOffset, int rOffset) {
        if (lhs != null) {
            Tuple2 tuple22 = new Tuple2((Object)lhs.exp(), (Object)lhs.coeff$mcD$sp());
            int[] lexp = (int[])tuple22._1();
            double[] cfr_ignored_0 = (double[])tuple22._2();
            if (rhs != null) {
                Tuple2 tuple23 = new Tuple2((Object)rhs.exp(), (Object)rhs.coeff$mcD$sp());
                int[] rexp = (int[])tuple23._1();
                double[] cfr_ignored_1 = (double[])tuple23._2();
                return this.loop$7(0, 0, 0, lOffset, rOffset, lexp, rexp);
            }
            throw new MatchError(rhs);
        }
        throw new MatchError(lhs);
    }

    private final Tuple2<PolySparse<Object>, PolySparse<Object>> quotmodSparse$mDc$sp(PolySparse<Object> lhs, PolySparse<Object> rhs, Field<Object> evidence$28, Eq<Object> evidence$29, ClassTag<Object> evidence$30) {
        int rdegree = rhs.degree();
        double rmaxCoeff = rhs.maxOrderTermCoeff$mcD$sp(evidence$28);
        return this.loop$8((List)Nil$.MODULE$, lhs, rhs, evidence$28, evidence$29, evidence$30, rdegree, rmaxCoeff);
    }

    public PolySparse<Object> apply$mDc$sp(int[] exp, double[] coeff, ClassTag<Object> ct) {
        return new PolySparse$mcD$sp(exp, coeff, ct);
    }

    public Option<Tuple2<int[], double[]>> unapply$mDc$sp(PolySparse<Object> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.exp(), (Object)x$0.coeff$mcD$sp()));
    }

    private final PolySparse loop$2(int i, int j, int[] exp$1, Object coeff$1, Semiring evidence$4$1, Eq evidence$5$1, ClassTag evidence$6$1, int[] es$2, Object cs$2) {
        while (i < ScalaRunTime$.MODULE$.array_length(coeff$1)) {
            Object c = ScalaRunTime$.MODULE$.array_apply(coeff$1, i);
            Semiring$ semiring$ = Semiring$.MODULE$;
            if (evidence$5$1.neqv(c, evidence$4$1.zero())) {
                es$2[j] = exp$1[i];
                ScalaRunTime$.MODULE$.array_update(cs$2, j, c);
                ++j;
                ++i;
                continue;
            }
            ++i;
        }
        return new PolySparse(es$2, cs$2, evidence$6$1);
    }

    private final int loop$3(int i, int j, int count, int lOffset$1, int rOffset$1, int[] lexp$1, int[] rexp$1) {
        while (i < lexp$1.length && j < rexp$1.length) {
            int cmp = lexp$1[i] + lOffset$1 - rexp$1[j] - rOffset$1;
            if (cmp == 0) {
                ++count;
                ++j;
                ++i;
                continue;
            }
            if (cmp < 0) {
                ++count;
                ++i;
                continue;
            }
            ++count;
            ++j;
        }
        return count + (lexp$1.length - i) + (rexp$1.length - j);
    }

    private final PolySparse sum$1(int i, int j, int k, Eq evidence$22$1, Semiring evidence$23$1, ClassTag evidence$24$1, int[] lexp$2, Object lcoeff$1, int[] rexp$2, Object rcoeff$1, int[] es$4, Object cs$4) {
        while (i < lexp$2.length && j < rexp$2.length) {
            int ei = lexp$2[i];
            int ej = rexp$2[j];
            if (ei == ej) {
                es$4[k] = ei;
                ScalaRunTime$.MODULE$.array_update(cs$4, k, evidence$23$1.plus(ScalaRunTime$.MODULE$.array_apply(lcoeff$1, i), ScalaRunTime$.MODULE$.array_apply(rcoeff$1, j)));
                ++k;
                ++j;
                ++i;
                continue;
            }
            if (ei < ej) {
                es$4[k] = ei;
                ScalaRunTime$.MODULE$.array_update(cs$4, k, ScalaRunTime$.MODULE$.array_apply(lcoeff$1, i));
                ++k;
                ++i;
                continue;
            }
            es$4[k] = ej;
            ScalaRunTime$.MODULE$.array_update(cs$4, k, ScalaRunTime$.MODULE$.array_apply(rcoeff$1, j));
            ++k;
            ++j;
        }
        int k0 = k;
        for (int index$macro$206 = i; index$macro$206 < lexp$2.length; ++index$macro$206) {
            es$4[k0] = lexp$2[index$macro$206];
            ScalaRunTime$.MODULE$.array_update(cs$4, k0, ScalaRunTime$.MODULE$.array_apply(lcoeff$1, index$macro$206));
            ++k0;
        }
        for (int index$macro$207 = j; index$macro$207 < rexp$2.length; ++index$macro$207) {
            es$4[k0] = rexp$2[index$macro$207];
            ScalaRunTime$.MODULE$.array_update(cs$4, k0, ScalaRunTime$.MODULE$.array_apply(rcoeff$1, index$macro$207));
            ++k0;
        }
        return this.safe(es$4, cs$4, evidence$23$1, evidence$22$1, evidence$24$1);
    }

    private final PolySparse loop$4(int i, int j, int k, Object c$1, int e$1, Eq evidence$25$1, Rng evidence$26$1, ClassTag evidence$27$1, int[] lexp$3, Object lcoeff$2, int[] rexp$3, Object rcoeff$2, int[] es$5, Object cs$5) {
        while (i < lexp$3.length && j < rexp$3.length) {
            int ei = lexp$3[i];
            int ej = rexp$3[j] + e$1;
            if (ei == ej) {
                es$5[k] = ei;
                ScalaRunTime$.MODULE$.array_update(cs$5, k, evidence$26$1.minus(ScalaRunTime$.MODULE$.array_apply(lcoeff$2, i), evidence$26$1.times(c$1, ScalaRunTime$.MODULE$.array_apply(rcoeff$2, j))));
                ++k;
                ++j;
                ++i;
                continue;
            }
            if (ei < ej) {
                es$5[k] = ei;
                ScalaRunTime$.MODULE$.array_update(cs$5, k, ScalaRunTime$.MODULE$.array_apply(lcoeff$2, i));
                ++k;
                ++i;
                continue;
            }
            es$5[k] = ej;
            ScalaRunTime$.MODULE$.array_update(cs$5, k, evidence$26$1.times(evidence$26$1.negate(c$1), ScalaRunTime$.MODULE$.array_apply(rcoeff$2, j)));
            ++k;
            ++j;
        }
        int k0 = k;
        for (int index$macro$208 = i; index$macro$208 < lexp$3.length; ++index$macro$208) {
            es$5[k0] = lexp$3[index$macro$208];
            ScalaRunTime$.MODULE$.array_update(cs$5, k0, ScalaRunTime$.MODULE$.array_apply(lcoeff$2, index$macro$208));
            ++k0;
        }
        for (int index$macro$209 = j; index$macro$209 < rexp$3.length; ++index$macro$209) {
            es$5[k0] = rexp$3[index$macro$209] + e$1;
            ScalaRunTime$.MODULE$.array_update(cs$5, k0, evidence$26$1.times(evidence$26$1.negate(c$1), ScalaRunTime$.MODULE$.array_apply(rcoeff$2, index$macro$209)));
            ++k0;
        }
        return this.safe(es$5, cs$5, evidence$26$1, evidence$25$1, evidence$27$1);
    }

    private final PolySparse inflate$1(List ts, int i, int[] es, Object cs, ClassTag evidence$30$1) {
        .colon.colon colon2;
        while (ts instanceof .colon.colon && (colon2 = (.colon.colon)ts).head() != null) {
            es[i] = ((Term)colon2.head()).exp();
            ScalaRunTime$.MODULE$.array_update(cs, i, ((Term)colon2.head()).coeff());
            ++i;
            ts = colon2.tl$1();
        }
        if (Nil$.MODULE$.equals(ts)) {
            return new PolySparse(es, cs, evidence$30$1);
        }
        throw new MatchError((Object)ts);
    }

    private final Tuple2 loop$5(List quot2, PolySparse rem, PolySparse rhs$1, Field evidence$28$1, Eq evidence$29$1, ClassTag evidence$30$1, int rdegree$1, Object rmaxCoeff$1) {
        while (!rem.isZero() && rem.degree() >= rdegree$1) {
            Object c0 = evidence$28$1.div(rem.maxOrderTermCoeff(evidence$28$1), rmaxCoeff$1);
            int e0 = rem.degree() - rdegree$1;
            Term<Object> term = new Term<Object>(c0, e0);
            rem = this.spire$math$poly$PolySparse$$subtractScaled(rem, c0, e0, rhs$1, evidence$29$1, evidence$28$1, evidence$30$1);
            quot2 = quot2.$colon$colon(term);
        }
        int len = quot2.size();
        return new Tuple2((Object)this.inflate$1(quot2, 0, new int[len], evidence$30$1.newArray(len), evidence$30$1), (Object)rem);
    }

    private final PolySparse loop$6(int i, int j, int[] exp$2, double[] coeff$2, Semiring evidence$4$2, Eq evidence$5$2, ClassTag evidence$6$2, int[] es$6, double[] cs$6) {
        while (i < coeff$2.length) {
            double c = coeff$2[i];
            Semiring$ semiring$ = Semiring$.MODULE$;
            if (evidence$5$2.neqv$mcD$sp(c, evidence$4$2.zero$mcD$sp())) {
                es$6[j] = exp$2[i];
                cs$6[j] = c;
                ++j;
                ++i;
                continue;
            }
            ++i;
        }
        return new PolySparse$mcD$sp(es$6, cs$6, (ClassTag<Object>)evidence$6$2);
    }

    private final int loop$7(int i, int j, int count, int lOffset$2, int rOffset$2, int[] lexp$4, int[] rexp$4) {
        while (i < lexp$4.length && j < rexp$4.length) {
            int cmp = lexp$4[i] + lOffset$2 - rexp$4[j] - rOffset$2;
            if (cmp == 0) {
                ++count;
                ++j;
                ++i;
                continue;
            }
            if (cmp < 0) {
                ++count;
                ++i;
                continue;
            }
            ++count;
            ++j;
        }
        return count + (lexp$4.length - i) + (rexp$4.length - j);
    }

    private final PolySparse inflate$2(List ts, int i, int[] es, double[] cs, ClassTag evidence$30$2) {
        .colon.colon colon2;
        while (ts instanceof .colon.colon && (colon2 = (.colon.colon)ts).head() != null) {
            es[i] = ((Term)colon2.head()).exp();
            cs[i] = ((Term)colon2.head()).coeff$mcD$sp();
            ++i;
            ts = colon2.tl$1();
        }
        if (Nil$.MODULE$.equals(ts)) {
            return new PolySparse$mcD$sp(es, cs, (ClassTag<Object>)evidence$30$2);
        }
        throw new MatchError((Object)ts);
    }

    private final Tuple2 loop$8(List quot2, PolySparse rem, PolySparse rhs$2, Field evidence$28$2, Eq evidence$29$2, ClassTag evidence$30$2, int rdegree$2, double rmaxCoeff$2) {
        while (!rem.isZero() && rem.degree() >= rdegree$2) {
            double c0 = evidence$28$2.div$mcD$sp(rem.maxOrderTermCoeff$mcD$sp(evidence$28$2), rmaxCoeff$2);
            int e0 = rem.degree() - rdegree$2;
            Term$mcD$sp term$mcD$sp = new Term$mcD$sp(c0, e0);
            rem = this.spire$math$poly$PolySparse$$subtractScaled(rem, BoxesRunTime.boxToDouble((double)c0), e0, rhs$2, evidence$29$2, evidence$28$2, evidence$30$2);
            quot2 = quot2.$colon$colon((Object)term$mcD$sp);
        }
        int len = quot2.size();
        return new Tuple2((Object)this.inflate$2(quot2, 0, new int[len], (double[])evidence$30$2.newArray(len), evidence$30$2), (Object)rem);
    }

    private PolySparse$() {
        MODULE$ = this;
    }
}

