/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.spockframework.guice.GuiceExtensionException;
import org.spockframework.mock.MockUtil;
import org.spockframework.runtime.extension.AbstractMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.SpecInfo;
import spock.lang.Shared;
import spock.lang.Specification;

public class GuiceInterceptor
extends AbstractMethodInterceptor {
    private static final MockUtil MOCK_UTIL = new MockUtil();
    private final Set<Class<? extends Module>> moduleClasses;
    private final Set<InjectionPoint> injectionPoints;
    private Injector injector;

    public GuiceInterceptor(SpecInfo spec, Set<Class<? extends Module>> moduleClasses) {
        this.moduleClasses = moduleClasses;
        this.injectionPoints = InjectionPoint.forInstanceMethodsAndFields((Class)((Class)spec.getReflection()));
    }

    public void interceptSharedInitializerMethod(IMethodInvocation invocation) throws Throwable {
        this.createInjector();
        this.injectValues(invocation.getSharedInstance(), true, (Specification)invocation.getInstance());
        invocation.proceed();
    }

    public void interceptInitializerMethod(IMethodInvocation invocation) throws Throwable {
        this.injectValues(invocation.getInstance(), false, (Specification)invocation.getInstance());
        invocation.proceed();
    }

    private void createInjector() {
        this.injector = Guice.createInjector(this.createModules());
    }

    private List<Module> createModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Class<? extends Module> clazz : this.moduleClasses) {
            try {
                modules.add(clazz.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new GuiceExtensionException("Failed to instantiate module '%s'", e).withArgs(new Object[]{clazz.getSimpleName()});
            }
        }
        return modules;
    }

    private void injectValues(Object target, boolean sharedFields, Specification specInstance) throws IllegalAccessException {
        for (InjectionPoint point : this.injectionPoints) {
            if (!(point.getMember() instanceof Field)) {
                throw new GuiceExtensionException("Method injection is not supported; use field injection instead");
            }
            Field field = (Field)point.getMember();
            if (field.isAnnotationPresent(Shared.class) != sharedFields) continue;
            Object value = this.injector.getInstance(((Dependency)point.getDependencies().get(0)).getKey());
            if (MOCK_UTIL.isMock(value)) {
                MOCK_UTIL.attachMock(value, specInstance);
            }
            field.setAccessible(true);
            field.set(target, value);
        }
    }
}

