/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.junit4;

import java.lang.annotation.Annotation;
import org.junit.runner.Description;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;

public class JUnitDescriptionGenerator {
    public static Description describeSpec(SpecInfo spec) {
        Description desc = Description.createSuiteDescription((Class)((Class)spec.getReflection()));
        if (spec.isExcluded() || spec.isSkipped()) {
            return desc;
        }
        for (FeatureInfo feature : spec.getAllFeaturesInExecutionOrder()) {
            if (feature.isExcluded()) continue;
            desc.addChild(JUnitDescriptionGenerator.describeFeature(feature, spec));
        }
        return desc;
    }

    public static Description describeFeature(FeatureInfo feature, SpecInfo spec) {
        return JUnitDescriptionGenerator.describeMethod(feature.getFeatureMethod(), spec);
    }

    public static Description describeIteration(IterationInfo iteration, SpecInfo spec) {
        return Description.createTestDescription((Class)((Class)spec.getReflection()), (String)iteration.getName(), (Annotation[])iteration.getFeature().getFeatureMethod().getAnnotations());
    }

    private static Description describeMethod(MethodInfo method, SpecInfo spec) {
        Annotation[] anns = method.getReflection() == null ? new Annotation[]{} : method.getAnnotations();
        Description desc = Description.createTestDescription((Class)((Class)spec.getReflection()), (String)method.getName(), (Annotation[])anns);
        return desc;
    }
}

