/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.junit4;

import java.util.ArrayList;
import java.util.List;
import org.spockframework.junit4.AbstractRuleExtension;
import org.spockframework.junit4.MethodRuleInterceptor;
import org.spockframework.junit4.TestRuleInterceptor;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;

public class RuleExtension
extends AbstractRuleExtension {
    public void visitSpec(SpecInfo spec) {
        if (ruleClass == null) {
            return;
        }
        ArrayList<FieldInfo> methodRuleFields = new ArrayList<FieldInfo>();
        ArrayList<FieldInfo> testRuleFields = new ArrayList<FieldInfo>();
        for (FieldInfo field : spec.getAllFields()) {
            if (!field.isAnnotationPresent(ruleClass)) continue;
            this.checkIsInstanceField(field);
            if (this.hasFieldType(field, methodRuleClass)) {
                methodRuleFields.add(field);
                continue;
            }
            if (this.hasFieldType(field, testRuleClass)) {
                testRuleFields.add(field);
                continue;
            }
            this.invalidFieldType(field);
        }
        if (!methodRuleFields.isEmpty()) {
            MethodRuleInterceptorInstaller.install(spec, methodRuleFields);
        }
        if (!testRuleFields.isEmpty()) {
            TestRuleInterceptorInstaller.install(spec, testRuleFields);
        }
    }

    private static class TestRuleInterceptorInstaller {
        private TestRuleInterceptorInstaller() {
        }

        static void install(SpecInfo spec, List<FieldInfo> ruleFields) {
            TestRuleInterceptor interceptor = new TestRuleInterceptor(ruleFields, spec);
            for (FeatureInfo feature : spec.getAllFeatures()) {
                feature.addIterationInterceptor((IMethodInterceptor)interceptor);
            }
        }
    }

    private static class MethodRuleInterceptorInstaller {
        private MethodRuleInterceptorInstaller() {
        }

        static void install(SpecInfo spec, List<FieldInfo> ruleFields) {
            MethodRuleInterceptor interceptor = new MethodRuleInterceptor(ruleFields);
            for (FeatureInfo feature : spec.getAllFeatures()) {
                feature.addIterationInterceptor((IMethodInterceptor)interceptor);
            }
        }
    }
}

