/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring;

import java.lang.reflect.Field;
import javax.annotation.Resource;
import org.spockframework.runtime.extension.ISpockExtension;
import org.spockframework.runtime.intercept.IMethodInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.spring.SpringExtensionException;
import org.spockframework.spring.SpringInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContextManager;
import spock.lang.Shared;

public class SpringExtension
implements ISpockExtension {
    public void visitSpec(SpecInfo spec) {
        if (!((Class)spec.getReflection()).isAnnotationPresent(ContextConfiguration.class)) {
            return;
        }
        this.checkNoSharedFieldInjected(spec);
        TestContextManager manager = new TestContextManager((Class)spec.getReflection());
        SpringInterceptor interceptor = new SpringInterceptor(manager);
        spec.addInterceptor((IMethodInterceptor)interceptor);
        spec.getSetupMethod().addInterceptor((IMethodInterceptor)interceptor);
        spec.getCleanupMethod().addInterceptor((IMethodInterceptor)interceptor);
        for (FeatureInfo feature : spec.getFeatures()) {
            feature.addInterceptor((IMethodInterceptor)interceptor);
        }
    }

    private void checkNoSharedFieldInjected(SpecInfo spec) {
        for (FieldInfo field : spec.getFields()) {
            Field reflection = (Field)field.getReflection();
            if (!reflection.isAnnotationPresent(Shared.class) || !reflection.isAnnotationPresent(Autowired.class) && !reflection.isAnnotationPresent(Resource.class)) continue;
            throw new SpringExtensionException("@Shared field '%s' cannot be injected; use an instance field instead").format(new Object[]{field.getName()});
        }
    }
}

