/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring;

import java.lang.reflect.Method;
import org.spockframework.runtime.SkipSpecOrFeatureException;
import org.spockframework.runtime.intercept.IMethodInterceptor;
import org.spockframework.runtime.intercept.IMethodInvocation;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.util.Assert;
import org.spockframework.util.UnreachableCodeError;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.test.context.TestContextManager;

public class SpringInterceptor
implements IMethodInterceptor {
    private final TestContextManager manager;
    private FeatureInfo currentFeature;

    public SpringInterceptor(TestContextManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(IMethodInvocation invocation) throws Throwable {
        switch (invocation.getMethod().getKind()) {
            case SPEC_EXECUTION: {
                Assert.notNull((Object)invocation.getMethod().getReflection());
                if (!ProfileValueUtils.isTestEnabledInThisEnvironment(invocation.getTarget().getClass())) {
                    throw new SkipSpecOrFeatureException("Specification not enabled in this environment");
                }
                invocation.proceed();
                break;
            }
            case FEATURE_EXECUTION: {
                this.currentFeature = invocation.getMethod().getFeature();
                try {
                    if (!ProfileValueUtils.isTestEnabledInThisEnvironment(invocation.getTarget().getClass())) {
                        throw new SkipSpecOrFeatureException("Feature not enabled in this environment");
                    }
                    invocation.proceed();
                    break;
                }
                finally {
                    this.currentFeature = null;
                }
            }
            case SETUP: {
                this.manager.prepareTestInstance(invocation.getTarget());
                this.manager.beforeTestMethod(invocation.getTarget(), (Method)this.currentFeature.getFeatureMethod().getReflection());
                invocation.proceed();
                break;
            }
            case CLEANUP: {
                Throwable throwable = null;
                try {
                    invocation.proceed();
                }
                catch (Throwable t) {
                    throwable = t;
                }
                Throwable throwable2 = null;
                try {
                    this.manager.afterTestMethod(invocation.getTarget(), (Method)this.currentFeature.getFeatureMethod().getReflection(), throwable);
                }
                catch (Throwable t2) {
                    throwable2 = t2;
                }
                if (throwable != null) {
                    throw throwable;
                }
                if (throwable2 == null) break;
                throw throwable2;
            }
            default: {
                throw new UnreachableCodeError();
            }
        }
    }
}

