/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.spring.SpringExtensionException;
import org.spockframework.spring.SpringInterceptor;
import org.spockframework.spring.SpringTestContextManager;
import org.spockframework.util.ReflectionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.test.context.ContextConfiguration;
import spock.lang.Shared;

public class SpringExtension
implements IGlobalExtension {
    public void visitSpec(SpecInfo spec) {
        if (!((Class)spec.getReflection()).isAnnotationPresent(ContextConfiguration.class)) {
            return;
        }
        this.checkNoSharedFieldsInjected(spec);
        if (!this.handleProfileValues(spec)) {
            return;
        }
        SpringTestContextManager manager = new SpringTestContextManager((Class)spec.getReflection());
        final SpringInterceptor interceptor = new SpringInterceptor(manager);
        spec.addListener((IRunListener)new AbstractRunListener(){

            public void error(ErrorInfo error) {
                interceptor.error(error);
            }
        });
        SpecInfo topSpec = spec.getTopSpec();
        topSpec.getSetupSpecMethod().addInterceptor((IMethodInterceptor)interceptor);
        topSpec.getSetupMethod().addInterceptor((IMethodInterceptor)interceptor);
        topSpec.getCleanupMethod().addInterceptor((IMethodInterceptor)interceptor);
        topSpec.getCleanupSpecMethod().addInterceptor((IMethodInterceptor)interceptor);
    }

    private void checkNoSharedFieldsInjected(SpecInfo spec) {
        for (FieldInfo field : spec.getAllFields()) {
            if (!((Field)field.getReflection()).isAnnotationPresent(Shared.class) || !((Field)field.getReflection()).isAnnotationPresent(Autowired.class) && !ReflectionUtil.isAnnotationPresent((AnnotatedElement)field.getReflection(), (String)"javax.annotation.Resource")) continue;
            throw new SpringExtensionException("@Shared field '%s' cannot be injected; use an instance field instead").withArgs(new Object[]{field.getName()});
        }
    }

    private boolean handleProfileValues(SpecInfo spec) {
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment((Class)((Class)spec.getReflection()))) {
            spec.setExcluded(true);
            return false;
        }
        for (FeatureInfo feature : spec.getAllFeatures()) {
            if (ProfileValueUtils.isTestEnabledInThisEnvironment((Method)((Method)feature.getFeatureMethod().getReflection()), (Class)((Class)spec.getReflection()))) continue;
            feature.setExcluded(true);
        }
        return true;
    }
}

