/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring;

import java.lang.reflect.Method;
import org.spockframework.runtime.extension.AbstractMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.spring.SpringTestContextManager;

public class SpringInterceptor
extends AbstractMethodInterceptor {
    private final SpringTestContextManager manager;
    private Throwable exception;
    private boolean beforeTestMethodInvoked = false;

    public SpringInterceptor(SpringTestContextManager manager) {
        this.manager = manager;
    }

    public void interceptSetupSpecMethod(IMethodInvocation invocation) throws Throwable {
        this.manager.beforeTestClass();
        invocation.proceed();
    }

    public void interceptSetupMethod(IMethodInvocation invocation) throws Throwable {
        this.manager.prepareTestInstance(invocation.getTarget());
        this.exception = null;
        this.beforeTestMethodInvoked = true;
        this.manager.beforeTestMethod(invocation.getTarget(), (Method)invocation.getFeature().getFeatureMethod().getReflection());
        invocation.proceed();
    }

    public void interceptCleanupMethod(IMethodInvocation invocation) throws Throwable {
        Throwable cleanupEx;
        block7: {
            if (!this.beforeTestMethodInvoked) {
                invocation.proceed();
                return;
            }
            this.beforeTestMethodInvoked = false;
            cleanupEx = null;
            try {
                invocation.proceed();
            }
            catch (Throwable t) {
                cleanupEx = t;
                if (this.exception != null) break block7;
                this.exception = t;
            }
        }
        Throwable afterTestMethodEx = null;
        try {
            this.manager.afterTestMethod(invocation.getTarget(), (Method)invocation.getFeature().getFeatureMethod().getReflection(), this.exception);
        }
        catch (Throwable t) {
            afterTestMethodEx = t;
        }
        if (cleanupEx != null) {
            throw cleanupEx;
        }
        if (afterTestMethodEx != null) {
            throw afterTestMethodEx;
        }
    }

    public void interceptCleanupSpecMethod(IMethodInvocation invocation) throws Throwable {
        Throwable cleanupSpecEx = null;
        try {
            invocation.proceed();
        }
        catch (Throwable t) {
            cleanupSpecEx = t;
        }
        Throwable afterTestClassEx = null;
        try {
            this.manager.afterTestClass();
        }
        catch (Throwable t) {
            afterTestClassEx = t;
        }
        if (cleanupSpecEx != null) {
            throw cleanupSpecEx;
        }
        if (afterTestClassEx != null) {
            throw afterTestClassEx;
        }
    }

    public void error(ErrorInfo error) {
        if (this.exception == null) {
            this.exception = error.getException();
        }
    }
}

