/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.spring.SpringExtensionException;
import org.spockframework.spring.SpringInterceptor;
import org.spockframework.spring.SpringTestContextManager;
import org.spockframework.util.ReflectionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.test.context.ContextConfiguration;
import spock.lang.Shared;

public class SpringExtension
implements IGlobalExtension {
    public void visitSpec(SpecInfo specInfo) {
        if (!((Class)specInfo.getReflection()).isAnnotationPresent(ContextConfiguration.class)) {
            return;
        }
        this.checkNoSharedFieldsInjected(specInfo);
        if (!this.handleProfileValues(specInfo)) {
            return;
        }
        SpringTestContextManager springTestContextManager = new SpringTestContextManager((Class)specInfo.getReflection());
        final SpringInterceptor springInterceptor = new SpringInterceptor(springTestContextManager);
        specInfo.addListener((IRunListener)new AbstractRunListener(){

            public void error(ErrorInfo errorInfo) {
                springInterceptor.error(errorInfo);
            }
        });
        SpecInfo specInfo2 = specInfo.getTopSpec();
        specInfo2.getSetupSpecMethod().addInterceptor((IMethodInterceptor)springInterceptor);
        specInfo2.getSetupMethod().addInterceptor((IMethodInterceptor)springInterceptor);
        specInfo2.getCleanupMethod().addInterceptor((IMethodInterceptor)springInterceptor);
        specInfo2.getCleanupSpecMethod().addInterceptor((IMethodInterceptor)springInterceptor);
    }

    private void checkNoSharedFieldsInjected(SpecInfo specInfo) {
        for (FieldInfo fieldInfo : specInfo.getAllFields()) {
            if (!((Field)fieldInfo.getReflection()).isAnnotationPresent(Shared.class) || !((Field)fieldInfo.getReflection()).isAnnotationPresent(Autowired.class) && !ReflectionUtil.isAnnotationPresent((AnnotatedElement)fieldInfo.getReflection(), (String)"javax.annotation.Resource")) continue;
            throw new SpringExtensionException("@Shared field '%s' cannot be injected; use an instance field instead").withArgs(new Object[]{fieldInfo.getName()});
        }
    }

    private boolean handleProfileValues(SpecInfo specInfo) {
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment((Class)((Class)specInfo.getReflection()))) {
            specInfo.setExcluded(true);
            return false;
        }
        for (FeatureInfo featureInfo : specInfo.getAllFeatures()) {
            if (ProfileValueUtils.isTestEnabledInThisEnvironment((Method)((Method)featureInfo.getFeatureMethod().getReflection()), (Class)((Class)specInfo.getReflection()))) continue;
            featureInfo.setExcluded(true);
        }
        return true;
    }
}

