/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.extension.AbstractGlobalExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.spring.SpringExtensionException;
import org.spockframework.spring.SpringInterceptor;
import org.spockframework.spring.SpringTestContextManager;
import org.spockframework.util.ReflectionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.test.context.ContextConfiguration;
import spock.lang.Shared;

public class SpringExtension
extends AbstractGlobalExtension {
    private static final Class<? extends Annotation> contextHierarchyClass = ReflectionUtil.loadClassIfAvailable((String)"org.springframework.test.context.ContextHierarchy");
    private static final Method findAnnotationDescriptorForTypesMethod;
    private static final Class<? extends Annotation> springBootTestClass;

    public void visitSpec(SpecInfo spec) {
        if (!this.isSpringSpec(spec)) {
            return;
        }
        this.checkNoSharedFieldsInjected(spec);
        if (!this.handleProfileValues(spec)) {
            return;
        }
        SpringTestContextManager manager = new SpringTestContextManager((Class)spec.getReflection());
        final SpringInterceptor interceptor = new SpringInterceptor(manager);
        spec.addListener((IRunListener)new AbstractRunListener(){

            public void error(ErrorInfo error) {
                interceptor.error(error);
            }
        });
        spec.addSetupSpecInterceptor((IMethodInterceptor)interceptor);
        spec.addSetupInterceptor((IMethodInterceptor)interceptor);
        spec.addCleanupInterceptor((IMethodInterceptor)interceptor);
        spec.addCleanupSpecInterceptor((IMethodInterceptor)interceptor);
    }

    private boolean isSpringSpec(SpecInfo spec) {
        boolean springAnnotationPresent;
        boolean contextAnnotationPresent = spec.isAnnotationPresent(ContextConfiguration.class);
        boolean contextHierarchyAnnotationPresent = contextHierarchyClass != null && spec.isAnnotationPresent(contextHierarchyClass);
        boolean springBootTestAnnotationPresent = springBootTestClass != null && spec.isAnnotationPresent(springBootTestClass);
        boolean bl = springAnnotationPresent = contextAnnotationPresent || contextHierarchyAnnotationPresent || springBootTestAnnotationPresent;
        if (springAnnotationPresent) {
            return true;
        }
        return findAnnotationDescriptorForTypesMethod != null && ReflectionUtil.invokeMethod(null, (Method)findAnnotationDescriptorForTypesMethod, (Object[])new Object[]{spec.getReflection(), new Class[]{ContextConfiguration.class, contextHierarchyClass}}) != null;
    }

    private void checkNoSharedFieldsInjected(SpecInfo spec) {
        for (FieldInfo field : spec.getAllFields()) {
            if (!((Field)field.getReflection()).isAnnotationPresent(Shared.class) || !((Field)field.getReflection()).isAnnotationPresent(Autowired.class) && !ReflectionUtil.isAnnotationPresent((AnnotatedElement)field.getReflection(), (String)"javax.annotation.Resource") && !ReflectionUtil.isAnnotationPresent((AnnotatedElement)field.getReflection(), (String)"javax.inject.Inject")) continue;
            throw new SpringExtensionException("@Shared field '%s' cannot be injected; use an instance field instead").withArgs(new Object[]{field.getName()});
        }
    }

    private boolean handleProfileValues(SpecInfo spec) {
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment((Class)((Class)spec.getReflection()))) {
            spec.setExcluded(true);
            return false;
        }
        for (FeatureInfo feature : spec.getAllFeatures()) {
            if (ProfileValueUtils.isTestEnabledInThisEnvironment((Method)((Method)feature.getFeatureMethod().getReflection()), (Class)((Class)spec.getReflection()))) continue;
            feature.setExcluded(true);
        }
        return true;
    }

    static {
        springBootTestClass = ReflectionUtil.loadClassIfAvailable((String)"org.springframework.boot.test.context.SpringBootTest");
        Class metaAnnotationUtilsClass = ReflectionUtil.loadClassIfAvailable((String)"org.springframework.test.util.MetaAnnotationUtils");
        findAnnotationDescriptorForTypesMethod = metaAnnotationUtilsClass == null ? null : ReflectionUtil.getMethodBySignature((Class)metaAnnotationUtilsClass, (String)"findAnnotationDescriptorForTypes", (Class[])new Class[]{Class.class, Class[].class});
    }
}

