/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring;

import java.util.ArrayList;
import java.util.List;
import org.spockframework.mock.MockUtil;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import spock.lang.Specification;

public class SpringMockTestExecutionListener
implements TestExecutionListener {
    public static final String MOCKED_BEANS_LIST = "org.spockframework.spring.SpringMockTestExecutionListener.MOCKED_BEANS_LIST";
    private final MockUtil mockUtil = new MockUtil();

    public void beforeTestClass(TestContext testContext) throws Exception {
    }

    public void prepareTestInstance(TestContext testContext) throws Exception {
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        ArrayList<Object> mockedBeans;
        Object testInstance = testContext.getTestInstance();
        if (testInstance instanceof Specification) {
            Specification specification = (Specification)testInstance;
            ApplicationContext applicationContext = testContext.getApplicationContext();
            String[] mockBeanNames = applicationContext.getBeanDefinitionNames();
            mockedBeans = new ArrayList<Object>();
            for (String beanName : mockBeanNames) {
                Object bean;
                BeanDefinition beanDefinition = ((BeanDefinitionRegistry)applicationContext).getBeanDefinition(beanName);
                if (beanDefinition.isAbstract() || !this.mockUtil.isMock(bean = applicationContext.getBean(beanName))) continue;
                this.mockUtil.attachMock(bean, specification);
                mockedBeans.add(bean);
            }
        } else {
            throw new IllegalArgumentException("SpringMockTestExecutionListener is only applicable for spock specifications.");
        }
        testContext.setAttribute(MOCKED_BEANS_LIST, mockedBeans);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        List mockedBeans = (List)testContext.getAttribute(MOCKED_BEANS_LIST);
        if (mockedBeans != null) {
            for (Object object : mockedBeans) {
                this.mockUtil.detachMock(object);
            }
        }
    }

    public void afterTestClass(TestContext testContext) throws Exception {
    }
}

