/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring.xml;

import java.util.Collections;
import org.spockframework.mock.MockNature;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import spock.mock.DetachedMockFactory;

public class SpockSpyBeanPostProcessor
implements BeanPostProcessor,
BeanDefinitionRegistryPostProcessor {
    private final String beanName;

    public SpockSpyBeanPostProcessor(String beanName) {
        this.beanName = beanName;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.beanName.equals(beanName)) {
            return new DetachedMockFactory().createMock(beanName, bean, MockNature.SPY, Collections.emptyMap());
        }
        return bean;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (!registry.containsBeanDefinition(this.beanName)) {
            throw new NoSuchBeanDefinitionException(this.beanName, "Spock WrapWithSpy must reference an existing bean id.");
        }
    }
}

