/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring.mock;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.spring.SpringExtensionException;
import org.spockframework.spring.mock.Definition;
import org.spockframework.spring.mock.MockDefinition;
import org.spockframework.spring.mock.QualifierDefinition;
import org.spockframework.spring.mock.SpyDefinition;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SpockMockPostprocessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryPostProcessor,
Ordered {
    private static final String FACTORY_BEAN_OBJECT_TYPE = "factoryBeanObjectType";
    private static final String BEAN_NAME = SpockMockPostprocessor.class.getName();
    private final Set<Definition> definitions;
    private final BeanNameGenerator beanNameGenerator = new DefaultBeanNameGenerator();
    private Map<String, SpyDefinition> spies = new HashMap<String, SpyDefinition>();
    private BeanFactory beanFactory;

    public SpockMockPostprocessor(Set<Definition> definitions) {
        this.definitions = definitions;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(BeanDefinitionRegistry.class, (Object)beanFactory, (String)"SpockMockPostprocessor can only be used on bean factories that implement BeanDefinitionRegistry");
        this.postProcessBeanFactory(beanFactory, (BeanDefinitionRegistry)beanFactory);
    }

    private void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry) {
        this.beanFactory = beanFactory;
        for (Definition definition : this.definitions) {
            this.register(beanFactory, registry, definition);
        }
    }

    private void register(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, Definition definition) {
        if (definition instanceof MockDefinition) {
            this.registerMock(beanFactory, registry, (MockDefinition)definition);
        } else if (definition instanceof SpyDefinition) {
            this.registerSpy(beanFactory, registry, (SpyDefinition)definition);
        }
    }

    private void registerMock(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, MockDefinition definition) {
        BeanDefinition beanDefinition = this.createBeanDefinition(definition);
        String beanName = this.getBeanName(beanFactory, registry, definition, beanDefinition);
        String transformedBeanName = BeanFactoryUtils.transformedBeanName((String)beanName);
        beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)beanName);
        if (registry.containsBeanDefinition(transformedBeanName)) {
            registry.removeBeanDefinition(transformedBeanName);
        }
        registry.registerBeanDefinition(transformedBeanName, beanDefinition);
        Object mock = this.createMock(definition, beanName);
        beanFactory.registerSingleton(transformedBeanName, mock);
        this.registerAliases(beanFactory, definition, transformedBeanName);
    }

    private void registerAliases(ConfigurableListableBeanFactory beanFactory, MockDefinition definition, String beanName) {
        for (String alias : definition.getAliases()) {
            beanFactory.registerAlias(beanName, alias);
        }
    }

    private BeanDefinition createBeanDefinition(MockDefinition mockDefinition) {
        RootBeanDefinition definition = new RootBeanDefinition(mockDefinition.getTypeToMock().resolve());
        definition.setTargetType(mockDefinition.getTypeToMock());
        definition.setFactoryBeanName(BEAN_NAME);
        definition.setFactoryMethodName("createMock");
        definition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)mockDefinition);
        if (mockDefinition.getQualifier() != null) {
            mockDefinition.getQualifier().applyTo(definition);
        }
        return definition;
    }

    private Object createMock(MockDefinition mockDefinition, String name) {
        return mockDefinition.createMock(name + " bean");
    }

    private String getBeanName(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, MockDefinition mockDefinition, BeanDefinition beanDefinition) {
        if (StringUtils.hasLength((String)mockDefinition.getName())) {
            return mockDefinition.getName();
        }
        Set<String> existingBeans = this.findCandidateBeans(beanFactory, mockDefinition);
        if (existingBeans.isEmpty()) {
            return this.beanNameGenerator.generateBeanName(beanDefinition, registry);
        }
        if (existingBeans.size() == 1) {
            return existingBeans.iterator().next();
        }
        throw new IllegalStateException("Unable to register mock bean " + mockDefinition.getTypeToMock() + " expected a single matching bean to replace but found " + existingBeans);
    }

    private void registerSpy(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, SpyDefinition definition) {
        Object[] existingBeans = this.getExistingBeans(beanFactory, definition.getTypeToSpy());
        if (ObjectUtils.isEmpty((Object[])existingBeans)) {
            FieldInfo fieldInfo = definition.getFieldInfo();
            throw new SpringExtensionException(String.format("No matching bean found! @SpringSpy requires an existing spring bean to wrap, to create a standalone spy use @SpringBean.%nOffending Field: '%s.%s:%d'", ((SpecInfo)fieldInfo.getParent()).getName(), fieldInfo.getName(), fieldInfo.getLine()));
        }
        this.registerSpies(registry, definition, (String[])existingBeans);
    }

    private Set<String> findCandidateBeans(ConfigurableListableBeanFactory beanFactory, MockDefinition mockDefinition) {
        QualifierDefinition qualifier = mockDefinition.getQualifier();
        TreeSet<String> candidates = new TreeSet<String>();
        for (String candidate : this.getExistingBeans(beanFactory, mockDefinition.getTypeToMock())) {
            if (qualifier != null && !qualifier.matches(beanFactory, candidate)) continue;
            candidates.add(candidate);
        }
        return candidates;
    }

    private String[] getExistingBeans(ConfigurableListableBeanFactory beanFactory, ResolvableType type) {
        LinkedHashSet<String> beans = new LinkedHashSet<String>(Arrays.asList(beanFactory.getBeanNamesForType(type)));
        String resolvedTypeName = type.resolve(Object.class).getName();
        for (String beanName : beanFactory.getBeanNamesForType(FactoryBean.class)) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName = BeanFactoryUtils.transformedBeanName((String)beanName));
            if (!resolvedTypeName.equals(beanDefinition.getAttribute(FACTORY_BEAN_OBJECT_TYPE))) continue;
            beans.add(beanName);
        }
        beans.removeIf(this::isScopedTarget);
        return beans.toArray(new String[0]);
    }

    private boolean isScopedTarget(String beanName) {
        try {
            return ScopedProxyUtils.isScopedTarget((String)beanName);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private void registerSpies(BeanDefinitionRegistry registry, SpyDefinition definition, String[] existingBeans) {
        try {
            this.registerSpy(definition, this.determineBeanName(existingBeans, definition, registry));
        }
        catch (RuntimeException ex) {
            throw new IllegalStateException("Unable to register spy bean " + definition.getTypeToSpy(), ex);
        }
    }

    private String determineBeanName(String[] existingBeans, SpyDefinition definition, BeanDefinitionRegistry registry) {
        if (StringUtils.hasText((String)definition.getName())) {
            return definition.getName();
        }
        if (existingBeans.length == 1) {
            return existingBeans[0];
        }
        return this.determinePrimaryCandidate(registry, existingBeans, definition.getTypeToSpy());
    }

    private String determinePrimaryCandidate(BeanDefinitionRegistry registry, String[] candidateBeanNames, ResolvableType type) {
        String primaryBeanName = null;
        for (String candidateBeanName : candidateBeanNames) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(candidateBeanName);
            if (!beanDefinition.isPrimary()) continue;
            if (primaryBeanName != null) {
                throw new NoUniqueBeanDefinitionException(type.resolve(), candidateBeanNames.length, "more than one 'primary' bean found among candidates: " + Arrays.asList(candidateBeanNames));
            }
            primaryBeanName = candidateBeanName;
        }
        return primaryBeanName;
    }

    private void registerSpy(SpyDefinition definition, String beanName) {
        this.spies.put(beanName, definition);
    }

    Object createSpyIfNecessary(Object bean, String beanName) throws BeansException {
        SpyDefinition definition = this.spies.get(beanName);
        if (definition != null) {
            bean = definition.createSpy(beanName, bean);
        }
        return bean;
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    static void register(BeanDefinitionRegistry registry, Set<Definition> definitions) {
        SpockMockPostprocessor.register(registry, SpockMockPostprocessor.class, definitions);
    }

    static void register(BeanDefinitionRegistry registry, Class<? extends SpockMockPostprocessor> postProcessor, Set<Definition> definitions) {
        SpyPostProcessor.register(registry);
        BeanDefinition definition = SpockMockPostprocessor.getOrAddBeanDefinition(registry, postProcessor);
        ConstructorArgumentValues.ValueHolder constructorArg = definition.getConstructorArgumentValues().getIndexedArgumentValue(0, Set.class);
        Set existing = (Set)constructorArg.getValue();
        if (definitions != null) {
            existing.addAll(definitions);
        }
    }

    private static BeanDefinition getOrAddBeanDefinition(BeanDefinitionRegistry registry, Class<? extends SpockMockPostprocessor> postProcessor) {
        if (!registry.containsBeanDefinition(BEAN_NAME)) {
            RootBeanDefinition definition = new RootBeanDefinition(postProcessor);
            definition.setRole(2);
            ConstructorArgumentValues constructorArguments = definition.getConstructorArgumentValues();
            constructorArguments.addIndexedArgumentValue(0, new LinkedHashSet());
            registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)definition);
            return definition;
        }
        return registry.getBeanDefinition(BEAN_NAME);
    }

    public void injectSpies(Object testInstance) {
        for (Map.Entry<String, SpyDefinition> spyDefinitionEntry : this.spies.entrySet()) {
            FieldInfo fieldInfo = spyDefinitionEntry.getValue().getFieldInfo();
            Object spy = this.beanFactory.getBean(spyDefinitionEntry.getKey(), fieldInfo.getType());
            fieldInfo.writeValue(testInstance, spy);
        }
    }

    static class SpyPostProcessor
    extends InstantiationAwareBeanPostProcessorAdapter
    implements PriorityOrdered {
        private static final String BEAN_NAME = SpyPostProcessor.class.getName();
        private final SpockMockPostprocessor spockMockPostprocessor;

        SpyPostProcessor(SpockMockPostprocessor spockMockPostprocessor) {
            this.spockMockPostprocessor = spockMockPostprocessor;
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public Object getEarlyBeanReference(Object bean, String beanName) throws BeansException {
            return this.createSpyIfNecessary(bean, beanName);
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof FactoryBean) {
                return bean;
            }
            return this.createSpyIfNecessary(bean, beanName);
        }

        private Object createSpyIfNecessary(Object bean, String beanName) {
            return this.spockMockPostprocessor.createSpyIfNecessary(bean, beanName);
        }

        static void register(BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition(BEAN_NAME)) {
                RootBeanDefinition definition = new RootBeanDefinition(SpyPostProcessor.class);
                definition.setRole(2);
                ConstructorArgumentValues constructorArguments = definition.getConstructorArgumentValues();
                constructorArguments.addIndexedArgumentValue(0, (Object)new RuntimeBeanReference(BEAN_NAME));
                registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)definition);
            }
        }
    }
}

