/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.spring.SpringBean;
import org.spockframework.spring.SpringExtensionException;
import org.spockframework.spring.mock.FieldDefinition;
import org.spockframework.spring.mock.MockDefinition;
import org.spockframework.spring.mock.SpockSpringProxyCreator;
import org.spockframework.util.Assert;
import org.springframework.core.ResolvableType;
import org.springframework.util.ObjectUtils;

class SpockDefinition
extends FieldDefinition
implements MockDefinition {
    private final SpringBean annotation;

    SpockDefinition(FieldInfo fieldInfo) {
        super(fieldInfo);
        this.validate();
        this.annotation = (SpringBean)fieldInfo.getAnnotation(SpringBean.class);
    }

    private void validate() {
        FieldInfo fieldInfo = this.getFieldInfo();
        Assert.that((boolean)fieldInfo.isAnnotationPresent(SpringBean.class), (String)"SpringBean annotation is required for this field: '%s.%s:%d' ", (Object[])new Object[]{((SpecInfo)fieldInfo.getParent()).getName(), fieldInfo.getName(), fieldInfo.getLine()});
        if (!fieldInfo.hasInitializer()) {
            throw new SpringExtensionException(String.format("Field '%s.%s:%d' needs to have an initializer, e.g. List l = Mock()", ((SpecInfo)fieldInfo.getParent()).getName(), fieldInfo.getName(), fieldInfo.getLine()));
        }
        if (Object.class.equals((Object)fieldInfo.getType())) {
            throw new SpringExtensionException(String.format("Field '%s.%s:%d' must use a concrete type, not def or Object.", ((SpecInfo)fieldInfo.getParent()).getName(), fieldInfo.getName(), fieldInfo.getLine()));
        }
    }

    @Override
    public String getName() {
        return this.annotation.name();
    }

    @Override
    public List<String> getAliases() {
        if (this.annotation.aliases().length == 0) {
            return Collections.singletonList(this.getFieldInfo().getName());
        }
        ArrayList<String> aliases = new ArrayList<String>(Arrays.asList(this.annotation.aliases()));
        aliases.add(this.getFieldInfo().getName());
        return aliases;
    }

    @Override
    public ResolvableType getTypeToMock() {
        return this.resolvableType;
    }

    @Override
    public Object createMock(String s) {
        return SpockSpringProxyCreator.create(this.getFieldInfo());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.getTypeToMock());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SpockDefinition other = (SpockDefinition)obj;
        boolean result = super.equals(obj);
        result = result && ObjectUtils.nullSafeEquals((Object)this.getTypeToMock(), (Object)other.getTypeToMock());
        return result;
    }
}

