/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.tapestry;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.tapestry5.ioc.annotations.ImportModule;
import org.apache.tapestry5.ioc.annotations.SubModule;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.tapestry.TapestryInterceptor;
import org.spockframework.util.ReflectionUtil;

public class TapestryExtension
implements IGlobalExtension {
    private static final Class<? extends Annotation> importModuleAnnotation = ReflectionUtil.loadClassIfAvailable((String)"org.apache.tapestry5.ioc.annotations.ImportModule");
    private static final Class<? extends Annotation> submoduleAnnotation = ReflectionUtil.loadClassIfAvailable((String)"org.apache.tapestry5.ioc.annotations.SubModule");

    public void visitSpec(SpecInfo spec) {
        Set<Class<?>> modules = this.collectModules(spec);
        if (modules == null) {
            return;
        }
        TapestryInterceptor interceptor = new TapestryInterceptor(spec, modules);
        spec.addSharedInitializerInterceptor((IMethodInterceptor)interceptor);
        spec.addInitializerInterceptor((IMethodInterceptor)interceptor);
        spec.addCleanupSpecInterceptor((IMethodInterceptor)interceptor);
    }

    private Set<Class<?>> collectModules(SpecInfo spec) {
        HashSet<Class> modules = null;
        for (SpecInfo curr : spec.getSpecsTopToBottom()) {
            SubModule subModule;
            ImportModule importModule;
            if (importModuleAnnotation != null && spec.isAnnotationPresent(importModuleAnnotation) && (importModule = (ImportModule)curr.getAnnotation(ImportModule.class)) != null) {
                if (modules == null) {
                    modules = new HashSet<Class>();
                }
                modules.addAll(Arrays.asList(importModule.value()));
            }
            if (submoduleAnnotation == null || !spec.isAnnotationPresent(submoduleAnnotation) || (subModule = (SubModule)curr.getAnnotation(SubModule.class)) == null) continue;
            if (modules == null) {
                modules = new HashSet();
            }
            modules.addAll(Arrays.asList(subModule.value()));
        }
        return modules;
    }
}

