/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.unitils;

import java.lang.reflect.Method;
import org.spockframework.runtime.extension.AbstractMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.FeatureInfo;
import org.unitils.core.TestListener;
import org.unitils.core.Unitils;

public class UnitilsInterceptor
extends AbstractMethodInterceptor {
    private final TestListener listener = Unitils.getInstance().getTestListener();
    private FeatureInfo currentFeature;

    public void interceptSetupSpecMethod(IMethodInvocation invocation) throws Throwable {
        this.listener.beforeTestClass(invocation.getSharedInstance().getClass());
        invocation.proceed();
    }

    public void interceptSetupMethod(IMethodInvocation invocation) throws Throwable {
        this.listener.afterCreateTestObject(invocation.getInstance());
        this.listener.beforeTestSetUp(invocation.getInstance(), (Method)this.currentFeature.getFeatureMethod().getReflection());
        invocation.proceed();
    }

    public void interceptFeatureMethod(IMethodInvocation invocation) throws Throwable {
        Throwable throwable = null;
        this.listener.beforeTestMethod(invocation.getInstance(), (Method)invocation.getMethod().getReflection());
        try {
            invocation.proceed();
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            this.listener.afterTestMethod(invocation.getInstance(), (Method)invocation.getMethod().getReflection(), throwable);
        }
    }

    public void interceptCleanupMethod(IMethodInvocation invocation) throws Throwable {
        try {
            invocation.proceed();
        }
        finally {
            this.listener.afterTestTearDown(invocation.getInstance(), (Method)this.currentFeature.getFeatureMethod().getReflection());
        }
    }

    public void interceptFeatureExecution(IMethodInvocation invocation) throws Throwable {
        this.currentFeature = invocation.getMethod().getFeature();
        try {
            invocation.proceed();
        }
        finally {
            this.currentFeature = null;
        }
    }
}

