/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.prompt;

import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.adapter.PromptAdapter;
import org.springaicommunity.mcp.annotation.McpPrompt;
import org.springaicommunity.mcp.method.prompt.AsyncStatelessMcpPromptMethodCallback;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AsyncStatelessMcpPromptProvider {
    private static final Logger logger = LoggerFactory.getLogger(AsyncStatelessMcpPromptProvider.class);
    private final List<Object> promptObjects;

    public AsyncStatelessMcpPromptProvider(List<Object> promptObjects) {
        Assert.notNull(promptObjects, (String)"promptObjects cannot be null");
        this.promptObjects = promptObjects;
    }

    public List<McpStatelessServerFeatures.AsyncPromptSpecification> getPromptSpecifications() {
        List<McpStatelessServerFeatures.AsyncPromptSpecification> promptSpecs = this.promptObjects.stream().map(promptObject -> Stream.of(this.doGetClassMethods(promptObject)).filter(method -> method.isAnnotationPresent(McpPrompt.class)).filter(method -> Mono.class.isAssignableFrom(method.getReturnType()) || Flux.class.isAssignableFrom(method.getReturnType()) || Publisher.class.isAssignableFrom(method.getReturnType())).map(mcpPromptMethod -> {
            McpPrompt promptAnnotation = mcpPromptMethod.getAnnotation(McpPrompt.class);
            McpSchema.Prompt mcpPrompt = PromptAdapter.asPrompt(promptAnnotation, mcpPromptMethod);
            AsyncStatelessMcpPromptMethodCallback methodCallback = ((AsyncStatelessMcpPromptMethodCallback.Builder)((AsyncStatelessMcpPromptMethodCallback.Builder)((AsyncStatelessMcpPromptMethodCallback.Builder)AsyncStatelessMcpPromptMethodCallback.builder().method((Method)mcpPromptMethod)).bean(promptObject)).prompt(mcpPrompt)).build();
            return new McpStatelessServerFeatures.AsyncPromptSpecification(mcpPrompt, (BiFunction)methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        if (promptSpecs.isEmpty()) {
            logger.warn("No prompt methods found in the provided prompt objects: {}", this.promptObjects);
        }
        return promptSpecs;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

