/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.tool;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springaicommunity.mcp.method.tool.utils.ConcurrentReferenceHashMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveUtils {
    private static final Map<Type, Boolean> isReactiveOfVoidCache = new ConcurrentReferenceHashMap<Type, Boolean>(256);
    private static final Map<Type, Boolean> isReactiveOfCallToolResultCache = new ConcurrentReferenceHashMap<Type, Boolean>(256);

    public static boolean isReactiveReturnTypeOfVoid(Method method) {
        Type typeArgument;
        Type[] typeArguments;
        Class rawClass;
        ParameterizedType parameterizedType;
        Type rawType;
        Type returnType = method.getGenericReturnType();
        if (isReactiveOfVoidCache.containsKey(returnType)) {
            return isReactiveOfVoidCache.get(returnType);
        }
        boolean isReactiveOfVoid = false;
        if (returnType instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)returnType).getRawType()) instanceof Class && (Mono.class.isAssignableFrom(rawClass = (Class)rawType) || Flux.class.isAssignableFrom(rawClass) || Publisher.class.isAssignableFrom(rawClass)) && (typeArguments = parameterizedType.getActualTypeArguments()).length == 1 && (typeArgument = typeArguments[0]) instanceof Class) {
            isReactiveOfVoid = Void.class.equals((Object)typeArgument) || Void.TYPE.equals(typeArgument);
        }
        isReactiveOfVoidCache.putIfAbsent(returnType, isReactiveOfVoid);
        return isReactiveOfVoid;
    }

    public static boolean isReactiveReturnTypeOfCallToolResult(Method method) {
        Type typeArgument;
        Type[] typeArguments;
        Class rawClass;
        ParameterizedType parameterizedType;
        Type rawType;
        Type returnType = method.getGenericReturnType();
        if (isReactiveOfCallToolResultCache.containsKey(returnType)) {
            return isReactiveOfCallToolResultCache.get(returnType);
        }
        boolean isReactiveOfCallToolResult = false;
        if (returnType instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)returnType).getRawType()) instanceof Class && (Mono.class.isAssignableFrom(rawClass = (Class)rawType) || Flux.class.isAssignableFrom(rawClass) || Publisher.class.isAssignableFrom(rawClass)) && (typeArguments = parameterizedType.getActualTypeArguments()).length == 1 && (typeArgument = typeArguments[0]) instanceof Class) {
            isReactiveOfCallToolResult = McpSchema.CallToolResult.class.isAssignableFrom((Class)typeArgument);
        }
        isReactiveOfCallToolResultCache.putIfAbsent(returnType, isReactiveOfCallToolResult);
        return isReactiveOfCallToolResult;
    }

    public static Optional<Type> getReactiveReturnTypeArgument(Method method) {
        Class rawClass;
        ParameterizedType parameterizedType;
        Type rawType;
        Type returnType = method.getGenericReturnType();
        if (returnType instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)returnType).getRawType()) instanceof Class && (Mono.class.isAssignableFrom(rawClass = (Class)rawType) || Flux.class.isAssignableFrom(rawClass) || Publisher.class.isAssignableFrom(rawClass))) {
            return Optional.of(parameterizedType.getActualTypeArguments()[0]);
        }
        return Optional.empty();
    }
}

