/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.sampling;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpSampling;
import org.springaicommunity.mcp.method.sampling.AsyncMcpSamplingMethodCallback;
import org.springaicommunity.mcp.method.sampling.AsyncSamplingSpecification;
import org.springaicommunity.mcp.provider.McpProviderUtils;

public class AsyncMcpSamplingProvider {
    private static final Logger logger = LoggerFactory.getLogger(AsyncMcpSamplingProvider.class);
    private final List<Object> samplingObjects;

    public AsyncMcpSamplingProvider(List<Object> samplingObjects) {
        Assert.notNull(samplingObjects, (String)"samplingObjects cannot be null");
        this.samplingObjects = samplingObjects;
    }

    public List<AsyncSamplingSpecification> getSamplingSpecifictions() {
        List<AsyncSamplingSpecification> samplingHandlers = this.samplingObjects.stream().map(samplingObject -> Stream.of(this.doGetClassMethods(samplingObject)).filter(method -> method.isAnnotationPresent(McpSampling.class)).filter(method -> method.getParameterCount() == 1 && McpSchema.CreateMessageRequest.class.isAssignableFrom(method.getParameterTypes()[0])).filter(McpProviderUtils.filterNonReactiveReturnTypeMethod()).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(mcpSamplingMethod -> {
            McpSampling samplingAnnotation = mcpSamplingMethod.getAnnotation(McpSampling.class);
            AsyncMcpSamplingMethodCallback methodCallback = ((AsyncMcpSamplingMethodCallback.Builder)((AsyncMcpSamplingMethodCallback.Builder)((AsyncMcpSamplingMethodCallback.Builder)AsyncMcpSamplingMethodCallback.builder().method((Method)mcpSamplingMethod)).bean(samplingObject)).sampling(samplingAnnotation)).build();
            return new AsyncSamplingSpecification(samplingAnnotation.clients(), methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        if (samplingHandlers.isEmpty()) {
            logger.warn("No sampling methods found");
        }
        if (samplingHandlers.size() > 1) {
            logger.warn("Multiple sampling methods found: " + samplingHandlers.size());
        }
        return samplingHandlers;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

