/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.resource;

import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.springaicommunity.mcp.ErrorUtils;
import org.springaicommunity.mcp.method.resource.AbstractMcpResourceMethodCallback;
import org.springaicommunity.mcp.method.resource.DefaultMcpReadResourceResultConverter;

public final class SyncMcpResourceMethodCallback
extends AbstractMcpResourceMethodCallback
implements BiFunction<McpSyncServerExchange, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> {
    private SyncMcpResourceMethodCallback(Builder builder) {
        super(builder.method, builder.bean, builder.uri, builder.name, builder.description, builder.mimeType, builder.resultConverter, builder.uriTemplateManagerFactory, builder.contentType);
        this.validateMethod(this.method);
    }

    @Override
    protected void validateParamType(Class<?> paramType) {
        if (McpAsyncServerExchange.class.isAssignableFrom(paramType)) {
            throw new IllegalArgumentException("Sync prompt method must not declare parameter of type: " + paramType.getName() + ". Use McpSyncServerExchange instead. Method: " + this.method.getName() + " in " + this.method.getDeclaringClass().getName());
        }
    }

    @Override
    protected Object assignExchangeType(Class<?> paramType, Object exchange) {
        if (McpTransportContext.class.isAssignableFrom(paramType)) {
            if (exchange instanceof McpTransportContext) {
                McpTransportContext transportContext = (McpTransportContext)exchange;
                return transportContext;
            }
            if (exchange instanceof McpSyncServerExchange) {
                McpSyncServerExchange syncServerExchange = (McpSyncServerExchange)exchange;
                return syncServerExchange.transportContext();
            }
            if (exchange instanceof McpAsyncServerExchange) {
                McpAsyncServerExchange asyncServerExchange = (McpAsyncServerExchange)exchange;
                throw new IllegalArgumentException("Unsupported Async exchange type: " + asyncServerExchange.getClass().getName() + " for Sync method: " + this.method.getName() + " in " + this.method.getDeclaringClass().getName());
            }
        } else if (McpSyncServerExchange.class.isAssignableFrom(paramType)) {
            if (exchange instanceof McpSyncServerExchange) {
                McpSyncServerExchange syncServerExchange = (McpSyncServerExchange)exchange;
                return syncServerExchange;
            }
            throw new IllegalArgumentException("Unsupported exchange type: " + (exchange != null ? exchange.getClass().getName() : "null") + " for Sync method: " + this.method.getName() + " in " + this.method.getDeclaringClass().getName());
        }
        throw new IllegalArgumentException("Unsupported exchange type: " + (exchange != null ? exchange.getClass().getName() : "null") + " for method: " + this.method.getName() + " in " + this.method.getDeclaringClass().getName());
    }

    @Override
    public McpSchema.ReadResourceResult apply(McpSyncServerExchange exchange, McpSchema.ReadResourceRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null");
        }
        try {
            Map uriVariableValues = this.uriTemplateManager.extractVariableValues(request.uri());
            if (!this.uriVariables.isEmpty() && uriVariableValues.size() != this.uriVariables.size()) {
                throw new IllegalArgumentException("Failed to extract all URI variables from request URI: " + request.uri() + ". Expected variables: " + String.valueOf(this.uriVariables) + ", but found: " + String.valueOf(uriVariableValues.keySet()));
            }
            Object[] args = this.buildArgs(this.method, exchange, request, uriVariableValues);
            this.method.setAccessible(true);
            Object result = this.method.invoke(this.bean, args);
            return this.resultConverter.convertToReadResourceResult(result, request.uri(), this.mimeType, this.contentType);
        }
        catch (Exception e) {
            McpError mcpError;
            if (e instanceof McpError && (mcpError = (McpError)e).getJsonRpcError() != null) {
                throw mcpError;
            }
            throw McpError.builder((int)-32602).message("Error invoking resource method: " + this.method.getName() + " in " + this.bean.getClass().getName() + ". /nCause: " + ErrorUtils.findCauseUsingPlainJava(e).getMessage()).data((Object)ErrorUtils.findCauseUsingPlainJava(e).getMessage()).build();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void validateReturnType(Method method) {
        boolean validReturnType;
        Class<?> returnType = method.getReturnType();
        boolean bl = validReturnType = McpSchema.ReadResourceResult.class.isAssignableFrom(returnType) || List.class.isAssignableFrom(returnType) || McpSchema.ResourceContents.class.isAssignableFrom(returnType) || String.class.isAssignableFrom(returnType);
        if (!validReturnType) {
            throw new IllegalArgumentException("Method must return either ReadResourceResult, List<ResourceContents>, List<String>, ResourceContents, or String: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    @Override
    protected boolean isExchangeOrContextType(Class<?> paramType) {
        return McpSyncServerExchange.class.isAssignableFrom(paramType);
    }

    public static class Builder
    extends AbstractMcpResourceMethodCallback.AbstractBuilder<Builder, SyncMcpResourceMethodCallback> {
        private Builder() {
            this.resultConverter = new DefaultMcpReadResourceResultConverter();
        }

        @Override
        public SyncMcpResourceMethodCallback build() {
            this.validate();
            return new SyncMcpResourceMethodCallback(this);
        }
    }
}

