/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.anthropic.api.AnthropicApi;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AnthropicChatOptions
implements ToolCallingChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="metadata")
    private AnthropicApi.ChatCompletionRequest.Metadata metadata;
    @JsonProperty(value="stop_sequences")
    private List<String> stopSequences;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="top_k")
    private Integer topK;
    @JsonIgnore
    private List<FunctionCallback> toolCallbacks = new ArrayList<FunctionCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();

    public static Builder builder() {
        return new Builder();
    }

    public static AnthropicChatOptions fromOptions(AnthropicChatOptions fromOptions) {
        return AnthropicChatOptions.builder().model(fromOptions.getModel()).maxTokens(fromOptions.getMaxTokens()).metadata(fromOptions.getMetadata()).stopSequences(fromOptions.getStopSequences()).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).topK(fromOptions.getTopK()).toolCallbacks(fromOptions.getToolCallbacks()).toolNames(fromOptions.getToolNames()).internalToolExecutionEnabled(fromOptions.isInternalToolExecutionEnabled()).toolContext(fromOptions.getToolContext()).build();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public AnthropicApi.ChatCompletionRequest.Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(AnthropicApi.ChatCompletionRequest.Metadata metadata) {
        this.metadata = metadata;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    @JsonIgnore
    public List<FunctionCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    @JsonIgnore
    public void setToolCallbacks(List<FunctionCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    public Set<String> getToolNames() {
        return this.toolNames;
    }

    @JsonIgnore
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @Nullable
    @JsonIgnore
    public Boolean isInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @JsonIgnore
    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    @Deprecated
    @JsonIgnore
    public List<FunctionCallback> getFunctionCallbacks() {
        return this.getToolCallbacks();
    }

    @Deprecated
    @JsonIgnore
    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.setToolCallbacks(functionCallbacks);
    }

    @Deprecated
    @JsonIgnore
    public Set<String> getFunctions() {
        return this.getToolNames();
    }

    @Deprecated
    @JsonIgnore
    public void setFunctions(Set<String> functionNames) {
        this.setToolNames(functionNames);
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    @Deprecated
    @JsonIgnore
    public Boolean getProxyToolCalls() {
        return this.internalToolExecutionEnabled != null ? Boolean.valueOf(this.internalToolExecutionEnabled == false) : null;
    }

    @Deprecated
    @JsonIgnore
    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.internalToolExecutionEnabled = proxyToolCalls != null ? Boolean.valueOf(proxyToolCalls == false) : null;
    }

    @JsonIgnore
    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    @JsonIgnore
    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public AnthropicChatOptions copy() {
        return AnthropicChatOptions.fromOptions(this);
    }

    public static class Builder {
        private final AnthropicChatOptions options = new AnthropicChatOptions();

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder model(AnthropicApi.ChatModel model) {
            this.options.model = model.getValue();
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder metadata(AnthropicApi.ChatCompletionRequest.Metadata metadata) {
            this.options.metadata = metadata;
            return this;
        }

        public Builder stopSequences(List<String> stopSequences) {
            this.options.stopSequences = stopSequences;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder topK(Integer topK) {
            this.options.topK = topK;
            return this;
        }

        public Builder toolCallbacks(List<FunctionCallback> toolCallbacks) {
            this.options.setToolCallbacks(toolCallbacks);
            return this;
        }

        public Builder toolCallbacks(FunctionCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.toolCallbacks.addAll(Arrays.asList(toolCallbacks));
            return this;
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(toolNames);
            return this;
        }

        public Builder toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            this.options.toolNames.addAll(Set.of(toolNames));
            return this;
        }

        public Builder internalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
            this.options.setInternalToolExecutionEnabled(internalToolExecutionEnabled);
            return this;
        }

        @Deprecated
        public Builder functionCallbacks(List<FunctionCallback> functionCallbacks) {
            return this.toolCallbacks(functionCallbacks);
        }

        @Deprecated
        public Builder functions(Set<String> functionNames) {
            return this.toolNames(functionNames);
        }

        @Deprecated
        public Builder function(String functionName) {
            return this.toolNames(functionName);
        }

        @Deprecated
        public Builder proxyToolCalls(Boolean proxyToolCalls) {
            if (proxyToolCalls != null) {
                this.options.setInternalToolExecutionEnabled(proxyToolCalls == false);
            }
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public AnthropicChatOptions build() {
            return this.options;
        }
    }
}

