/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.ai.anthropic.api.AnthropicApi;
import org.springframework.ai.anthropic.api.AnthropicCacheStrategy;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AnthropicChatOptions
implements ToolCallingChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="metadata")
    private AnthropicApi.ChatCompletionRequest.Metadata metadata;
    @JsonProperty(value="stop_sequences")
    private List<String> stopSequences;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="top_k")
    private Integer topK;
    @JsonProperty(value="thinking")
    private AnthropicApi.ChatCompletionRequest.ThinkingConfig thinking;
    @JsonIgnore
    private AnthropicCacheStrategy cacheStrategy = AnthropicCacheStrategy.NONE;
    @JsonIgnore
    private String cacheTtl = "5m";
    @JsonIgnore
    private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();
    @JsonIgnore
    private Map<String, String> httpHeaders = new HashMap<String, String>();

    public AnthropicCacheStrategy getCacheStrategy() {
        return this.cacheStrategy;
    }

    public void setCacheStrategy(AnthropicCacheStrategy cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
    }

    public String getCacheTtl() {
        return this.cacheTtl;
    }

    public void setCacheTtl(String cacheTtl) {
        this.cacheTtl = cacheTtl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AnthropicChatOptions fromOptions(AnthropicChatOptions fromOptions) {
        return AnthropicChatOptions.builder().model(fromOptions.getModel()).maxTokens(fromOptions.getMaxTokens()).metadata(fromOptions.getMetadata()).stopSequences((List<String>)(fromOptions.getStopSequences() != null ? new ArrayList<String>(fromOptions.getStopSequences()) : null)).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).topK(fromOptions.getTopK()).thinking(fromOptions.getThinking()).toolCallbacks((List<ToolCallback>)(fromOptions.getToolCallbacks() != null ? new ArrayList<ToolCallback>(fromOptions.getToolCallbacks()) : null)).toolNames((Set<String>)(fromOptions.getToolNames() != null ? new HashSet<String>(fromOptions.getToolNames()) : null)).internalToolExecutionEnabled(fromOptions.getInternalToolExecutionEnabled()).toolContext((Map<String, Object>)(fromOptions.getToolContext() != null ? new HashMap<String, Object>(fromOptions.getToolContext()) : null)).httpHeaders((Map<String, String>)(fromOptions.getHttpHeaders() != null ? new HashMap<String, String>(fromOptions.getHttpHeaders()) : null)).cacheStrategy(fromOptions.getCacheStrategy()).cacheTtl(fromOptions.getCacheTtl()).build();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public AnthropicApi.ChatCompletionRequest.Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(AnthropicApi.ChatCompletionRequest.Metadata metadata) {
        this.metadata = metadata;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public AnthropicApi.ChatCompletionRequest.ThinkingConfig getThinking() {
        return this.thinking;
    }

    public void setThinking(AnthropicApi.ChatCompletionRequest.ThinkingConfig thinking) {
        this.thinking = thinking;
    }

    @JsonIgnore
    public List<ToolCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    @JsonIgnore
    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    public Set<String> getToolNames() {
        return this.toolNames;
    }

    @JsonIgnore
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @Nullable
    @JsonIgnore
    public Boolean getInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @JsonIgnore
    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    @JsonIgnore
    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    @JsonIgnore
    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    @JsonIgnore
    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public AnthropicChatOptions copy() {
        return AnthropicChatOptions.fromOptions(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnthropicChatOptions)) {
            return false;
        }
        AnthropicChatOptions that = (AnthropicChatOptions)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.maxTokens, that.maxTokens) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.stopSequences, that.stopSequences) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.topP, that.topP) && Objects.equals(this.topK, that.topK) && Objects.equals(this.thinking, that.thinking) && Objects.equals(this.toolCallbacks, that.toolCallbacks) && Objects.equals(this.toolNames, that.toolNames) && Objects.equals(this.internalToolExecutionEnabled, that.internalToolExecutionEnabled) && Objects.equals(this.toolContext, that.toolContext) && Objects.equals(this.httpHeaders, that.httpHeaders) && Objects.equals((Object)this.cacheStrategy, (Object)that.cacheStrategy) && Objects.equals(this.cacheTtl, that.cacheTtl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.model, this.maxTokens, this.metadata, this.stopSequences, this.temperature, this.topP, this.topK, this.thinking, this.toolCallbacks, this.toolNames, this.internalToolExecutionEnabled, this.toolContext, this.httpHeaders, this.cacheStrategy, this.cacheTtl});
    }

    public static class Builder {
        private final AnthropicChatOptions options = new AnthropicChatOptions();

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder model(AnthropicApi.ChatModel model) {
            this.options.model = model.getValue();
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder metadata(AnthropicApi.ChatCompletionRequest.Metadata metadata) {
            this.options.metadata = metadata;
            return this;
        }

        public Builder stopSequences(List<String> stopSequences) {
            this.options.stopSequences = stopSequences;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder topK(Integer topK) {
            this.options.topK = topK;
            return this;
        }

        public Builder thinking(AnthropicApi.ChatCompletionRequest.ThinkingConfig thinking) {
            this.options.thinking = thinking;
            return this;
        }

        public Builder thinking(AnthropicApi.ThinkingType type, Integer budgetTokens) {
            this.options.thinking = new AnthropicApi.ChatCompletionRequest.ThinkingConfig(type, budgetTokens);
            return this;
        }

        public Builder toolCallbacks(List<ToolCallback> toolCallbacks) {
            this.options.setToolCallbacks(toolCallbacks);
            return this;
        }

        public Builder toolCallbacks(ToolCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.toolCallbacks.addAll(Arrays.asList(toolCallbacks));
            return this;
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(toolNames);
            return this;
        }

        public Builder toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            this.options.toolNames.addAll(Set.of(toolNames));
            return this;
        }

        public Builder internalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
            this.options.setInternalToolExecutionEnabled(internalToolExecutionEnabled);
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public Builder httpHeaders(Map<String, String> httpHeaders) {
            this.options.setHttpHeaders(httpHeaders);
            return this;
        }

        public Builder cacheStrategy(AnthropicCacheStrategy cacheStrategy) {
            this.options.cacheStrategy = cacheStrategy;
            return this;
        }

        public Builder cacheTtl(String cacheTtl) {
            this.options.cacheTtl = cacheTtl;
            return this;
        }

        public AnthropicChatOptions build() {
            return this.options;
        }
    }
}

