/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server.common.autoconfigure.annotations;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.springaicommunity.mcp.annotation.McpComplete;
import org.springaicommunity.mcp.annotation.McpPrompt;
import org.springaicommunity.mcp.annotation.McpResource;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springframework.ai.mcp.annotation.spring.scan.AbstractAnnotatedMethodBeanPostProcessor;
import org.springframework.ai.mcp.annotation.spring.scan.AbstractMcpAnnotatedBeans;
import org.springframework.ai.mcp.server.common.autoconfigure.annotations.McpServerAnnotationScannerProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={McpTool.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.server.annotation-scanner", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={McpServerAnnotationScannerProperties.class})
public class McpServerAnnotationScannerAutoConfiguration {
    private static final Set<Class<? extends Annotation>> SERVER_MCP_ANNOTATIONS = Set.of(McpTool.class, McpResource.class, McpPrompt.class, McpComplete.class);

    @Bean
    @ConditionalOnMissingBean
    public ServerMcpAnnotatedBeans serverAnnotatedBeanRegistry() {
        return new ServerMcpAnnotatedBeans();
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerAnnotatedMethodBeanPostProcessor serverAnnotatedMethodBeanPostProcessor(ServerMcpAnnotatedBeans serverMcpAnnotatedBeans, McpServerAnnotationScannerProperties properties) {
        return new ServerAnnotatedMethodBeanPostProcessor(serverMcpAnnotatedBeans, SERVER_MCP_ANNOTATIONS);
    }

    public static class ServerMcpAnnotatedBeans
    extends AbstractMcpAnnotatedBeans {
    }

    public static class ServerAnnotatedMethodBeanPostProcessor
    extends AbstractAnnotatedMethodBeanPostProcessor {
        public ServerAnnotatedMethodBeanPostProcessor(ServerMcpAnnotatedBeans serverMcpAnnotatedBeans, Set<Class<? extends Annotation>> targetAnnotations) {
            super((AbstractMcpAnnotatedBeans)serverMcpAnnotatedBeans, targetAnnotations);
        }
    }
}

