/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server.common.autoconfigure.annotations;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.springaicommunity.mcp.annotation.McpComplete;
import org.springaicommunity.mcp.annotation.McpPrompt;
import org.springaicommunity.mcp.annotation.McpResource;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springframework.ai.mcp.annotation.spring.scan.AbstractAnnotatedMethodBeanFactoryInitializationAotProcessor;
import org.springframework.ai.mcp.annotation.spring.scan.AbstractAnnotatedMethodBeanPostProcessor;
import org.springframework.ai.mcp.annotation.spring.scan.AbstractMcpAnnotatedBeans;
import org.springframework.ai.mcp.server.common.autoconfigure.annotations.McpServerAnnotationScannerProperties;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportRuntimeHints;

@AutoConfiguration
@ConditionalOnClass(value={McpTool.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.server.annotation-scanner", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={McpServerAnnotationScannerProperties.class})
@ImportRuntimeHints(value={AnnotationHints.class})
public class McpServerAnnotationScannerAutoConfiguration {
    private static final Set<Class<? extends Annotation>> SERVER_MCP_ANNOTATIONS = Set.of(McpTool.class, McpResource.class, McpPrompt.class, McpComplete.class);

    @Bean
    @ConditionalOnMissingBean
    public ServerMcpAnnotatedBeans serverAnnotatedBeanRegistry() {
        return new ServerMcpAnnotatedBeans();
    }

    @Bean
    @ConditionalOnMissingBean
    public static ServerAnnotatedMethodBeanPostProcessor serverAnnotatedMethodBeanPostProcessor(ServerMcpAnnotatedBeans serverMcpAnnotatedBeans, McpServerAnnotationScannerProperties properties) {
        return new ServerAnnotatedMethodBeanPostProcessor(serverMcpAnnotatedBeans, SERVER_MCP_ANNOTATIONS);
    }

    @Bean
    public static ServerAnnotatedBeanFactoryInitializationAotProcessor serverAnnotatedBeanFactoryInitializationAotProcessor() {
        return new ServerAnnotatedBeanFactoryInitializationAotProcessor(SERVER_MCP_ANNOTATIONS);
    }

    public static class ServerMcpAnnotatedBeans
    extends AbstractMcpAnnotatedBeans {
    }

    public static class ServerAnnotatedMethodBeanPostProcessor
    extends AbstractAnnotatedMethodBeanPostProcessor {
        public ServerAnnotatedMethodBeanPostProcessor(ServerMcpAnnotatedBeans serverMcpAnnotatedBeans, Set<Class<? extends Annotation>> targetAnnotations) {
            super((AbstractMcpAnnotatedBeans)serverMcpAnnotatedBeans, targetAnnotations);
        }
    }

    public static class ServerAnnotatedBeanFactoryInitializationAotProcessor
    extends AbstractAnnotatedMethodBeanFactoryInitializationAotProcessor {
        public ServerAnnotatedBeanFactoryInitializationAotProcessor(Set<Class<? extends Annotation>> targetAnnotations) {
            super(targetAnnotations);
        }
    }

    static class AnnotationHints
    implements RuntimeHintsRegistrar {
        AnnotationHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            SERVER_MCP_ANNOTATIONS.forEach(an -> hints.reflection().registerType(an, MemberCategory.values()));
        }
    }
}

