/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.azure.openai.autoconfigure;

import com.azure.ai.openai.OpenAIClientBuilder;
import org.springframework.ai.azure.openai.AzureOpenAiAudioTranscriptionModel;
import org.springframework.ai.model.azure.openai.autoconfigure.AzureOpenAiAudioTranscriptionProperties;
import org.springframework.ai.model.azure.openai.autoconfigure.AzureOpenAiClientBuilderConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@ConditionalOnClass(value={AzureOpenAiAudioTranscriptionModel.class})
@EnableConfigurationProperties(value={AzureOpenAiAudioTranscriptionProperties.class})
@ConditionalOnProperty(name={"spring.ai.model.audio.transcription"}, havingValue="azure-openai", matchIfMissing=true)
@Import(value={AzureOpenAiClientBuilderConfiguration.class})
public class AzureOpenAiAudioTranscriptionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AzureOpenAiAudioTranscriptionModel azureOpenAiAudioTranscriptionModel(OpenAIClientBuilder openAIClient, AzureOpenAiAudioTranscriptionProperties audioProperties) {
        return new AzureOpenAiAudioTranscriptionModel(openAIClient.buildClient(), audioProperties.getOptions());
    }
}

