/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.azure.openai.autoconfigure;

import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Header;
import com.azure.identity.DefaultAzureCredentialBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.ai.model.azure.openai.autoconfigure.AzureOpenAIClientBuilderCustomizer;
import org.springframework.ai.model.azure.openai.autoconfigure.AzureOpenAiConnectionProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConditionalOnClass(value={OpenAIClientBuilder.class})
@EnableConfigurationProperties(value={AzureOpenAiConnectionProperties.class})
public class AzureOpenAiClientBuilderConfiguration {
    private static final String APPLICATION_ID = "spring-ai";

    @Bean
    @ConditionalOnMissingBean
    public OpenAIClientBuilder openAIClientBuilder(AzureOpenAiConnectionProperties connectionProperties, ObjectProvider<AzureOpenAIClientBuilderCustomizer> customizers) {
        if (StringUtils.hasText((String)connectionProperties.getOpenAiApiKey())) {
            OpenAIClientBuilder clientBuilder = new OpenAIClientBuilder().endpoint("https://api.openai.com/v1").credential(new KeyCredential(connectionProperties.getOpenAiApiKey())).clientOptions(new ClientOptions().setApplicationId(APPLICATION_ID));
            this.applyOpenAIClientBuilderCustomizers(clientBuilder, customizers);
            return clientBuilder;
        }
        Map<String, String> customHeaders = connectionProperties.getCustomHeaders();
        List headers = customHeaders.entrySet().stream().map(entry -> new Header((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        ClientOptions clientOptions = new ClientOptions().setApplicationId(APPLICATION_ID).setHeaders(headers);
        Assert.hasText((String)connectionProperties.getEndpoint(), (String)"Endpoint must not be empty");
        OpenAIClientBuilder clientBuilder = !StringUtils.hasText((String)connectionProperties.getApiKey()) ? new OpenAIClientBuilder().endpoint(connectionProperties.getEndpoint()).credential((TokenCredential)new DefaultAzureCredentialBuilder().build()).clientOptions(clientOptions) : new OpenAIClientBuilder().endpoint(connectionProperties.getEndpoint()).credential((KeyCredential)new AzureKeyCredential(connectionProperties.getApiKey())).clientOptions(clientOptions);
        this.applyOpenAIClientBuilderCustomizers(clientBuilder, customizers);
        return clientBuilder;
    }

    private void applyOpenAIClientBuilderCustomizers(OpenAIClientBuilder clientBuilder, ObjectProvider<AzureOpenAIClientBuilderCustomizer> customizers) {
        customizers.orderedStream().forEach(customizer -> customizer.customize(clientBuilder));
    }
}

