/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.bedrock.autoconfigure;

import org.springframework.ai.model.bedrock.autoconfigure.BedrockAwsConnectionProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;

@Configuration
@EnableConfigurationProperties(value={BedrockAwsConnectionProperties.class})
public class BedrockAwsConnectionConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AwsCredentialsProvider credentialsProvider(BedrockAwsConnectionProperties properties) {
        if (StringUtils.hasText((String)properties.getAccessKey()) && StringUtils.hasText((String)properties.getSecretKey())) {
            if (StringUtils.hasText((String)properties.getSessionToken())) {
                return StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)properties.getAccessKey(), (String)properties.getSecretKey(), (String)properties.getSessionToken()));
            }
            return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)properties.getAccessKey(), (String)properties.getSecretKey()));
        }
        return DefaultCredentialsProvider.create();
    }

    @Bean
    @ConditionalOnMissingBean
    public AwsRegionProvider regionProvider(BedrockAwsConnectionProperties properties) {
        if (StringUtils.hasText((String)properties.getRegion())) {
            return new StaticRegionProvider(properties.getRegion());
        }
        return DefaultAwsRegionProviderChain.builder().build();
    }

    static class StaticRegionProvider
    implements AwsRegionProvider {
        private final Region region;

        StaticRegionProvider(String region) {
            try {
                this.region = Region.of((String)region);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The region '" + region + "' is not a valid region!", e);
            }
        }

        public Region getRegion() {
            return this.region;
        }
    }
}

