/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.google.genai.autoconfigure.embedding;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.google.genai.GoogleGenAiEmbeddingConnectionDetails;
import org.springframework.ai.google.genai.text.GoogleGenAiTextEmbeddingModel;
import org.springframework.ai.model.google.genai.autoconfigure.embedding.GoogleGenAiEmbeddingConnectionAutoConfiguration;
import org.springframework.ai.model.google.genai.autoconfigure.embedding.GoogleGenAiTextEmbeddingProperties;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;

@AutoConfiguration(after={SpringAiRetryAutoConfiguration.class, GoogleGenAiEmbeddingConnectionAutoConfiguration.class})
@ConditionalOnClass(value={GoogleGenAiTextEmbeddingModel.class})
@ConditionalOnProperty(name={"spring.ai.model.embedding.text"}, havingValue="google-genai", matchIfMissing=true)
@EnableConfigurationProperties(value={GoogleGenAiTextEmbeddingProperties.class})
public class GoogleGenAiTextEmbeddingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GoogleGenAiTextEmbeddingModel googleGenAiTextEmbedding(GoogleGenAiEmbeddingConnectionDetails connectionDetails, GoogleGenAiTextEmbeddingProperties textEmbeddingProperties, RetryTemplate retryTemplate, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<EmbeddingModelObservationConvention> observationConvention) {
        GoogleGenAiTextEmbeddingModel embeddingModel = new GoogleGenAiTextEmbeddingModel(connectionDetails, textEmbeddingProperties.getOptions(), retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((GoogleGenAiTextEmbeddingModel)embeddingModel).setObservationConvention(arg_0));
        return embeddingModel;
    }
}

