/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.openai.autoconfigure;

import java.util.HashMap;
import java.util.List;
import org.springframework.ai.model.openai.autoconfigure.OpenAiParentProperties;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class OpenAIAutoConfigurationUtil {
    private OpenAIAutoConfigurationUtil() {
    }

    @NonNull
    public static ResolvedConnectionProperties resolveConnectionProperties(OpenAiParentProperties commonProperties, OpenAiParentProperties modelProperties, String modelType) {
        String baseUrl = StringUtils.hasText((String)modelProperties.getBaseUrl()) ? modelProperties.getBaseUrl() : commonProperties.getBaseUrl();
        String apiKey = StringUtils.hasText((String)modelProperties.getApiKey()) ? modelProperties.getApiKey() : commonProperties.getApiKey();
        String projectId = StringUtils.hasText((String)modelProperties.getProjectId()) ? modelProperties.getProjectId() : commonProperties.getProjectId();
        String organizationId = StringUtils.hasText((String)modelProperties.getOrganizationId()) ? modelProperties.getOrganizationId() : commonProperties.getOrganizationId();
        HashMap<String, List<String>> connectionHeaders = new HashMap<String, List<String>>();
        if (StringUtils.hasText((String)projectId)) {
            connectionHeaders.put("OpenAI-Project", List.of(projectId));
        }
        if (StringUtils.hasText((String)organizationId)) {
            connectionHeaders.put("OpenAI-Organization", List.of(organizationId));
        }
        Assert.hasText((String)baseUrl, (String)("OpenAI base URL must be set.  Use the connection property: spring.ai.openai.base-url or spring.ai.openai." + modelType + ".base-url property."));
        Assert.hasText((String)apiKey, (String)("OpenAI API key must be set. Use the connection property: spring.ai.openai.api-key or spring.ai.openai." + modelType + ".api-key property."));
        return new ResolvedConnectionProperties(baseUrl, apiKey, (MultiValueMap<String, String>)CollectionUtils.toMultiValueMap(connectionHeaders));
    }

    public record ResolvedConnectionProperties(String baseUrl, String apiKey, MultiValueMap<String, String> headers) {
    }
}

