/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.vertexai.autoconfigure.gemini;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.vertexai.Transport;
import com.google.cloud.vertexai.VertexAI;
import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.autoconfigure.ToolCallingAutoConfiguration;
import org.springframework.ai.model.vertexai.autoconfigure.gemini.VertexAiGeminiChatProperties;
import org.springframework.ai.model.vertexai.autoconfigure.gemini.VertexAiGeminiConnectionProperties;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.ai.vertexai.gemini.VertexAiGeminiChatModel;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={SpringAiRetryAutoConfiguration.class, ToolCallingAutoConfiguration.class})
@ConditionalOnClass(value={VertexAI.class, VertexAiGeminiChatModel.class})
@ConditionalOnProperty(name={"spring.ai.model.chat"}, havingValue="vertexai", matchIfMissing=true)
@EnableConfigurationProperties(value={VertexAiGeminiChatProperties.class, VertexAiGeminiConnectionProperties.class})
public class VertexAiGeminiChatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public VertexAI vertexAi(VertexAiGeminiConnectionProperties connectionProperties) throws IOException {
        Assert.hasText((String)connectionProperties.getProjectId(), (String)"Vertex AI project-id must be set!");
        Assert.hasText((String)connectionProperties.getLocation(), (String)"Vertex AI location must be set!");
        Assert.notNull((Object)((Object)connectionProperties.getTransport()), (String)"Vertex AI transport must be set!");
        VertexAI.Builder vertexAIBuilder = new VertexAI.Builder().setProjectId(connectionProperties.getProjectId()).setLocation(connectionProperties.getLocation()).setTransport(Transport.valueOf((String)connectionProperties.getTransport().name()));
        if (StringUtils.hasText((String)connectionProperties.getApiEndpoint())) {
            vertexAIBuilder.setApiEndpoint(connectionProperties.getApiEndpoint());
        }
        if (!CollectionUtils.isEmpty(connectionProperties.getScopes())) {
            vertexAIBuilder.setScopes(connectionProperties.getScopes());
        }
        if (connectionProperties.getCredentialsUri() != null) {
            GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)connectionProperties.getCredentialsUri().getInputStream());
            vertexAIBuilder.setCredentials((Credentials)credentials);
        }
        return vertexAIBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public VertexAiGeminiChatModel vertexAiGeminiChat(VertexAI vertexAi, VertexAiGeminiChatProperties chatProperties, ToolCallingManager toolCallingManager, ApplicationContext context, RetryTemplate retryTemplate, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention, ObjectProvider<ToolExecutionEligibilityPredicate> vertexAiGeminiToolExecutionEligibilityPredicate) {
        VertexAiGeminiChatModel chatModel = VertexAiGeminiChatModel.builder().vertexAI(vertexAi).defaultOptions(chatProperties.getOptions()).toolCallingManager(toolCallingManager).toolExecutionEligibilityPredicate((ToolExecutionEligibilityPredicate)vertexAiGeminiToolExecutionEligibilityPredicate.getIfUnique(() -> new DefaultToolExecutionEligibilityPredicate())).retryTemplate(retryTemplate).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP)).build();
        observationConvention.ifAvailable(arg_0 -> ((VertexAiGeminiChatModel)chatModel).setObservationConvention(arg_0));
        return chatModel;
    }
}

