/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai.aot;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.implementation.OpenAIClientImpl;
import com.azure.ai.openai.models.ChatChoice;
import org.springframework.ai.aot.AiRuntimeHints;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class AzureOpenAiRuntimeHints
implements RuntimeHintsRegistrar {
    public void registerHints(@NonNull RuntimeHints hints, @Nullable ClassLoader classLoader) {
        MemberCategory[] mcs = MemberCategory.values();
        hints.reflection().registerType(OpenAIClient.class, mcs);
        hints.reflection().registerType(OpenAIAsyncClient.class, mcs);
        AiRuntimeHints.findClassesInPackage((String)ChatChoice.class.getPackageName(), (metadataReader, metadataReaderFactory) -> true).forEach(clazz -> hints.reflection().registerType(clazz, mcs));
        hints.proxies().registerJdkProxy(new Class[]{OpenAIClientImpl.OpenAIClientService.class});
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            for (Resource resourceMatch : resolver.getResources("/azure-ai-openai.properties")) {
                hints.resources().registerResource(resourceMatch);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

